/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.generator;

import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_4943;
import net.minecraft.class_4945;
import net.minecraft.class_5797;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pers.solid.brrp.v1.PlatformBridge;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.model.ModelJsonBuilder;

public interface ItemResourceGenerator {
    public static final Object2ObjectMap<@NotNull class_1792, @Nullable class_7800> ITEM_TO_RECIPE_CATEGORY = new Object2ObjectOpenHashMap();

    @Contract(pure=true)
    default public class_2960 getItemId() {
        return class_7923.field_41178.method_10221((Object)((class_1792)this));
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public class_2960 getItemModelId() {
        return this.getItemId().brrp_prefixed("item/");
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public class_2960 getTextureId() {
        return this.getItemId().brrp_prefixed("item/");
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(pure=true)
    default public ModelJsonBuilder getItemModel() {
        return new ModelJsonBuilder().parent(class_4943.field_22938).addTexture(class_4945.field_23006, this.getTextureId());
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeItemModel(RuntimeResourcePack pack) {
        ModelJsonBuilder model = this.getItemModel();
        if (model != null) {
            pack.addModel(this.getItemModelId(), model);
        }
    }

    @PreferredEnvironment(value=EnvType.CLIENT)
    @Contract(mutates="param1")
    default public void writeAssets(RuntimeResourcePack pack) {
        this.writeItemModel(pack);
    }

    @Contract(pure=true)
    default public class_5797 getCraftingRecipe() {
        return null;
    }

    @Contract(pure=true)
    default public class_7800 getRecipeCategory() {
        ItemResourceGenerator itemResourceGenerator = this;
        if (itemResourceGenerator instanceof class_1935) {
            class_1935 itemConvertible = (class_1935)itemResourceGenerator;
            return (class_7800)ITEM_TO_RECIPE_CATEGORY.getOrDefault((Object)itemConvertible.method_8389(), (Object)class_7800.field_40642);
        }
        return class_7800.field_40642;
    }

    default public void setRecipeCategory(@Nullable class_7800 recipeCategory) {
        ItemResourceGenerator itemResourceGenerator = this;
        if (!(itemResourceGenerator instanceof class_1935)) {
            throw new UnsupportedOperationException("Cannot invoke setRecipeCategory for non-ItemConvertible objects. Maybe you have to override this method.");
        }
        class_1935 itemConvertible = (class_1935)itemResourceGenerator;
        ITEM_TO_RECIPE_CATEGORY.put((Object)itemConvertible.method_8389(), (Object)recipeCategory);
    }

    @Contract(pure=true)
    default public class_2960 getRecipeId() {
        return this.getItemId();
    }

    @Contract(mutates="param1")
    default public void writeRecipes(RuntimeResourcePack pack) {
        @Nullable class_5797 recipe = this.getCraftingRecipe();
        if (recipe != null) {
            class_2960 recipeId = this.getRecipeId();
            pack.addRecipeAndAdvancement(recipeId, recipe);
        }
    }

    @Contract(mutates="param1")
    default public void writeData(RuntimeResourcePack pack) {
        this.writeRecipes(pack);
    }

    @Contract(mutates="param1")
    default public void writeAll(RuntimeResourcePack pack) {
        if (PlatformBridge.getInstance().isClientEnvironment()) {
            this.writeAssets(pack);
        }
        this.writeData(pack);
    }

    @Contract(mutates="param1")
    @ApiStatus.NonExtendable
    default public void writeResources(RuntimeResourcePack pack, @Nullable class_3264 resourceType) {
        if (resourceType == null) {
            this.writeAssets(pack);
            this.writeData(pack);
        } else if (resourceType == class_3264.field_14188) {
            this.writeAssets(pack);
        } else {
            this.writeData(pack);
        }
    }

    @Contract(mutates="param1")
    @ApiStatus.NonExtendable
    default public void writeResources(RuntimeResourcePack pack, boolean clientIncluded, boolean serverIncluded) {
        if (clientIncluded) {
            this.writeAssets(pack);
        }
        if (serverIncluded) {
            this.writeData(pack);
        }
    }
}

