/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1.api;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1320;
import net.minecraft.class_156;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1887;
import net.minecraft.class_2248;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3448;
import net.minecraft.class_5321;
import net.minecraft.class_7417;
import net.minecraft.class_7923;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public interface LanguageProvider {
    @Contract(value="-> new")
    public static Impl<HashMap<String, String>> create() {
        return new Impl<HashMap<String, String>>(new HashMap());
    }

    @Contract(value="-> new")
    public static Impl<TreeMap<String, String>> createSorted() {
        return new Impl<TreeMap<String, String>>(new TreeMap());
    }

    @Contract(value="_ -> new")
    public static <T extends Map<String, String>> Impl<T> create(T content) {
        return new Impl<T>(content);
    }

    @Contract(mutates="this", value="_, _ -> this")
    public LanguageProvider add(@NotNull String var1, String var2);

    public Map<String, String> content();

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull class_1792 item, String value) {
        return this.add(item.method_7876(), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull class_2248 block, String value) {
        return this.add(block.method_9539(), value);
    }

    default public LanguageProvider add(@NotNull class_1761 group, String value) {
        class_7417 content = group.method_7737().method_10851();
        if (content instanceof class_2588) {
            class_2588 translatableTextContent = (class_2588)content;
            return this.add(translatableTextContent.method_11022(), value);
        }
        throw new UnsupportedOperationException("Cannot add language entry for ItemGroup (%s) as the display name is not translatable.".formatted(group.method_7737().getString()));
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(class_1299<?> entityType, String value) {
        return this.add(entityType.method_5882(), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull class_5321<class_1887> enchantment, String value) {
        return this.add(class_156.method_646((String)"enchantment", (class_2960)enchantment.method_29177()), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull class_1320 entityAttribute, String value) {
        return this.add(entityAttribute.method_26830(), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull class_3448<?> statType, String value) {
        return this.add("stat_type." + class_7923.field_41193.method_10221(statType).toString().replace(':', '.'), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(class_1291 statusEffect, String value) {
        return this.add(statusEffect.method_5567(), value);
    }

    @Contract(mutates="this", value="_, _ -> this")
    default public LanguageProvider add(@NotNull class_2960 identifier, String value) {
        return this.add(identifier.method_42094(), value);
    }

    @Contract(mutates="this", value="_ -> this")
    public LanguageProvider addAll(@NotNull Map<String, String> var1);

    @Contract(mutates="this", value="_ -> this")
    default public LanguageProvider addAll(LanguageProvider another) {
        return this.addAll(another.content());
    }

    @ApiStatus.Internal
    public record Impl<T extends Map<String, String>>(T content) implements LanguageProvider
    {
        @Override
        public Impl<T> add(@NotNull String key, String value) {
            this.content.put((String)key, (String)value);
            return this;
        }

        @Override
        public Impl<T> addAll(@NotNull Map<String, String> map) {
            this.content.putAll(map);
            return this;
        }
    }
}

