/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import net.fabricmc.api.EnvType;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4941;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import pers.solid.brrp.v1.annotations.PreferredEnvironment;
import pers.solid.brrp.v1.generator.BlockResourceGenerator;
import pers.solid.brrp.v1.generator.ItemResourceGenerator;
import pers.solid.brrp.v1.generator.TextureRegistry;

public final class BRRPUtils {
    private BRRPUtils() {
    }

    @Contract(pure=true)
    public static class_2960 getItemId(@NotNull class_1935 item) {
        class_2960 class_29602;
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            class_29602 = generator.getItemId();
        } else {
            class_29602 = class_7923.field_41178.method_10221((Object)item.method_8389());
        }
        return class_29602;
    }

    @Contract(pure=true)
    @PreferredEnvironment(value=EnvType.CLIENT)
    public static class_2960 getItemModelId(@NotNull class_1935 item) {
        class_2960 class_29602;
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            class_29602 = generator.getItemModelId();
        } else {
            class_29602 = class_4941.method_25840((class_1792)item.method_8389());
        }
        return class_29602;
    }

    public static class_2960 getBlockId(@NotNull class_2248 block) {
        class_2960 class_29602;
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            class_29602 = generator.getBlockId();
        } else {
            class_29602 = class_7923.field_41175.method_10221((Object)block);
        }
        return class_29602;
    }

    @Contract(pure=true)
    @PreferredEnvironment(value=EnvType.CLIENT)
    public static class_2960 getBlockModelId(@NotNull class_2248 block) {
        class_2960 class_29602;
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            class_29602 = generator.getBlockModelId();
        } else {
            class_29602 = class_4941.method_25842((class_2248)block);
        }
        return class_29602;
    }

    @Contract(pure=true)
    @PreferredEnvironment(value=EnvType.CLIENT)
    public static class_2960 getTextureId(@NotNull class_2248 block, @NotNull class_4945 textureKey) {
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            return generator.getTextureId(textureKey);
        }
        class_2960 texture = TextureRegistry.getTexture(block, textureKey);
        if (texture != null) {
            return texture;
        }
        return BRRPUtils.getBlockId(block).brrp_prefixed("block/");
    }

    public static class_2960 getRecipeId(@NotNull class_1935 item) {
        if (item instanceof ItemResourceGenerator) {
            ItemResourceGenerator generator = (ItemResourceGenerator)item;
            return generator.getRecipeId();
        }
        return BRRPUtils.getItemId(item);
    }

    @Contract(pure=true)
    public static class_2960 getLootTableId(@NotNull class_2248 block) {
        if (block instanceof BlockResourceGenerator) {
            BlockResourceGenerator generator = (BlockResourceGenerator)block;
            return generator.getLootTableId();
        }
        return class_7923.field_41175.method_10221((Object)block).method_45138("blocks/");
    }

    public static <B extends class_2248> MapCodec<B> createCodecWithBaseBlock(RecordCodecBuilder<B, class_4970.class_2251> settingsCodec, BiFunction<class_2248, class_4970.class_2251, B> function) {
        return RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41175.method_39673().fieldOf("base_block").forGetter(rec$ -> ((BlockResourceGenerator)rec$).getBaseBlock()), (App)settingsCodec).apply((Applicative)instance, function));
    }
}

