/*
 * Decompiled with CFR 0.152.
 */
package pers.solid.brrp.v1;

import com.google.common.collect.Collections2;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2447;
import net.minecraft.class_2450;
import net.minecraft.class_2454;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3981;
import net.minecraft.class_4174;
import net.minecraft.class_44;
import net.minecraft.class_4719;
import net.minecraft.class_4943;
import net.minecraft.class_4945;
import net.minecraft.class_4970;
import net.minecraft.class_5658;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7710;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import net.minecraft.class_8074;
import net.minecraft.class_8076;
import net.minecraft.class_811;
import net.minecraft.class_9326;
import net.minecraft.class_9334;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.function.FailableFunction;
import org.apache.commons.lang3.function.FailableRunnable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.TestOnly;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pers.solid.brrp.v1.PlatformBridge;
import pers.solid.brrp.v1.RRPEventHelper;
import pers.solid.brrp.v1.api.LanguageProvider;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.generator.BRRPCubeBlock;
import pers.solid.brrp.v1.generator.BRRPFenceBlock;
import pers.solid.brrp.v1.generator.BRRPFenceGateBlock;
import pers.solid.brrp.v1.generator.BRRPSlabBlock;
import pers.solid.brrp.v1.generator.BRRPStairsBlock;
import pers.solid.brrp.v1.generator.BRRPWallBlock;
import pers.solid.brrp.v1.model.ModelJsonBuilder;
import pers.solid.brrp.v1.model.ModelOverrideBuilder;
import pers.solid.brrp.v1.model.TransformationBuilder;
import pers.solid.brrp.v1.tag.IdentifiedTagBuilder;

@TestOnly
@ApiStatus.Internal
public class BRRPTest {
    private static final class_2498 LAVA_SOUND_GROUP = new class_2498(1.0f, 1.0f, class_3417.field_15010, class_3417.field_14576, class_3417.field_15202, class_3417.field_14576, class_3417.field_28034);
    public static final BRRPCubeBlock LAVA_BLOCK = BRRPTest.register(BRRPCubeBlock.cubeAll(class_4970.class_2251.method_9637().method_51177().method_9631(state -> 15).method_9626(LAVA_SOUND_GROUP), class_2960.method_60654((String)"block/lava_still")), "lava_block");
    public static final BRRPStairsBlock LAVA_STAIRS = BRRPTest.register(new BRRPStairsBlock(LAVA_BLOCK), "lava_stairs");
    public static final BRRPSlabBlock LAVA_SLAB = BRRPTest.register(new BRRPSlabBlock(LAVA_BLOCK), "lava_slab");
    public static final BRRPFenceBlock LAVA_FENCE = BRRPTest.register(new BRRPFenceBlock(LAVA_BLOCK), "lava_fence");
    public static final BRRPFenceGateBlock LAVA_FENCE_GATE = BRRPTest.register(new BRRPFenceGateBlock(LAVA_BLOCK, class_4719.field_37657), "lava_fence_gate");
    public static final BRRPWallBlock LAVA_WALL = BRRPTest.register(new BRRPWallBlock(LAVA_BLOCK), "lava_wall");
    public static final BRRPCubeBlock SMOOTH_STONE = BRRPTest.register(BRRPCubeBlock.cubeBottomTop(class_4970.class_2251.method_9630((class_4970)class_2246.field_10360), class_2960.method_60654((String)"block/smooth_stone"), class_2960.method_60654((String)"block/smooth_stone_slab_side"), class_2960.method_60654((String)"block/smooth_stone")), "smooth_stone");
    private static final RuntimeResourcePack PACK = RuntimeResourcePack.create(class_2960.method_60655((String)"brrp", (String)"test"));
    private static final Logger LOGGER = LoggerFactory.getLogger(BRRPTest.class);

    private static class_1747 blockItem(class_2248 block) {
        class_1747 item = new class_1747(block, new class_1792.class_1793());
        PlatformBridge.getInstance().registerItem(class_7923.field_41175.method_10221((Object)block), (class_1792)item);
        return item;
    }

    private static void refreshPack(boolean clientIncluded, boolean serverIncluded) {
        LOGGER.info("Generating resources for the development environment.");
        if (clientIncluded) {
            PACK.clearResources(class_3264.field_14188);
            PACK.addLang(class_2960.method_60655((String)"brrp", (String)"en_us"), LanguageProvider.create().add(LAVA_BLOCK, "Lava Block (Development Environment Only)").add((class_2248)LAVA_STAIRS, "Lava Stairs (Development Environment Only)").add((class_2248)LAVA_SLAB, "Lava Slab (Development Environment Only)").add((class_2248)LAVA_FENCE, "Lava Fence (Development Environment Only)").add((class_2248)LAVA_FENCE_GATE, "Lava Fence Gate (Development Environment Only)").add((class_2248)LAVA_WALL, "Lava Wall (Development Environment Only)").add(SMOOTH_STONE, "Smooth Stone (Development Environment Only)"));
            PACK.addLang(class_2960.method_60655((String)"brrp", (String)"zh_cn"), LanguageProvider.create().add(LAVA_BLOCK, "\u7194\u5ca9\u65b9\u5757\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((class_2248)LAVA_STAIRS, "\u7194\u5ca9\u697c\u68af\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((class_2248)LAVA_SLAB, "\u7194\u5ca9\u53f0\u9636\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((class_2248)LAVA_FENCE, "\u7194\u5ca9\u6805\u680f\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((class_2248)LAVA_FENCE_GATE, "\u7194\u5ca9\u6805\u680f\u95e8\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add((class_2248)LAVA_WALL, "\u7194\u5ca9\u5899\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09").add(SMOOTH_STONE, "\u5e73\u6ed1\u77f3\u5934\uff08\u4ec5\u9650\u5f00\u53d1\u73af\u5883\uff09"));
            LanguageProvider twLang = LanguageProvider.create().add(LAVA_BLOCK, "\u7194\u5ca9\u65b9\u584a\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((class_2248)LAVA_STAIRS, "\u7194\u5ca9\u968e\u68af\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((class_2248)LAVA_SLAB, "\u7194\u5ca9\u534a\u78da\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((class_2248)LAVA_FENCE, "\u7194\u5ca9\u67f5\u6b04\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((class_2248)LAVA_FENCE_GATE, "\u7194\u5ca9\u67f5\u6b04\u9580\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((class_2248)LAVA_WALL, "\u7194\u5ca9\u58bb\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add(SMOOTH_STONE, "\u5e73\u6ed1\u77f3\u982d\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09");
            PACK.addLang(class_2960.method_60655((String)"brrp", (String)"zh_tw"), twLang);
            PACK.addLang(class_2960.method_60655((String)"brrp", (String)"zh_hk"), twLang.add((class_2248)LAVA_FENCE, "\u7194\u5ca9\u6b04\u6746\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09").add((class_2248)LAVA_FENCE_GATE, "\u7194\u5ca9\u9598\u9580\uff08\u50c5\u9650\u958b\u767c\u74b0\u5883\uff09"));
        }
        if (serverIncluded) {
            PACK.clearResources(class_3264.field_14190);
            IdentifiedTagBuilder stairs = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((class_6862<class_2248>)class_3481.field_15459).add((class_2248)LAVA_STAIRS));
            PACK.addTag(stairs);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((class_6862<class_1792>)class_3489.field_15526, stairs));
            IdentifiedTagBuilder slabs = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((class_6862<class_2248>)class_3481.field_15469).add((class_2248)LAVA_SLAB));
            PACK.addTag(slabs);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((class_6862<class_1792>)class_3489.field_15535, slabs));
            IdentifiedTagBuilder fences = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((class_6862<class_2248>)class_3481.field_16584).add((class_2248)LAVA_FENCE));
            PACK.addTag(fences);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((class_6862<class_1792>)class_3489.field_16585, fences));
            IdentifiedTagBuilder fenceGates = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((class_6862<class_2248>)class_3481.field_25147).add((class_2248)LAVA_FENCE_GATE));
            PACK.addTag(fenceGates);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((class_6862<class_1792>)class_3489.field_40858, fenceGates));
            IdentifiedTagBuilder walls = (IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((class_6862<class_2248>)class_3481.field_15504).add((class_2248)LAVA_WALL));
            PACK.addTag(walls);
            PACK.addTag(IdentifiedTagBuilder.createItemCopy((class_6862<class_1792>)class_3489.field_15560, walls));
            PACK.addTag((IdentifiedTagBuilder)((Object)IdentifiedTagBuilder.createBlock((class_6862<class_2248>)class_3481.field_33715).add(SMOOTH_STONE)));
            PACK.addRecipeAndAdvancement(class_2960.method_60655((String)"brrp", (String)"smooth_stone_slab"), (class_5797)((class_2447)((class_2447)class_2447.method_10436(null, (class_1935)class_2246.field_10136, (int)6).method_10439("###").method_10434(Character.valueOf('#'), (class_1935)SMOOTH_STONE).criterionFromItem((class_1935)SMOOTH_STONE)).setCustomCraftingCategory(class_7710.field_40251)).setCustomRecipeCategory("brrp_custom"));
            PACK.addRecipeAndAdvancement(class_2960.method_60655((String)"brrp", (String)"smooth_stone_slab_from_stonecutting"), (class_5797)((class_3981)class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{SMOOTH_STONE}), null, (class_1935)class_2246.field_10136).criterionFromItem((class_1935)SMOOTH_STONE)).setCustomRecipeCategory("brrp_custom"));
            class_9326 bedrockTestComponentChanges = class_9326.method_57841().method_57854(class_9334.field_50075, (Object)new class_4174.class_4175().method_19238(20).method_19237(20.0f).method_19240().method_19241().method_19239(new class_1293(class_1294.field_50118, 60), 1.0f).method_19242()).method_57854(class_9334.field_50239, (Object)class_2561.method_43470((String)"Unobtainable!")).method_57852();
            PACK.addRecipeAndAdvancement(class_2960.method_60655((String)"brrp", (String)"cook_bedrock"), (class_5797)((class_2454)((class_2454)class_2454.method_17802((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8542}), null, (class_1935)class_1802.field_8077, (float)1000.0f, (int)2).setCustomRecipeCategory("brrp_custom")).criterionFromItem((class_1935)class_1802.field_8542)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(class_2960.method_60655((String)"brrp", (String)"unobtainable_shaped"), (class_5797)((class_2447)((class_2447)((class_2447)class_2447.method_10437(null, (class_1935)class_1802.field_8542).patterns(new String[]{"xx", "xx"}).method_10434(Character.valueOf('x'), (class_1935)class_1802.field_8542).setBypassesValidation(true)).setCustomRecipeCategory("brrp_custom")).setCustomCraftingCategory(class_7710.field_40251)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(class_2960.method_60655((String)"brrp", (String)"unobtainable_shapeless"), (class_5797)((class_2450)((class_2450)((class_2450)((class_2450)class_2450.method_10447(null, (class_1935)class_1802.field_8542).method_10449((class_1935)class_1802.field_20391, 5).criterionFromItem((class_1935)class_1802.field_20391)).setCustomRecipeCategory("brrp_custom")).setBypassesValidation(true)).setCustomCraftingCategory(class_7710.field_40251)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(class_2960.method_60655((String)"brrp", (String)"unobtainable_single_item"), (class_5797)((class_3981)((class_3981)class_3981.method_17968((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_20391}), null, (class_1935)class_1802.field_8542).setCustomRecipeCategory("brrp_custom")).setBypassesValidation(true)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(class_2960.method_60655((String)"brrp", (String)"smithing_transform"), (class_8074)((class_8074)((class_8074)class_8074.method_48535((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_20391}), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8759}), null, (class_1792)class_1802.field_8542).setCustomRecipeCategory("brrp_custom")).setBypassesValidation(true)).setComponentChanges(bedrockTestComponentChanges));
            PACK.addRecipeAndAdvancement(class_2960.method_60655((String)"brrp", (String)"smithing_trim"), (class_8076)((class_8076)class_8076.method_48540((class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8477}), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_20391}), (class_1856)class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8725}), (class_7800)class_7800.field_40634).setCustomRecipeCategory("brrp_custom")).setBypassesValidation(true));
        }
        LAVA_BLOCK.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_STAIRS.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_SLAB.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_FENCE.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_FENCE_GATE.writeResources(PACK, clientIncluded, serverIncluded);
        LAVA_WALL.writeResources(PACK, clientIncluded, serverIncluded);
        SMOOTH_STONE.writeResources(PACK, clientIncluded, serverIncluded);
        LOGGER.info("Resources generation finished for the development environment.");
    }

    @Contract(value="_,_ -> param1")
    private static <T extends class_2248> T register(T block, String name) {
        PlatformBridge.getInstance().registerBlock(class_2960.method_60655((String)"brrp", (String)name), block);
        return block;
    }

    public static void registerPacks() {
        BRRPTest.refreshPack(true, true);
        RRPEventHelper.BEFORE_VANILLA.registerPack(PACK);
        PACK.setDisplayName((class_2561)class_2561.method_43471((String)"brrp.pack.test.name"));
        PACK.setDescription((class_2561)class_2561.method_43471((String)"brrp.pack.test.description"));
        PACK.setSidedRegenerationCallback(class_3264.field_14188, (FailableRunnable<InterruptedException>)((FailableRunnable)() -> BRRPTest.refreshPack(true, false)));
        PACK.setSidedRegenerationCallback(class_3264.field_14190, (FailableRunnable<InterruptedException>)((FailableRunnable)() -> BRRPTest.refreshPack(false, true)));
        RuntimeResourcePack emptyPack = RuntimeResourcePack.create(class_2960.method_60655((String)"brrp", (String)"empty"));
        emptyPack.setDisplayName((class_2561)class_2561.method_43471((String)"brrp.pack.empty.name"));
        emptyPack.setDescription((class_2561)class_2561.method_43471((String)"brrp.pack.empty.description"));
        RRPEventHelper.BEFORE_VANILLA.registerPack(emptyPack);
        RuntimeResourcePack beforeUser = RuntimeResourcePack.create(class_2960.method_60655((String)"brrp", (String)"test_before_user"));
        beforeUser.setDisplayName((class_2561)class_2561.method_43471((String)"brrp.pack.test_before_user.name"));
        beforeUser.setDescription((class_2561)class_2561.method_43471((String)"brrp.pack.test_before_user.description"));
        beforeUser.addModel(class_2960.method_60655((String)"minecraft", (String)"item/yellow_wool"), ModelJsonBuilder.create(class_4943.field_22939).addTexture(class_4945.field_23006, class_2960.method_60654((String)"block/yellow_wool")));
        beforeUser.addAsyncResource(class_3264.field_14188, class_2960.method_60654((String)"models/item/gold_ingot.json"), (FailableFunction<class_2960, byte[], Exception>)((FailableFunction)input -> {
            LOGGER.info("async resource!");
            return beforeUser.serialize(ModelJsonBuilder.create(class_4943.field_22939).addTexture(class_4945.field_23006, class_2960.method_60654((String)"item/gold_ingot")).transformation(class_811.field_4318, new TransformationBuilder().translation(0.0f, 4.5f, 0.0f).scale(9.0f, 9.0f, 9.0f)));
        }));
        beforeUser.addLazyResource(class_3264.field_14188, class_2960.method_60654((String)"models/item/diamond.json"), (pack, identifier) -> {
            LOGGER.info("lazy resource!");
            return beforeUser.serialize(ModelJsonBuilder.create(class_4943.field_22939).addTexture(class_4945.field_23006, class_2960.method_60654((String)"item/diamond")).transformation(class_811.field_4318, new TransformationBuilder().translation(0.0f, 4.5f, 0.0f).scale(10.85f, 10.85f, 10.6f)));
        });
        beforeUser.addLang(class_2960.method_60655((String)"minecraft", (String)"en_us"), LanguageProvider.create().add(class_2246.field_10490, "The model is modified by a 'before-user' runtime resource pack."));
        beforeUser.addLootTable(class_2246.field_10490.method_26162().method_29177(), beforeUser.getBlockLootTableGenerator().method_45979((class_1935)class_2246.field_10490, (class_5658)class_44.method_32448((float)3.0f)));
        beforeUser.addModel(class_2960.method_60655((String)"minecraft", (String)"item/bow"), ModelJsonBuilder.create(class_2960.method_60655((String)"minecraft", (String)"item/white_concrete")).addOverride(ModelOverrideBuilder.of(class_2960.method_60654((String)"item/yellow_concrete"), class_2960.method_60654((String)"pulling"), 1.0f)).addOverride(ModelOverrideBuilder.of(class_2960.method_60654((String)"item/orange_concrete"), class_2960.method_60654((String)"pulling"), 1.0f).addCondition(class_2960.method_60654((String)"pull"), 0.65f)).addOverride(ModelOverrideBuilder.of(class_2960.method_60654((String)"item/red_concrete"), class_2960.method_60654((String)"pulling"), 1.0f).addCondition(class_2960.method_60654((String)"pull"), 0.9f)));
        RRPEventHelper.BEFORE_USER.registerPack(beforeUser);
        RuntimeResourcePack test2 = RuntimeResourcePack.create(class_2960.method_60655((String)"brrp", (String)"test2"));
        test2.setSidedRegenerationCallback(class_3264.field_14188, (FailableRunnable<InterruptedException>)((FailableRunnable)() -> {
            test2.clearResources(class_3264.field_14188);
            for (int i = 0; i < 1024; ++i) {
                Thread.sleep(ThreadLocalRandom.current().nextLong(20L));
                test2.addAsset(class_2960.method_60655((String)"brrp", (String)("test/" + ThreadLocalRandom.current().nextInt())), new byte[16]);
            }
        }));
        test2.setSidedRegenerationCallback(class_3264.field_14190, (FailableRunnable<InterruptedException>)((FailableRunnable)() -> {
            test2.clearResources(class_3264.field_14190);
            for (int i = 0; i < 1024; ++i) {
                Thread.sleep(ThreadLocalRandom.current().nextLong(20L));
                test2.addData(class_2960.method_60655((String)"brrp", (String)("test/" + ThreadLocalRandom.current().nextInt())), new byte[16]);
            }
        }));
        RRPEventHelper.BEFORE_VANILLA.registerPack(test2);
    }

    static {
        Validate.validState((boolean)PlatformBridge.getInstance().isDevelopmentEnvironment(), (String)"The class 'BRRPDevelopment' should not be loaded outside of the development environment.", (Object[])new Object[0]);
        BRRPTest.blockItem(LAVA_BLOCK);
        BRRPTest.blockItem((class_2248)LAVA_STAIRS);
        BRRPTest.blockItem((class_2248)LAVA_SLAB);
        BRRPTest.blockItem((class_2248)LAVA_FENCE);
        BRRPTest.blockItem((class_2248)LAVA_FENCE_GATE);
        BRRPTest.blockItem((class_2248)LAVA_WALL);
        BRRPTest.blockItem(SMOOTH_STONE);
        LAVA_BLOCK.setRecipeCategory(class_7800.field_40634);
        LAVA_STAIRS.setRecipeCategory(class_7800.field_40634);
        LAVA_SLAB.setRecipeCategory(class_7800.field_40634);
        LAVA_FENCE.setRecipeCategory(class_7800.field_40635);
        LAVA_FENCE_GATE.setRecipeCategory(class_7800.field_40635);
        LAVA_WALL.setRecipeCategory(class_7800.field_40635);
        SMOOTH_STONE.setRecipeCategory(class_7800.field_40634);
        PlatformBridge.getInstance().setItemGroup(Collections2.transform(List.of(LAVA_BLOCK, LAVA_STAIRS, LAVA_SLAB, LAVA_FENCE, LAVA_FENCE_GATE, LAVA_WALL, SMOOTH_STONE), x$0 -> new class_1799((class_1935)x$0)));
    }
}

