/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.util;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.packets.PathGraphSyncPacket;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.util.NetworkUtils;

public class PathSyncUtils {
    public static void syncPathGraphToAllPlayers(class_3218 level) {
        try {
            IPathStorage storage = IPathStorage.get((class_1937)level);
            if (storage == null) {
                return;
            }
            PathGraph graph = storage.graph();
            if (CommonConfig.enable_surveyor_landmark && CommonConfig.enable_surveyor_landmark_coloring) {
                try {
                    graph.updateAllNetworkColors(level);
                }
                catch (NullPointerException e) {
                    ViaRomana.LOGGER.warn("Surveyor landmark system not ready yet, skipping network color update for sync");
                }
            }
            PathGraphSyncPacket packet = new PathGraphSyncPacket(graph);
            for (class_3222 player2 : level.method_18766(player -> true)) {
                NetworkUtils.sendToPlayer((class_1657)player2, packet);
            }
            ViaRomana.LOGGER.info("Synced PathGraph with {} nodes to {} players", (Object)graph.size(), (Object)level.method_18766(player -> true).size());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync PathGraph to players in level " + String.valueOf(level.method_27983().method_29177()), (Throwable)e);
        }
    }

    public static void syncPathGraphToPlayer(class_3222 player) {
        try {
            class_3218 level = player.method_51469();
            IPathStorage storage = IPathStorage.get((class_1937)level);
            if (storage == null) {
                return;
            }
            PathGraphSyncPacket packet = new PathGraphSyncPacket(storage.graph());
            NetworkUtils.sendToPlayer((class_1657)player, packet);
            ViaRomana.LOGGER.debug("Synced PathGraph with {} nodes to player {}", (Object)storage.graph().size(), (Object)player.method_5477().getString());
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to sync PathGraph to player " + player.method_5477().getString(), (Throwable)e);
        }
    }

    public static void syncNetworkInvalidationToPlayers(class_3218 level, int networkId) {
    }
}

