/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.teleport;

import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.util.EffectUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class TeleportHelper {
    public static Optional<class_2338> findDestination(class_2586 source, class_2586 dest, class_1937 level) {
        class_2338 sourcePos = source.method_11016();
        class_2338 destPos = dest.method_11016();
        PathGraph graph = IPathStorage.get(level).graph();
        Optional<Node> sourceNode = graph.getNodeBySignPos(sourcePos);
        Optional<Node> destNode = graph.getNodeBySignPos(destPos);
        if (sourceNode.isEmpty() || destNode.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(destNode.get().getBlockPos());
    }

    public static void cycle(class_1936 world, class_1297 entity) {
        double fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
        boolean isIncreasing = VariableAccess.playerVariables.isFadeIncrease(entity);
        if (fadeAmount > 0.0 || fadeAmount == 0.0 && isIncreasing) {
            TeleportHelper.handleFadeEffect(world, entity);
            fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
            if (fadeAmount >= 15.0) {
                VariableAccess.playerVariables.setFadeIncrease(entity, false);
                VariableAccess.playerVariables.syncAndSave(entity);
            }
            if (fadeAmount == 0.0 && !VariableAccess.playerVariables.isFadeIncrease(entity)) {
                VariableAccess.playerVariables.setFadeAmount(entity, 0.0);
                VariableAccess.playerVariables.setFadeIncrease(entity, false);
                VariableAccess.playerVariables.setLastNodePos(entity, class_2338.field_10980);
                VariableAccess.playerVariables.syncAndSave(entity);
            }
        }
    }

    public static void effect(class_1936 world, class_1297 entity) {
        double fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
        if (fadeAmount > 0.0) {
            double particleRadius = 4.0;
            if (world instanceof class_3218) {
                class_3218 serverLevel = (class_3218)world;
                serverLevel.method_14199((class_2394)class_2398.field_11215, entity.method_23317() + class_3532.method_15366((class_5819)class_5819.method_43047(), (double)-0.1, (double)0.1) * particleRadius, entity.method_23318() + fadeAmount * 0.15, entity.method_23321() + class_3532.method_15366((class_5819)class_5819.method_43047(), (double)-0.1, (double)0.1) * particleRadius, 32, class_3532.method_15366((class_5819)class_5819.method_43047(), (double)-0.1, (double)0.1) * particleRadius, fadeAmount * 0.02, class_3532.method_15366((class_5819)class_5819.method_43047(), (double)-0.1, (double)0.1) * particleRadius, 0.5);
            }
        }
    }

    private static void playFootstepSound(class_1936 world, class_2338 soundSource) {
        if (!(world instanceof class_1937)) {
            return;
        }
        class_1937 level = (class_1937)world;
        class_2680 blockState = world.method_8320(soundSource);
        class_2960 soundId = class_7923.field_41172.method_10221((Object)blockState.method_26231().method_10594());
        if (soundId == null) {
            soundId = class_2960.method_60654((String)"minecraft:block.grass.step");
        }
        if (!level.method_8608()) {
            level.method_8396(null, soundSource, (class_3414)class_7923.field_41172.method_10223(soundId), class_3419.field_15245, 0.2f, 1.0f);
        } else {
            level.method_8486((double)soundSource.method_10263(), (double)soundSource.method_10264(), (double)soundSource.method_10260(), (class_3414)class_7923.field_41172.method_10223(soundId), class_3419.field_15245, 0.2f, 1.0f, false);
        }
    }

    private static void handleFadeEffect(class_1936 world, class_1297 entity) {
        double fadeAmount = VariableAccess.playerVariables.getFadeAmount(entity);
        if (fadeAmount >= 0.0 && fadeAmount <= 15.0) {
            boolean isIncreasing;
            if (fadeAmount % 7.0 == 0.0) {
                TeleportHelper.playFootstepSound(world, entity.method_23312());
            }
            double newFadeAmount = (isIncreasing = VariableAccess.playerVariables.isFadeIncrease(entity)) ? fadeAmount + 1.0 : fadeAmount - 1.0;
            newFadeAmount = Math.max(0.0, Math.min(15.0, newFadeAmount));
            VariableAccess.playerVariables.setFadeAmount(entity, newFadeAmount);
            VariableAccess.playerVariables.syncAndSave(entity);
            if (fadeAmount == 1.0) {
                EffectUtils.applyEffect(entity, "travellers_fatigue", world);
            }
        }
    }

    public static class TeleportDestination {
        public final class_2338 position;
        public final String name;
        public final double distance;
        public final Node.Icon icon;

        public TeleportDestination(class_2338 position, String name, double distance, Node.Icon icon) {
            this.position = position;
            this.name = name;
            this.distance = distance;
            this.icon = icon;
        }
    }
}

