/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.tags;

import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3495;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import pers.solid.brrp.v1.api.RuntimeResourcePack;

public class TagGenerator {
    public static void generateAllTags(RuntimeResourcePack pack) {
        try {
            pack.clearResources(class_3264.field_14190);
            class_6862 pathBlockTagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"via_romana", (String)"path_block"));
            class_6862 warpBlockTagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"via_romana", (String)"warp_block"));
            class_3495 pathTagBuilder = TagGenerator.generatePathBlockTagBuilder();
            class_3495 warpTagBuilder = TagGenerator.generateWarpBlockTagBuilder();
            pack.addTag(pathBlockTagKey, pathTagBuilder);
            pack.addTag(warpBlockTagKey, warpTagBuilder);
            ViaRomana.LOGGER.info("Successfully generated dynamic tags to runtime resource pack");
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error("Failed to generate tag files", (Throwable)e);
        }
    }

    private static class_3495 generatePathBlockTagBuilder() {
        class_3495 tagBuilder = TagGenerator.generateBlockTagBuilder(CommonConfig.path_block_ids, CommonConfig.path_block_tags, CommonConfig.path_block_strings);
        return tagBuilder;
    }

    private static class_3495 generateWarpBlockTagBuilder() {
        class_3495 tagBuilder = TagGenerator.generateBlockTagBuilder(CommonConfig.warp_block_ids, CommonConfig.warp_block_tags, null);
        return tagBuilder;
    }

    private static class_3495 generateBlockTagBuilder(List<String> explicitIds, List<String> tagStrings, List<String> searchStrings) {
        class_3495 tagBuilder = class_3495.method_26778();
        for (String blockId : explicitIds) {
            if (blockId.isEmpty() || TagGenerator.isBlacklistedBlock(blockId)) continue;
            try {
                class_2960 blockLocation = class_2960.method_60654((String)blockId);
                tagBuilder.method_26784(blockLocation);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Invalid block ID in config: {}", (Object)blockId);
            }
        }
        for (String tagString : tagStrings) {
            if (tagString.isEmpty() || !TagGenerator.isModLoadedForTag(tagString) || TagGenerator.isBlacklistedBlock(tagString)) continue;
            try {
                class_2960 tagLocation = class_2960.method_60654((String)tagString);
                tagBuilder.method_26787(tagLocation);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Invalid tag reference in config: {}", (Object)tagString);
            }
        }
        if (searchStrings != null && !searchStrings.isEmpty()) {
            block6: for (class_2248 block : class_7923.field_41175) {
                class_2960 blockId = class_7923.field_41175.method_10221((Object)block);
                String blockIdString = blockId.toString();
                if (TagGenerator.isBlacklistedBlock(blockIdString)) continue;
                for (String searchString : searchStrings) {
                    if (searchString.isEmpty() || !blockIdString.contains(searchString.toLowerCase())) continue;
                    tagBuilder.method_26784(blockId);
                    continue block6;
                }
            }
        }
        return tagBuilder;
    }

    private static boolean isModLoadedForTag(String tagString) {
        try {
            class_2960 tagLocation = class_2960.method_60654((String)tagString);
            String modId = tagLocation.method_12836();
            return "minecraft".equals(modId) || FabricLoader.getInstance().isModLoaded(modId);
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Invalid tag format: '{}'", (Object)tagString);
            return false;
        }
    }

    private static boolean isBlacklistedBlock(String blockIdString) {
        for (String blacklistString : CommonConfig.block_string_blacklist) {
            if (blacklistString.isEmpty() || !blockIdString.contains(blacklistString.toLowerCase())) continue;
            ViaRomana.LOGGER.debug("Blacklisted block: '{}' from Via Romana block tag", (Object)blockIdString);
            return true;
        }
        return false;
    }
}

