/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.path;

import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1767;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.map.ServerMapUtils;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.surveyor.ViaRomanaLandmark;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PathGraph {
    private final ObjectArrayList<Node> nodes = new ObjectArrayList();
    private final Long2IntOpenHashMap posToIndex = new Long2IntOpenHashMap();
    private final Long2IntOpenHashMap signPosToIndex = new Long2IntOpenHashMap();
    private final ConcurrentMap<UUID, NetworkCache> networkCacheById = new ConcurrentHashMap<UUID, NetworkCache>();
    private final Long2ObjectOpenHashMap<UUID> nodeToNetworkId = new Long2ObjectOpenHashMap();
    private final ConcurrentMap<UUID, FoWCache> fowCacheById = new ConcurrentHashMap<UUID, FoWCache>();
    private static final class_1767[] NETWORK_COLORS = new class_1767[]{class_1767.field_7966, class_1767.field_7964, class_1767.field_7942, class_1767.field_7945, class_1767.field_7955, class_1767.field_7946, class_1767.field_7961, class_1767.field_7954, class_1767.field_7958, class_1767.field_7947};

    public static PathGraph getInstance(class_3218 level) {
        return IPathStorage.get((class_1937)level).graph();
    }

    @NotNull
    private NetworkCache getNetworkCacheForNode(Node startNode) {
        NetworkCache cached;
        UUID networkId = (UUID)this.nodeToNetworkId.get(startNode.getPos());
        if (networkId != null && (cached = (NetworkCache)this.networkCacheById.get(networkId)) != null) {
            return cached;
        }
        return this.discoverAndCacheNetwork(startNode);
    }

    private NetworkCache discoverAndCacheNetwork(Node startNode) {
        List<Node> networkNodes = this.getNetwork(startNode);
        Set<Long> positions = networkNodes.stream().map(Node::getPos).collect(Collectors.toSet());
        UUID networkId = this.generateDeterministicUUID(positions);
        NetworkCache existingCache = (NetworkCache)this.networkCacheById.get(networkId);
        if (existingCache != null) {
            this.nodeToNetworkId.put(startNode.getPos(), (Object)networkId);
            return existingCache;
        }
        BoundingBox bounds = this.calculateBoundsFor(networkNodes);
        List<Node> destinations = networkNodes.stream().filter(n -> n.getLinkType() == Node.LinkType.DESTINATION || n.getLinkType() == Node.LinkType.PRIVATE).toList();
        NetworkCache newCache = new NetworkCache(networkId, positions, bounds, destinations);
        this.networkCacheById.put(networkId, newCache);
        for (Long pos : positions) {
            this.nodeToNetworkId.put(pos, (Object)networkId);
        }
        this.fowCacheById.remove(networkId);
        return newCache;
    }

    private Set<NetworkCache> invalidateNetworksContaining(Node ... nodesToInvalidate) {
        HashSet<NetworkCache> invalidatedCaches = new HashSet<NetworkCache>();
        for (Node node : nodesToInvalidate) {
            List<Node> component = this.getNetwork(node);
            if (component.isEmpty()) continue;
            Set<Long> positions = component.stream().map(Node::getPos).collect(Collectors.toSet());
            UUID componentId = this.generateDeterministicUUID(positions);
            NetworkCache removedCache = (NetworkCache)this.networkCacheById.remove(componentId);
            if (removedCache != null) {
                invalidatedCaches.add(removedCache);
            }
            this.fowCacheById.remove(componentId);
            for (Node n : component) {
                this.nodeToNetworkId.remove(n.getPos());
            }
            try {
                ServerMapCache.invalidate(componentId);
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Failed to invalidate ServerMapCache for network {}: {}", (Object)componentId, (Object)e.getMessage());
            }
        }
        return invalidatedCaches;
    }

    private void refreshNetworkDestinations(Node startNode) {
        NetworkCache existing = this.getNetworkCacheForNode(startNode);
        List<Node> destinations = this.getNetwork(startNode).stream().filter(n -> n.getLinkType() == Node.LinkType.DESTINATION || n.getLinkType() == Node.LinkType.PRIVATE).toList();
        NetworkCache updated = new NetworkCache(existing.id(), existing.nodePositions(), existing.bounds(), destinations);
        this.networkCacheById.put(updated.id(), updated);
    }

    private UUID generateDeterministicUUID(Set<Long> nodePositions) {
        if (nodePositions.isEmpty()) {
            return UUID.randomUUID();
        }
        long[] sortedPositions = nodePositions.stream().mapToLong(l -> l).sorted().toArray();
        ByteBuffer bb = ByteBuffer.allocate(sortedPositions.length * 8);
        for (long pos : sortedPositions) {
            bb.putLong(pos);
        }
        return UUID.nameUUIDFromBytes(bb.array());
    }

    public class_1767 getNetworkColor(Node node) {
        NetworkCache cache = this.getNetworkCacheForNode(node);
        int colorIndex = Math.abs(cache.id().hashCode() % NETWORK_COLORS.length);
        return NETWORK_COLORS[colorIndex];
    }

    public void updateAllNetworkColors(class_3218 level) {
        WorldLandmarks worldLandmarks;
        try {
            worldLandmarks = WorldSummary.of((class_1937)level).landmarks();
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to access WorldLandmarks, skipping network color update.", (Throwable)e);
            return;
        }
        HashSet<UUID> processedNetworks = new HashSet<UUID>();
        for (Node node : this.nodes) {
            NetworkCache cache = this.getNetworkCacheForNode(node);
            if (processedNetworks.contains(cache.id())) continue;
            class_1767 requiredColor = this.getNetworkColor(node);
            for (Node destinationNode : cache.destinationNodes()) {
                try {
                    Landmark landmark = worldLandmarks.get(ViaRomanaLandmark.TYPE, destinationNode.getBlockPos());
                    if (landmark == null || landmark.color() == requiredColor) continue;
                    ViaRomanaLandmark updatedLandmark = ViaRomanaLandmark.createDestination(level, destinationNode, destinationNode.getBlockPos());
                    worldLandmarks.put((class_1937)level, (Landmark)updatedLandmark);
                }
                catch (Exception e) {
                    ViaRomana.LOGGER.warn("Failed to update landmark color for node at {}: {}", (Object)destinationNode.getBlockPos(), (Object)e.getMessage());
                }
            }
            processedNetworks.add(cache.id());
        }
    }

    public List<Node> nodesView() {
        return Collections.unmodifiableList(this.nodes);
    }

    public int size() {
        return this.nodes.size();
    }

    public boolean contains(class_2338 pos) {
        return this.posToIndex.containsKey(pos.method_10063());
    }

    public Optional<Node> getNodeAt(class_2338 pos) {
        int idx = this.posToIndex.getOrDefault(pos.method_10063(), -1);
        return idx != -1 ? Optional.of((Node)this.nodes.get(idx)) : Optional.empty();
    }

    public int getOrCreateNode(class_2338 pos, float quality, float clearance) {
        return this.posToIndex.computeIfAbsent(pos.method_10063(), nodePos -> {
            int newIndex = this.nodes.size();
            this.nodes.add((Object)new Node(nodePos, quality, clearance));
            return newIndex;
        });
    }

    public void createConnectedPath(List<Node.NodeData> pathData) {
        if (pathData == null || pathData.size() < 2) {
            return;
        }
        Node previousNode = null;
        for (Node.NodeData currentData : pathData) {
            Node currentNode = (Node)this.nodes.get(this.getOrCreateNode(currentData.pos(), currentData.quality(), currentData.clearance()));
            if (previousNode != null) {
                this.invalidateNetworksContaining(previousNode, currentNode);
                previousNode.connect(currentNode);
            }
            previousNode = currentNode;
        }
    }

    public void removeNode(Node node) {
        this.removeNode(node.getBlockPos());
    }

    public boolean removeNode(class_2338 pos) {
        long packedPos = pos.method_10063();
        int idx = this.posToIndex.getOrDefault(packedPos, -1);
        if (idx == -1) {
            return false;
        }
        Node removedNode = (Node)this.nodes.get(idx);
        this.invalidateNetworksContaining(removedNode);
        LongIterator longIterator = removedNode.getConnectedNodes().iterator();
        while (longIterator.hasNext()) {
            long neighborPos = (Long)longIterator.next();
            this.getNodeAt(class_2338.method_10092((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(packedPos));
        }
        int lastIdx = this.nodes.size() - 1;
        Node lastNode = (Node)this.nodes.get(lastIdx);
        this.nodes.set(idx, (Object)lastNode);
        this.nodes.remove(lastIdx);
        this.posToIndex.remove(packedPos);
        removedNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.remove(signPos.longValue()));
        if (idx < lastIdx) {
            this.posToIndex.put(lastNode.getPos(), idx);
            lastNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.put(signPos.longValue(), idx));
        }
        return true;
    }

    public Optional<NetworkCache> removeBranch(Node startNode) {
        Set<Node> branchNodes = this.findBranchNodes(startNode);
        if (branchNodes.isEmpty()) {
            return Optional.empty();
        }
        Set<NetworkCache> invalidatedCaches = this.invalidateNetworksContaining(startNode);
        Set branchPositions = branchNodes.stream().map(Node::getPos).collect(Collectors.toSet());
        for (Node node : branchNodes) {
            LongIterator longIterator = node.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                if (branchPositions.contains(neighborPos)) continue;
                this.getNodeAt(class_2338.method_10092((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(node.getPos()));
            }
            this.removeNodeWithoutNeighborUpdates(node);
        }
        return invalidatedCaches.stream().findFirst();
    }

    private void removeNodeWithoutNeighborUpdates(Node node) {
        long packedPos = node.getPos();
        int idx = this.posToIndex.getOrDefault(packedPos, -1);
        if (idx == -1) {
            return;
        }
        int lastIdx = this.nodes.size() - 1;
        Node lastNode = (Node)this.nodes.get(lastIdx);
        this.nodes.set(idx, (Object)lastNode);
        this.nodes.remove(lastIdx);
        this.posToIndex.remove(packedPos);
        node.getSignPos().ifPresent(signPos -> this.signPosToIndex.remove(signPos.longValue()));
        if (idx < lastIdx) {
            this.posToIndex.put(lastNode.getPos(), idx);
            lastNode.getSignPos().ifPresent(signPos -> this.signPosToIndex.put(signPos.longValue(), idx));
        }
    }

    public void removeAndHealConnections(Node node) {
        long[] neighbors = node.getConnectedNodes().toLongArray();
        this.invalidateNetworksContaining(node);
        for (long neighborPos : neighbors) {
            this.getNodeAt(class_2338.method_10092((long)neighborPos)).ifPresent(neighbor -> neighbor.removeConnection(node.getPos()));
        }
        if (neighbors.length == 2) {
            Optional<Node> nodeA = this.getNodeAt(class_2338.method_10092((long)neighbors[0]));
            Optional<Node> nodeB = this.getNodeAt(class_2338.method_10092((long)neighbors[1]));
            if (nodeA.isPresent() && nodeB.isPresent()) {
                nodeA.get().connect(nodeB.get());
            }
        }
        this.removeNodeWithoutNeighborUpdates(node);
    }

    public void removeAllNodes() {
        for (NetworkCache cache : this.networkCacheById.values()) {
            try {
                ServerMapCache.invalidate(cache.id());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.warn("Failed to invalidate ServerMapCache during clear for {}: {}", (Object)cache.id(), (Object)e.getMessage());
            }
        }
        this.nodes.clear();
        this.posToIndex.clear();
        this.signPosToIndex.clear();
        this.networkCacheById.clear();
        this.nodeToNetworkId.clear();
        this.fowCacheById.clear();
    }

    public boolean linkSignToNode(class_2338 nodePos, class_2338 signPos, Node.LinkType linkType, UUID owner) {
        return this.getNodeAt(nodePos).map(node -> {
            node.setSignPos(signPos.method_10063());
            node.setLinkType(linkType);
            if (linkType == Node.LinkType.PRIVATE && owner != null) {
                node.setPrivateOwner(owner);
            }
            this.signPosToIndex.put(signPos.method_10063(), this.posToIndex.get(nodePos.method_10063()));
            this.refreshNetworkDestinations((Node)node);
            return true;
        }).orElse(false);
    }

    public boolean removeSignLink(class_2338 signPos) {
        return this.getNodeBySignPos(signPos).map(node -> {
            node.unlink();
            this.signPosToIndex.remove(signPos.method_10063());
            this.refreshNetworkDestinations((Node)node);
            return true;
        }).orElse(false);
    }

    public Optional<Node> getNodeBySignPos(class_2338 signPos) {
        int idx = this.signPosToIndex.getOrDefault(signPos.method_10063(), -1);
        return idx != -1 ? Optional.of((Node)this.nodes.get(idx)) : Optional.empty();
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance, Predicate<Node> filter) {
        return this.getNearestNode(origin, maxDistance, maxDistance, filter);
    }

    public Optional<Node> getNearestNode(class_2338 origin, double maxDistance, double maxYDistance, Predicate<Node> filter) {
        return this.nodes.stream().filter(filter).filter(node -> ClientPathData.calculateDistance(node.getBlockPos(), origin, false) <= maxDistance * maxDistance && (double)Math.abs(node.getBlockPos().method_10264() - origin.method_10264()) <= maxYDistance).min(Comparator.comparingDouble(node -> ClientPathData.calculateDistance(node.getBlockPos(), origin, true)));
    }

    public List<Node> getNetwork(Node start) {
        ArrayList<Node> network = new ArrayList<Node>();
        HashSet<Long> visited = new HashSet<Long>();
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        visited.add(start.getPos());
        queue.add(start);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            network.add(current);
            LongIterator longIterator = current.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                if (!visited.add(neighborPos)) continue;
                this.getNodeAt(class_2338.method_10092((long)neighborPos)).ifPresent(queue::add);
            }
        }
        return network;
    }

    private Set<Node> findBranchNodes(Node start) {
        HashSet<Node> branch = new HashSet<Node>();
        if (start.getConnectedNodes().size() >= 3) {
            branch.add(start);
            return branch;
        }
        ArrayDeque<Node> queue = new ArrayDeque<Node>();
        HashSet<Node> visited = new HashSet<Node>();
        queue.add(start);
        visited.add(start);
        while (!queue.isEmpty()) {
            Node current = (Node)queue.poll();
            branch.add(current);
            LongIterator longIterator = current.getConnectedNodes().iterator();
            while (longIterator.hasNext()) {
                long neighborPos = (Long)longIterator.next();
                this.getNodeAt(class_2338.method_10092((long)neighborPos)).ifPresent(neighbor -> {
                    if (visited.add((Node)neighbor) && neighbor.getConnectedNodes().size() < 3) {
                        queue.add((Node)neighbor);
                    }
                });
            }
        }
        return branch;
    }

    public BoundingBox getNetworkBounds(Node sourceNode) {
        return this.getNetworkCacheForNode(sourceNode).bounds();
    }

    public List<Node> getCachedTeleportDestinationsFor(UUID playerId, Node sourceNode) {
        NetworkCache cache = this.getNetworkCacheForNode(sourceNode);
        return cache.destinationNodes().stream().filter(node -> node.getPos() != sourceNode.getPos()).filter(node -> node.isAccessibleBy(playerId)).toList();
    }

    private BoundingBox calculateBoundsFor(List<Node> networkNodes) {
        if (networkNodes.isEmpty()) {
            return BoundingBox.ZERO;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (Node node : networkNodes) {
            class_2338 pos = node.getBlockPos();
            minX = Math.min(minX, pos.method_10263());
            minY = Math.min(minY, pos.method_10264());
            minZ = Math.min(minZ, pos.method_10260());
            maxX = Math.max(maxX, pos.method_10263());
            maxY = Math.max(maxY, pos.method_10264());
            maxZ = Math.max(maxZ, pos.method_10260());
        }
        return new BoundingBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    @Nullable
    public NetworkCache getNetworkCache(UUID id) {
        return (NetworkCache)this.networkCacheById.get(id);
    }

    public NetworkCache getNetworkCache(Node startNode) {
        return this.getNetworkCacheForNode(startNode);
    }

    public List<NetworkCache> findNetworksForChunk(class_1923 chunkPos) {
        HashSet<UUID> seen = new HashSet<UUID>();
        ArrayList<NetworkCache> result = new ArrayList<NetworkCache>();
        for (Node node : this.nodes) {
            NetworkCache cache = this.getNetworkCacheForNode(node);
            if (!seen.add(cache.id())) continue;
            FoWCache fow = this.getOrComputeFoWCache(cache);
            if (chunkPos.field_9181 < fow.minChunk().field_9181 || chunkPos.field_9181 > fow.maxChunk().field_9181 || chunkPos.field_9180 < fow.minChunk().field_9180 || chunkPos.field_9180 > fow.maxChunk().field_9180 || !fow.allowedChunks().contains(chunkPos)) continue;
            result.add(cache);
        }
        return result;
    }

    public FoWCache getOrComputeFoWCache(NetworkCache cache) {
        return this.fowCacheById.computeIfAbsent(cache.id(), id -> {
            int widthW = cache.bounds.maxX - cache.bounds.minX;
            int heightW = cache.bounds.maxZ - cache.bounds.minZ;
            int padX = Math.max(16, (int)((float)widthW * 0.1f));
            int padZ = Math.max(16, (int)((float)heightW * 0.1f));
            class_2338 paddedMin = new class_2338(cache.bounds.minX - padX, cache.bounds.minY, cache.bounds.minZ - padZ);
            class_2338 paddedMax = new class_2338(cache.bounds.maxX + padX, cache.bounds.maxY, cache.bounds.maxZ + padZ);
            class_1923 minChunk = new class_1923(paddedMin);
            class_1923 maxChunk = new class_1923(paddedMax);
            Set<class_1923> allowed = ServerMapUtils.calculateFogOfWarChunks(cache.getNodesAsInfo(), minChunk, maxChunk);
            return new FoWCache(minChunk, maxChunk, allowed);
        });
    }

    public List<Node> queryNearby(class_2338 center, double radius) {
        double radiusSquared = radius * radius;
        return this.nodes.stream().filter(node -> node.getBlockPos().method_10262((class_2382)center) <= radiusSquared).collect(Collectors.toList());
    }

    public class_2487 serialize(class_2487 root) {
        class_2499 list = new class_2499();
        for (Node node : this.nodes) {
            list.add((Object)node.serialize(new class_2487()));
        }
        root.method_10566("nodes", (class_2520)list);
        return root;
    }

    public void deserialize(class_2487 root) {
        this.removeAllNodes();
        class_2499 list = root.method_10554("nodes", 10);
        for (class_2520 raw : list) {
            this.nodes.add((Object)new Node((class_2487)raw));
        }
        this.rebuildIndices();
    }

    public void rebuildIndices() {
        this.posToIndex.clear();
        this.signPosToIndex.clear();
        int i = 0;
        while (i < this.nodes.size()) {
            Node node = (Node)this.nodes.get(i);
            this.posToIndex.put(node.getPos(), i);
            int finalI = i++;
            node.getSignPos().ifPresent(sp -> this.signPosToIndex.put(sp.longValue(), finalI));
        }
    }

    public record NetworkCache(UUID id, Set<Long> nodePositions, BoundingBox bounds, List<Node> destinationNodes) {
        public class_2338 getMin() {
            return new class_2338(this.bounds.minX, this.bounds.minY, this.bounds.minZ);
        }

        public class_2338 getMax() {
            return new class_2338(this.bounds.maxX, this.bounds.maxY, this.bounds.maxZ);
        }

        public List<DestinationResponseS2C.NodeNetworkInfo> getNodesAsInfo() {
            return this.nodePositions.stream().map(pos -> new DestinationResponseS2C.NodeNetworkInfo(class_2338.method_10092((long)pos), 0.0f, List.of())).collect(Collectors.toList());
        }
    }

    public record BoundingBox(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        public static final BoundingBox ZERO = new BoundingBox(0, 0, 0, 0, 0, 0);
    }

    public record FoWCache(class_1923 minChunk, class_1923 maxChunk, Set<class_1923> allowedChunks) {
    }
}

