/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.rasanovum.viaromana.path.Node;

public record DestinationResponseS2C(List<DestinationInfo> destinations, class_2338 signPos, class_2338 sourceNodePos, List<NodeNetworkInfo> networkNodes, UUID networkId) implements class_8710
{
    public static final class_8710.class_9154<DestinationResponseS2C> TYPE = new class_8710.class_9154(class_2960.method_60654((String)"via_romana:destination_response"));
    public static final class_9139<class_2540, DestinationResponseS2C> STREAM_CODEC = new class_9139<class_2540, DestinationResponseS2C>(){

        public DestinationResponseS2C decode(class_2540 buffer) {
            class_2338 signPos = buffer.method_10811();
            class_2338 sourceNodePos = buffer.method_10811();
            UUID networkId = buffer.method_10790();
            int size = buffer.readInt();
            ArrayList<DestinationInfo> destinations = new ArrayList<DestinationInfo>(size);
            for (int i = 0; i < size; ++i) {
                destinations.add(new DestinationInfo(buffer.method_10811(), buffer.method_19772(), buffer.readDouble(), Node.Icon.valueOf(buffer.method_19772())));
            }
            int networkSize = buffer.readInt();
            ArrayList<NodeNetworkInfo> networkNodes = new ArrayList<NodeNetworkInfo>(networkSize);
            for (int i = 0; i < networkSize; ++i) {
                class_2338 pos = buffer.method_10811();
                float clearance = buffer.readFloat();
                int connectionCount = buffer.readInt();
                ArrayList<class_2338> connections = new ArrayList<class_2338>(connectionCount);
                for (int j = 0; j < connectionCount; ++j) {
                    connections.add(buffer.method_10811());
                }
                networkNodes.add(new NodeNetworkInfo(pos, clearance, connections));
            }
            return new DestinationResponseS2C(destinations, signPos, sourceNodePos, networkNodes, networkId);
        }

        public void encode(class_2540 buffer, DestinationResponseS2C packet) {
            buffer.method_10807(packet.signPos);
            buffer.method_10807(packet.sourceNodePos);
            buffer.method_10797(packet.networkId);
            buffer.method_53002(packet.destinations.size());
            for (DestinationInfo dest : packet.destinations) {
                buffer.method_10807(dest.position);
                buffer.method_10814(dest.name);
                buffer.method_52940(dest.distance);
                buffer.method_10814(dest.icon.name());
            }
            buffer.method_53002(packet.networkNodes.size());
            for (NodeNetworkInfo node : packet.networkNodes) {
                buffer.method_10807(node.position);
                buffer.method_52941(node.clearance);
                buffer.method_53002(node.connections.size());
                for (class_2338 connection : node.connections) {
                    buffer.method_10807(connection);
                }
            }
        }
    };

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static class NodeNetworkInfo {
        public final class_2338 position;
        public final float clearance;
        public final List<class_2338> connections;

        public NodeNetworkInfo(class_2338 position, float clearance, List<class_2338> connections) {
            this.position = position;
            this.clearance = clearance;
            this.connections = connections;
        }
    }

    public static class DestinationInfo {
        public final class_2338 position;
        public final String name;
        public final double distance;
        public final Node.Icon icon;

        public DestinationInfo(class_2338 position, String name, double distance, Node.Icon icon) {
            this.position = position;
            this.name = name;
            this.distance = distance;
            this.icon = icon;
        }
    }
}

