/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.class_8710;
import net.minecraft.class_9139;
import net.minecraft.server.MinecraftServer;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.network.NetworkHandler;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.PathSyncUtils;

public class ViaRomanaModVariables {
    public static List<Object> ValidTagList = new ArrayList<Object>();
    public static NetworkHandler networkHandler = null;
    private static final Map<UUID, PlayerVariables> playerVariables = new ConcurrentHashMap<UUID, PlayerVariables>();
    private static PlayerVariables clientPlayerVariables = new PlayerVariables();

    public static class_2499 saveNodeDataList(List<Node.NodeData> nodeDataList) {
        class_2499 listTag = new class_2499();
        for (Node.NodeData data : nodeDataList) {
            class_2487 nodeCompound = new class_2487();
            nodeCompound.method_10544("pos", data.pos().method_10063());
            nodeCompound.method_10548("quality", data.quality());
            nodeCompound.method_10548("clearance", data.clearance());
            listTag.add((Object)nodeCompound);
        }
        return listTag;
    }

    public static List<Node.NodeData> loadNodeDataList(class_2499 listTag) {
        ArrayList<Node.NodeData> loadedList = new ArrayList<Node.NodeData>();
        if (listTag.method_10601() != 10) {
            return loadedList;
        }
        for (class_2520 tag : listTag) {
            class_2487 nodeCompound = (class_2487)tag;
            class_2338 pos = class_2338.method_10092((long)nodeCompound.method_10537("pos"));
            float quality = nodeCompound.method_10583("quality");
            float clearance = nodeCompound.method_10583("clearance");
            loadedList.add(new Node.NodeData(pos, quality, clearance));
        }
        return loadedList;
    }

    public static PlayerVariables getPlayerVariables(class_1297 entity) {
        if (entity == null) {
            ViaRomana.LOGGER.warn("Attempted to get PlayerVariables for null entity.");
            return new PlayerVariables();
        }
        if (entity.method_37908().method_8608()) {
            return clientPlayerVariables;
        }
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            UUID playerId = player.method_5667();
            return playerVariables.computeIfAbsent(playerId, id -> {
                PlayerVariables vars = new PlayerVariables();
                class_2487 playerData = ViaRomanaModVariables.loadNBTFromFile(player.method_5682(), id.toString());
                if (playerData != null) {
                    vars.readNBT(playerData);
                    ViaRomana.LOGGER.debug("Loaded PlayerVariables from file for {}", (Object)player.method_5477().getString());
                } else {
                    ViaRomana.LOGGER.debug("No existing PlayerVariables file found for {}, creating new.", (Object)player.method_5477().getString());
                }
                return vars;
            });
        }
        ViaRomana.LOGGER.warn("Tried to get PlayerVariables for non-ServerPlayer entity: {}", (Object)entity.method_5864().method_5882());
        return new PlayerVariables();
    }

    public static void playerLoggedOut(class_3222 player) {
        UUID playerId;
        PlayerVariables vars;
        if (player != null && (vars = playerVariables.get(playerId = player.method_5667())) != null) {
            ViaRomanaModVariables.savePlayerVariablesToFile(player.method_5682(), playerId.toString(), vars);
            playerVariables.remove(playerId);
            ViaRomana.LOGGER.debug("Saved and unloaded PlayerVariables for {}", (Object)player.method_5477().getString());
        }
    }

    public static PlayerVariables playerLoggedIn(class_3222 player) {
        if (player == null) {
            return new PlayerVariables();
        }
        PlayerVariables vars = ViaRomanaModVariables.getPlayerVariables((class_1297)player);
        vars.syncToClient(player);
        PathSyncUtils.syncPathGraphToPlayer(player);
        return vars;
    }

    public static void playerRespawned(class_3222 oldPlayer, class_3222 newPlayer, boolean keepAllPlayerData) {
        if (oldPlayer == null || newPlayer == null) {
            return;
        }
        PlayerVariables oldVars = playerVariables.get(oldPlayer.method_5667());
        PlayerVariables newVars = ViaRomanaModVariables.getPlayerVariables((class_1297)newPlayer);
        if (oldVars != null) {
            if (keepAllPlayerData) {
                newVars.readNBT(oldVars.writeNBT());
                ViaRomana.LOGGER.debug("Copied all PlayerVariables on respawn for {}", (Object)newPlayer.method_5477().getString());
            } else {
                ViaRomana.LOGGER.debug("Did not copy PlayerVariables on respawn (keepAllPlayerData=false) for {}", (Object)newPlayer.method_5477().getString());
            }
            newVars.syncToClient(newPlayer);
        } else {
            ViaRomana.LOGGER.warn("Could not find old PlayerVariables for {} during respawn.", (Object)oldPlayer.method_5477().getString());
            newVars.syncToClient(newPlayer);
        }
    }

    public static void savePlayerVariablesToFile(MinecraftServer server, String playerUUID, PlayerVariables data) {
        if (server == null || data == null) {
            return;
        }
        ViaRomanaModVariables.saveNBTToFile(server, playerUUID, data.writeNBT());
    }

    public static void loadPlayerVariablesFromFile(class_3222 player) {
        if (player != null && player.method_5682() != null) {
            UUID playerId = player.method_5667();
            class_2487 playerData = ViaRomanaModVariables.loadNBTFromFile(player.method_5682(), playerId.toString());
            if (playerData != null) {
                PlayerVariables playerVar = playerVariables.computeIfAbsent(playerId, id -> new PlayerVariables());
                playerVar.readNBT(playerData);
                ViaRomana.LOGGER.debug("Force-loaded PlayerVariables from file for {}", (Object)player.method_5477().getString());
                playerVar.syncToClient(player);
            }
        }
    }

    private static File getPlayerDataDirectory(MinecraftServer server) {
        return new File(server.method_27050(class_5218.field_24182).toFile(), "via_romana");
    }

    private static void saveNBTToFile(MinecraftServer server, String fileName, class_2487 nbt) {
        if (server == null) {
            return;
        }
        try {
            File dataDir = ViaRomanaModVariables.getPlayerDataDirectory(server);
            if (!dataDir.exists()) {
                if (!dataDir.mkdirs()) {
                    ViaRomana.LOGGER.error("Could not create player data directory: {}", (Object)dataDir.getAbsolutePath());
                    return;
                }
                ViaRomana.LOGGER.debug("Created player data directory: {}", (Object)dataDir.getAbsolutePath());
            }
            File file = new File(dataDir, fileName + ".dat");
            File backupFile = new File(dataDir, fileName + ".dat_old");
            if (file.exists()) {
                if (backupFile.exists()) {
                    backupFile.delete();
                }
                file.renameTo(backupFile);
            }
            class_2507.method_30614((class_2487)nbt, (Path)file.toPath());
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("Failed to save player variables NBT for " + fileName, (Throwable)e);
        }
    }

    private static class_2487 loadNBTFromFile(MinecraftServer server, String fileName) {
        if (server == null) {
            return null;
        }
        File dataDir = ViaRomanaModVariables.getPlayerDataDirectory(server);
        File file = new File(dataDir, fileName + ".dat");
        File backupFile = new File(dataDir, fileName + ".dat_old");
        if (file.exists()) {
            try {
                return class_2507.method_30613((Path)file.toPath(), (class_2505)class_2505.method_53898());
            }
            catch (IOException e) {
                ViaRomana.LOGGER.error("Failed to load player variables NBT from " + file.getName() + ", trying backup.", (Throwable)e);
                if (backupFile.exists()) {
                    try {
                        ViaRomana.LOGGER.warn("Attempting to load from backup file: {}", (Object)backupFile.getName());
                        return class_2507.method_30613((Path)backupFile.toPath(), (class_2505)class_2505.method_53898());
                    }
                    catch (IOException e2) {
                        ViaRomana.LOGGER.error("Failed to load player variables NBT from backup " + backupFile.getName() + " as well.", (Throwable)e2);
                    }
                }
            }
        } else if (backupFile.exists()) {
            try {
                ViaRomana.LOGGER.warn("Main file {} missing, attempting to load from backup file: {}", (Object)file.getName(), (Object)backupFile.getName());
                return class_2507.method_30613((Path)backupFile.toPath(), (class_2505)class_2505.method_53898());
            }
            catch (IOException e) {
                ViaRomana.LOGGER.error("Failed to load player variables NBT from backup " + backupFile.getName(), (Throwable)e);
            }
        }
        return null;
    }

    public static class PlayerVariables {
        public boolean ChartingPath = false;
        public double FadeAmount = 0.0;
        public boolean FadeIncrease = false;
        public class_2338 lastNodePos = class_2338.field_10980;
        public boolean ReceivedTutorial = false;

        public class_2487 writeNBT() {
            class_2487 nbt = new class_2487();
            nbt.method_10556("ChartingPath", this.ChartingPath);
            nbt.method_10549("FadeAmount", this.FadeAmount);
            nbt.method_10556("FadeIncrease", this.FadeIncrease);
            nbt.method_10544("lastNodePos", this.lastNodePos != null ? this.lastNodePos.method_10063() : class_2338.field_10980.method_10063());
            nbt.method_10556("ReceivedTutorial", this.ReceivedTutorial);
            return nbt;
        }

        public void readNBT(class_2487 nbt) {
            this.ChartingPath = nbt.method_10577("ChartingPath");
            this.FadeAmount = nbt.method_10574("FadeAmount");
            this.FadeIncrease = nbt.method_10577("FadeIncrease");
            long nodePos = nbt.method_10537("lastNodePos");
            this.lastNodePos = nodePos != class_2338.field_10980.method_10063() ? class_2338.method_10092((long)nodePos) : class_2338.field_10980;
            this.ReceivedTutorial = nbt.method_10577("ReceivedTutorial");
        }

        public void syncToClient(class_3222 player) {
            if (player == null) {
                return;
            }
            if (networkHandler != null) {
                networkHandler.sendToPlayer(player, new PlayerVariablesSyncMessage(this));
            } else {
                ViaRomana.LOGGER.warn("Network handler not initialized, cannot sync PlayerVariables for {}.", (Object)player.method_5477().getString());
            }
        }
    }

    public record PlayerVariablesSyncMessage(class_2487 dataTag) implements class_8710
    {
        public static final class_8710.class_9154<PlayerVariablesSyncMessage> TYPE = new class_8710.class_9154(class_2960.method_60654((String)"via_romana:player_variables_sync"));
        public static final class_9139<class_2540, PlayerVariablesSyncMessage> STREAM_CODEC = new class_9139<class_2540, PlayerVariablesSyncMessage>(){

            public PlayerVariablesSyncMessage decode(class_2540 buffer) {
                return new PlayerVariablesSyncMessage(buffer.method_10798());
            }

            public void encode(class_2540 buffer, PlayerVariablesSyncMessage packet) {
                buffer.method_10794((class_2520)packet.dataTag);
            }
        };

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this(data.writeNBT());
        }

        public class_8710.class_9154<? extends class_8710> method_56479() {
            return TYPE;
        }

        public static void handleClient(PlayerVariablesSyncMessage message) {
            clientPlayerVariables.readNBT(message.dataTag);
            ViaRomana.LOGGER.debug("Client received and processed PlayerVariables sync.");
        }

        public static void handleServer(PlayerVariablesSyncMessage message, class_3222 player) {
            if (player != null) {
                PlayerVariables variables = ViaRomanaModVariables.getPlayerVariables((class_1297)player);
                variables.readNBT(message.dataTag);
                ViaRomana.LOGGER.debug("Server received and processed PlayerVariables sync from {}", (Object)player.method_5477().getString());
            }
        }
    }
}

