/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.network;

import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_167;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8779;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.network.FabricNetworkHandler;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;
import net.rasanovum.viaromana.network.packets.ChartedPathC2S;
import net.rasanovum.viaromana.network.packets.DestinationRequestC2S;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.LinkSignRequestC2S;
import net.rasanovum.viaromana.network.packets.MapRequestC2S;
import net.rasanovum.viaromana.network.packets.MapResponseS2C;
import net.rasanovum.viaromana.network.packets.RoutedActionC2S;
import net.rasanovum.viaromana.network.packets.SignValidationRequestC2S;
import net.rasanovum.viaromana.network.packets.SignValidationResponseS2C;
import net.rasanovum.viaromana.network.packets.TeleportRequestC2S;
import net.rasanovum.viaromana.network.packets.UnlinkSignRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.surveyor.ViaRomanaLandmarkManager;
import net.rasanovum.viaromana.teleport.ServerTeleportHandler;
import net.rasanovum.viaromana.util.PathSyncUtils;

public class ViaRomanaModPacketHandler {
    public static void initialize() {
        ViaRomanaModVariables.networkHandler = new FabricNetworkHandler();
        ViaRomanaModPacketHandler.registerC2SPackets();
    }

    public static void registerC2SPackets() {
        ServerPlayNetworking.registerGlobalReceiver(ViaRomanaModVariables.PlayerVariablesSyncMessage.TYPE, ViaRomanaModPacketHandler::handlePlayerVariablesSyncC2S);
        ServerPlayNetworking.registerGlobalReceiver(TeleportRequestC2S.TYPE, ViaRomanaModPacketHandler::handleTeleportRequestC2S);
        ServerPlayNetworking.registerGlobalReceiver(LinkSignRequestC2S.TYPE, ViaRomanaModPacketHandler::handleLinkSignRequestC2S);
        ServerPlayNetworking.registerGlobalReceiver(UnlinkSignRequestC2S.TYPE, ViaRomanaModPacketHandler::handleUnlinkSignRequestC2S);
        ServerPlayNetworking.registerGlobalReceiver(DestinationRequestC2S.TYPE, ViaRomanaModPacketHandler::handleDestinationRequestC2S);
        ServerPlayNetworking.registerGlobalReceiver(SignValidationRequestC2S.TYPE, ViaRomanaModPacketHandler::handleSignValidationRequestC2S);
        ServerPlayNetworking.registerGlobalReceiver(MapRequestC2S.TYPE, ViaRomanaModPacketHandler::handleMapRequestC2S);
        ServerPlayNetworking.registerGlobalReceiver(ChartedPathC2S.TYPE, ViaRomanaModPacketHandler::handleChartedPathC2S);
        ServerPlayNetworking.registerGlobalReceiver(RoutedActionC2S.TYPE, ViaRomanaModPacketHandler::handleActionRequestC2S);
    }

    private static void handlePlayerVariablesSyncC2S(ViaRomanaModVariables.PlayerVariablesSyncMessage packet, ServerPlayNetworking.Context context) {
        context.server().execute(() -> ViaRomanaModVariables.PlayerVariablesSyncMessage.handleServer(packet, context.player()));
    }

    private static void handleActionRequestC2S(RoutedActionC2S packet, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            class_3218 level = player.method_51469();
            IPathStorage storage = IPathStorage.get((class_1937)level);
            PathGraph graph = storage.graph();
            Optional<Node> nearestOpt = graph.getNearestNode(player.method_24515(), CommonConfig.node_utility_distance, node -> true);
            if (nearestOpt.isEmpty()) {
                ViaRomana.LOGGER.warn("No nearby node found for action {} by player {}", (Object)packet.op(), (Object)player.method_5477().getString());
                return;
            }
            Node nearestNode = nearestOpt.get();
            switch (packet.op()) {
                case SEVER_NEAREST_NODE: {
                    graph.removeNode(nearestNode);
                    break;
                }
                case REMOVE_BRANCH: {
                    graph.removeBranch(nearestNode);
                }
            }
            storage.method_80();
            PathSyncUtils.syncPathGraphToAllPlayers(level);
        });
    }

    private static void handleTeleportRequestC2S(TeleportRequestC2S packet, ServerPlayNetworking.Context context) {
        context.server().execute(() -> ServerTeleportHandler.handleTeleportRequest(packet, context.player()));
    }

    private static void handleLinkSignRequestC2S(LinkSignRequestC2S packet, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            boolean success;
            class_3218 level = context.player().method_51469();
            LinkHandler.LinkData linkData = packet.linkData();
            boolean isTempNode = packet.isTempNode();
            if (!LinkHandler.isSignBlock((class_1936)level, linkData.signPos())) {
                ViaRomana.LOGGER.warn("Link request for non-existent sign at {}", (Object)linkData.signPos());
                return;
            }
            if (!isTempNode && !(success = LinkHandler.linkSignToNode(level, linkData))) {
                ViaRomana.LOGGER.warn("Failed to link sign at {} to node at {}", (Object)linkData.signPos(), (Object)linkData.nodePos());
            }
        });
    }

    private static void handleUnlinkSignRequestC2S(UnlinkSignRequestC2S packet, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3218 level = context.player().method_51469();
            boolean success = LinkHandler.unlinkSignFromNode(level, packet.signPos());
            if (!success) {
                ViaRomana.LOGGER.warn("Failed to unlink sign at {}", (Object)packet.signPos());
            }
        });
    }

    private static void handleMapRequestC2S(MapRequestC2S packet, ServerPlayNetworking.Context context) {
        UUID networkId = packet.getNetworkId();
        context.server().execute(() -> {
            PathGraph.NetworkCache network;
            PathGraph graph = IPathStorage.get(context.player().method_37908()).graph();
            PathGraph.NetworkCache networkCache = network = graph != null ? graph.getNetworkCache(networkId) : null;
            if (network == null) {
                ViaRomana.LOGGER.warn("Could not find network with ID {} for map request", (Object)networkId);
                return;
            }
            ServerMapCache.getMapData(networkId).ifPresentOrElse(result -> {
                MapResponseS2C response = MapResponseS2C.create(result.networkId(), result.minBounds(), result.maxBounds(), result.networkNodes(), result.pngData(), result.bakeScaleFactor());
                if (ViaRomanaModVariables.networkHandler != null) {
                    ViaRomanaModVariables.networkHandler.sendToPlayer(context.player(), response);
                }
            }, () -> {
                class_3218 level = context.player().method_51469();
                ServerMapCache.generateMapIfNeeded(networkId, level).thenAcceptAsync(produced -> {
                    if (produced != null && ViaRomanaModVariables.networkHandler != null) {
                        MapResponseS2C response = MapResponseS2C.create(produced.networkId(), produced.minBounds(), produced.maxBounds(), produced.networkNodes(), produced.pngData(), produced.bakeScaleFactor());
                        ViaRomanaModVariables.networkHandler.sendToPlayer(context.player(), response);
                    }
                }, (Executor)context.server());
            });
        });
    }

    private static void handleDestinationRequestC2S(DestinationRequestC2S packet, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            class_2338 sourceSignPos = packet.sourceSignPos();
            class_1937 level = player.method_37908();
            UUID playerUUID = player.method_5667();
            PathGraph graph = IPathStorage.get(level).graph();
            Optional<Object> sourceNodeOpt = Optional.empty();
            try {
                sourceNodeOpt = graph.getNodeBySignPos(sourceSignPos);
            }
            catch (IndexOutOfBoundsException e) {
                ViaRomana.LOGGER.warn("getNodeBySignPos out of bounds for sign {}: {}", (Object)sourceSignPos, (Object)e.getMessage());
            }
            if (sourceNodeOpt.isEmpty()) {
                DestinationResponseS2C resp = new DestinationResponseS2C(new ArrayList<DestinationResponseS2C.DestinationInfo>(), sourceSignPos, class_2338.field_10980, new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(), UUID.randomUUID());
                ViaRomanaModVariables.networkHandler.sendToPlayer(player, resp);
                return;
            }
            Node sourceNode = (Node)sourceNodeOpt.get();
            class_2338 sourceNodePos = class_2338.method_10092((long)sourceNode.getPos());
            List<Node> destinationNodes = graph.getCachedTeleportDestinationsFor(playerUUID, sourceNode);
            ArrayList<DestinationResponseS2C.DestinationInfo> infos = new ArrayList<DestinationResponseS2C.DestinationInfo>();
            for (Node node : destinationNodes) {
                class_2338 nodePos = node.getBlockPos();
                String name = node.getDestinationName().orElse("Unnamed Destination");
                double distance = Math.sqrt(sourceNodePos.method_10262((class_2382)nodePos));
                Node.Icon icon = node.getDestinationIcon().orElse(Node.Icon.SIGNPOST);
                infos.add(new DestinationResponseS2C.DestinationInfo(nodePos, name, distance, icon));
            }
            ArrayList<DestinationResponseS2C.NodeNetworkInfo> networkNodes = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>();
            sourceNodeOpt.ifPresent(startNode -> {
                List<Node> network = graph.getNetwork((Node)startNode);
                for (Node node : network) {
                    ArrayList<class_2338> connections = new ArrayList<class_2338>();
                    LongIterator longIterator = node.getConnectedNodes().iterator();
                    while (longIterator.hasNext()) {
                        long connectedPos = (Long)longIterator.next();
                        connections.add(class_2338.method_10092((long)connectedPos));
                    }
                    networkNodes.add(new DestinationResponseS2C.NodeNetworkInfo(node.getBlockPos(), node.getClearance(), connections));
                }
            });
            UUID networkUuid = null;
            PathGraph.NetworkCache networkCache = graph.getNetworkCache(sourceNode);
            if (networkCache != null) {
                networkUuid = networkCache.id();
            }
            DestinationResponseS2C resp = new DestinationResponseS2C(infos, sourceSignPos, sourceNodePos, networkNodes, networkUuid != null ? networkUuid : UUID.randomUUID());
            ViaRomanaModVariables.networkHandler.sendToPlayer(player, resp);
        });
    }

    private static void handleSignValidationRequestC2S(SignValidationRequestC2S packet, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3222 player = context.player();
            class_3218 level = player.method_51469();
            class_2338 nodePos = packet.nodePos();
            IPathStorage storage = IPathStorage.get((class_1937)level);
            PathGraph graph = storage.graph();
            Optional<Node> nodeOpt = graph.getNodeAt(nodePos);
            if (nodeOpt.isEmpty()) {
                SignValidationResponseS2C response = new SignValidationResponseS2C(nodePos, false);
                ViaRomanaModVariables.networkHandler.sendToPlayer(player, response);
                return;
            }
            Node node = nodeOpt.get();
            boolean isSignValid = node.getSignPos().map(signPosLong -> LinkHandler.isSignBlock((class_1936)level, class_2338.method_10092((long)signPosLong))).orElse(true);
            if (!isSignValid) {
                node.getSignPos().ifPresent(signPosLong -> graph.removeSignLink(class_2338.method_10092((long)signPosLong)));
                storage.method_80();
                ViaRomanaLandmarkManager.removeDestinationLandmark((class_1937)level, node);
                PathSyncUtils.syncPathGraphToAllPlayers(level);
            }
            SignValidationResponseS2C response = new SignValidationResponseS2C(nodePos, isSignValid);
            ViaRomanaModVariables.networkHandler.sendToPlayer(player, response);
        });
    }

    private static void handleChartedPathC2S(ChartedPathC2S packet, ServerPlayNetworking.Context context) {
        context.server().execute(() -> {
            class_3218 level = context.player().method_51469();
            IPathStorage storage = IPathStorage.get((class_1937)level);
            List<Node.NodeData> chartingNodes = packet.getChartedNodes();
            if (chartingNodes.isEmpty()) {
                ViaRomana.LOGGER.warn("Received empty charted path from player {}", (Object)context.player().method_5477().getString());
                return;
            }
            try {
                storage.graph().createConnectedPath(chartingNodes);
                storage.method_80();
                PathSyncUtils.syncPathGraphToAllPlayers(level);
                ViaRomanaModPacketHandler.awardAdvancementIfNeeded(context.player(), "via_romana:story/a_strand_type_game");
                ViaRomana.LOGGER.debug("Created charted path with {} nodes for player {}", (Object)chartingNodes.size(), (Object)context.player().method_5477().getString());
            }
            catch (Exception e) {
                ViaRomana.LOGGER.error("Failed to create charted path for player {}: {}", (Object)context.player().method_5477().getString(), (Object)e.getMessage());
            }
        });
    }

    private static void awardAdvancementIfNeeded(class_3222 player, String id) {
        try {
            class_167 advancementProgress;
            class_2960 advancementId = class_2960.method_60654((String)id);
            class_8779 advancement = player.field_13995.method_3851().method_12896(advancementId);
            if (advancement != null && !(advancementProgress = player.method_14236().method_12882(advancement)).method_740()) {
                boolean grantedAny = false;
                for (String criterion : advancementProgress.method_731()) {
                    boolean granted = player.method_14236().method_12878(advancement, criterion);
                    if (!granted) continue;
                    grantedAny = true;
                }
                if (grantedAny) {
                    player.method_14236().method_12876(player);
                }
            }
        }
        catch (Exception e) {
            ViaRomana.LOGGER.warn("Failed to award advancement {} to player {}: {}", (Object)id, (Object)player.method_5477().getString(), (Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

