/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1923;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;

public final class ServerMapUtils {
    public static final float MAP_BOUNDS_PADDING_PERCENTAGE = 0.1f;
    public static final int MAP_BOUNDS_MIN_PADDING = 16;

    private ServerMapUtils() {
    }

    public static Set<class_1923> calculateFogOfWarChunks(List<DestinationResponseS2C.NodeNetworkInfo> networkNodes, class_1923 minChunk, class_1923 maxChunk) {
        HashSet<class_1923> allowedChunks = new HashSet<class_1923>();
        if (networkNodes == null || networkNodes.isEmpty()) {
            for (int cx = minChunk.field_9181; cx <= maxChunk.field_9181; ++cx) {
                for (int cz = minChunk.field_9180; cz <= maxChunk.field_9180; ++cz) {
                    allowedChunks.add(new class_1923(cx, cz));
                }
            }
            return allowedChunks;
        }
        int FOG_OF_WAR_DISTANCE = CommonConfig.fog_of_war_distance;
        int radiusSq = FOG_OF_WAR_DISTANCE * FOG_OF_WAR_DISTANCE;
        for (DestinationResponseS2C.NodeNetworkInfo node : networkNodes) {
            class_1923 nodeChunk = new class_1923(node.position);
            for (int dx = -FOG_OF_WAR_DISTANCE; dx <= FOG_OF_WAR_DISTANCE; ++dx) {
                for (int dz = -FOG_OF_WAR_DISTANCE; dz <= FOG_OF_WAR_DISTANCE; ++dz) {
                    if (dx * dx + dz * dz > radiusSq) continue;
                    int tx = nodeChunk.field_9181 + dx;
                    int tz = nodeChunk.field_9180 + dz;
                    if (tx < minChunk.field_9181 || tx > maxChunk.field_9181 || tz < minChunk.field_9180 || tz > maxChunk.field_9180) continue;
                    allowedChunks.add(new class_1923(tx, tz));
                }
            }
        }
        return allowedChunks;
    }
}

