/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapBakeWorker;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.surveyor.SurveyorUtil;

public final class ServerMapCache {
    private static final String MAP_DIR_NAME = "via_romana/network_images";
    private static final Map<UUID, MapInfo> cache = new ConcurrentHashMap<UUID, MapInfo>();
    private static final Map<UUID, Set<class_1923>> dirtyNetworks = new ConcurrentHashMap<UUID, Set<class_1923>>();
    private static final Map<class_5321<class_1937>, Set<class_1923>> scannedChunksByLevel = new ConcurrentHashMap<class_5321<class_1937>, Set<class_1923>>();
    private static final Set<UUID> modifiedForSaving = ConcurrentHashMap.newKeySet();
    private static ScheduledExecutorService scheduler;
    private static MinecraftServer minecraftServer;

    private ServerMapCache() {
    }

    public static void init(MinecraftServer server) {
        minecraftServer = server;
        ServerMapCache.shutdown();
        scheduler = Executors.newScheduledThreadPool(2);
        ViaRomana.LOGGER.info("Starting Via Romana schedulers...");
        scheduler.scheduleAtFixedRate(() -> ServerMapCache.runSafe(ServerMapCache::processAllDirtyNetworks, "Error during scheduled map reprocessing"), CommonConfig.map_refresh_interval, CommonConfig.map_refresh_interval, TimeUnit.SECONDS);
        ViaRomana.LOGGER.debug("Scheduled map reprocessing every {} seconds.", (Object)CommonConfig.map_refresh_interval);
        scheduler.scheduleAtFixedRate(() -> ServerMapCache.runSafe(() -> ServerMapCache.saveAllToDisk(false), "Error during scheduled map cache saving"), CommonConfig.map_save_interval, CommonConfig.map_save_interval, TimeUnit.MINUTES);
        ViaRomana.LOGGER.debug("Scheduled map saving every {} minutes.", (Object)CommonConfig.map_save_interval);
    }

    public static void shutdown() {
        if (scheduler != null && !scheduler.isShutdown()) {
            scheduler.shutdown();
            try {
                if (!scheduler.awaitTermination(5L, TimeUnit.SECONDS)) {
                    scheduler.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                scheduler.shutdownNow();
                Thread.currentThread().interrupt();
            }
            ViaRomana.LOGGER.info("Via Romana schedulers shut down.");
        }
    }

    public static void markChunkDirty(class_3218 level, class_1923 pos) {
        boolean isNewChunkThisCycle = scannedChunksByLevel.computeIfAbsent((class_5321<class_1937>)level.method_27983(), k -> ConcurrentHashMap.newKeySet()).add(pos);
        if (!isNewChunkThisCycle) {
            return;
        }
        PathGraph graph = PathGraph.getInstance(level);
        if (graph == null) {
            return;
        }
        graph.findNetworksForChunk(pos).forEach(network -> {
            UUID networkId = network.id();
            dirtyNetworks.computeIfAbsent(networkId, k -> ConcurrentHashMap.newKeySet()).add(pos);
        });
    }

    public static void processAllDirtyNetworks() {
        if (!scannedChunksByLevel.isEmpty()) {
            ConcurrentHashMap<class_5321<class_1937>, Set<class_1923>> chunksToScan = new ConcurrentHashMap<class_5321<class_1937>, Set<class_1923>>(scannedChunksByLevel);
            scannedChunksByLevel.clear();
            chunksToScan.forEach((levelKey, chunks) -> {
                class_3218 level = minecraftServer.method_3847(levelKey);
                if (level != null) {
                    minecraftServer.execute(() -> chunks.forEach(chunkPos -> SurveyorUtil.refreshChunkTerrain(level, chunkPos)));
                }
            });
        }
        if (dirtyNetworks.isEmpty()) {
            return;
        }
        ConcurrentHashMap<UUID, Set<class_1923>> toProcess = new ConcurrentHashMap<UUID, Set<class_1923>>(dirtyNetworks);
        dirtyNetworks.clear();
        ViaRomana.LOGGER.debug("Processing {} dirty networks in scheduled update batch.", (Object)toProcess.size());
        toProcess.forEach((networkId, chunks) -> {
            if (chunks != null && !chunks.isEmpty()) {
                minecraftServer.execute(() -> ServerMapCache.updateOrGenerateMapAsync(networkId, chunks));
            }
        });
    }

    private static CompletableFuture<MapInfo> updateOrGenerateMapAsync(UUID networkId, Collection<class_1923> chunksToUpdate) {
        return ServerMapCache.findLevelForNetwork(networkId).map(level -> {
            PathGraph.NetworkCache network;
            PathGraph graph = PathGraph.getInstance(level);
            PathGraph.NetworkCache networkCache = network = graph != null ? graph.getNetworkCache(networkId) : null;
            if (network == null) {
                ViaRomana.LOGGER.warn("Could not find network cache for network {}, aborting update.", (Object)networkId);
                return CompletableFuture.completedFuture(null);
            }
            return CompletableFuture.supplyAsync(() -> {
                MapInfo newResult;
                MapBakeWorker worker = new MapBakeWorker();
                MapInfo previousResult = cache.get(networkId);
                if (previousResult != null && previousResult.hasImageData()) {
                    ViaRomana.LOGGER.debug("Performing incremental update for network {}.", (Object)networkId);
                    newResult = worker.updateMap(previousResult, (Set<class_1923>)new HashSet<class_1923>(chunksToUpdate), (class_3218)level, network);
                } else {
                    ViaRomana.LOGGER.debug("Performing full bake for network {}.", (Object)networkId);
                    newResult = worker.bake(networkId, (class_3218)level, network.getMin(), network.getMax(), network.getNodesAsInfo());
                }
                cache.put(networkId, newResult);
                modifiedForSaving.add(networkId);
                ViaRomana.LOGGER.debug("Map update completed for network {}.", (Object)networkId);
                return newResult;
            }, (Executor)minecraftServer).exceptionally(ex -> {
                ViaRomana.LOGGER.error("Failed during map update for network {}", (Object)networkId, ex);
                return null;
            });
        }).orElseGet(() -> {
            ViaRomana.LOGGER.warn("Could not find level for network {}, aborting update.", (Object)networkId);
            return CompletableFuture.completedFuture(null);
        });
    }

    private static Optional<class_3218> findLevelForNetwork(UUID networkId) {
        for (class_3218 level : minecraftServer.method_3738()) {
            PathGraph graph = PathGraph.getInstance(level);
            if (graph == null || graph.getNetworkCache(networkId) == null) continue;
            return Optional.of(level);
        }
        return Optional.empty();
    }

    public static Optional<MapInfo> getMapData(UUID networkId) {
        MapInfo result = cache.get(networkId);
        if (result != null) {
            return Optional.of(result);
        }
        return ServerMapCache.loadFromDisk(networkId);
    }

    public static CompletableFuture<MapInfo> generateMapIfNeeded(UUID networkId, class_3218 level) {
        return ServerMapCache.getMapData(networkId).map(CompletableFuture::completedFuture).orElseGet(() -> {
            PathGraph.NetworkCache network;
            ViaRomana.LOGGER.debug("Generating initial map for network {} (client request).", (Object)networkId);
            PathGraph graph = PathGraph.getInstance(level);
            if (graph != null && (network = graph.getNetworkCache(networkId)) != null) {
                network.getNodesAsInfo().forEach(node -> SurveyorUtil.refreshChunkTerrain(level, new class_1923(node.position)));
                Set<class_1923> allChunks = network.getNodesAsInfo().stream().map(node -> new class_1923(node.position)).collect(Collectors.toSet());
                return ServerMapCache.updateOrGenerateMapAsync(networkId, allChunks);
            }
            ViaRomana.LOGGER.warn("Could not find network to generate map for networkId {}", (Object)networkId);
            return CompletableFuture.completedFuture(null);
        });
    }

    private static Optional<MapInfo> loadFromDisk(UUID networkId) {
        try {
            class_2487 tag;
            byte[] png;
            Path mapDir = ServerMapCache.getMapDirectory();
            String base = "network-" + String.valueOf(networkId);
            Path pngPath = mapDir.resolve(base + ".png");
            Path metaPath = mapDir.resolve(base + ".nbt");
            try (InputStream pngStream = Files.newInputStream(pngPath, new OpenOption[0]);
                 InputStream metaStream = Files.newInputStream(metaPath, new OpenOption[0]);){
                png = pngStream.readAllBytes();
                tag = class_2507.method_10629((InputStream)metaStream, (class_2505)new class_2505(Long.MAX_VALUE, Integer.MAX_VALUE));
            }
            catch (NoSuchFileException e) {
                return Optional.empty();
            }
            class_2338 min = class_2338.method_10092((long)tag.method_10537("min"));
            class_2338 max = class_2338.method_10092((long)tag.method_10537("max"));
            int scale = tag.method_10550("scale");
            MapInfo info = MapInfo.fromServerCache(networkId, min, max, List.of(), png, scale, List.of());
            cache.put(networkId, info);
            return Optional.of(info);
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("Failed to load map {} from disk", (Object)networkId, (Object)e);
            return Optional.empty();
        }
    }

    public static void invalidate(UUID networkId) {
        dirtyNetworks.remove(networkId);
        cache.remove(networkId);
        modifiedForSaving.remove(networkId);
        try {
            Path mapDir = ServerMapCache.getMapDirectory();
            String base = "network-" + String.valueOf(networkId);
            boolean pngDeleted = Files.deleteIfExists(mapDir.resolve(base + ".png"));
            boolean nbtDeleted = Files.deleteIfExists(mapDir.resolve(base + ".nbt"));
            if (pngDeleted || nbtDeleted) {
                ViaRomana.LOGGER.debug("Deleted map files from disk for network {}", (Object)networkId);
            }
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("Failed to delete map files from disk for network {}", (Object)networkId, (Object)e);
        }
    }

    public static void clear() {
        cache.clear();
        dirtyNetworks.clear();
        modifiedForSaving.clear();
        scannedChunksByLevel.clear();
    }

    public static void saveAllToDisk(boolean forceSave) {
        HashSet<UUID> networksToSave;
        if (modifiedForSaving.isEmpty() && !forceSave) {
            return;
        }
        HashSet<UUID> hashSet = networksToSave = forceSave ? new HashSet<UUID>(cache.keySet()) : new HashSet<UUID>(modifiedForSaving);
        if (networksToSave.isEmpty()) {
            return;
        }
        ViaRomana.LOGGER.debug("Saving {} maps to disk...", (Object)networksToSave.size());
        try {
            Path mapDir = ServerMapCache.getMapDirectory();
            Files.createDirectories(mapDir, new FileAttribute[0]);
            int savedCount = 0;
            for (UUID id : networksToSave) {
                MapInfo info = cache.get(id);
                if (info == null || !info.hasImageData()) {
                    ServerMapCache.invalidate(id);
                    continue;
                }
                String base = "network-" + String.valueOf(id);
                Path pngPath = mapDir.resolve(base + ".png");
                Path nbtPath = mapDir.resolve(base + ".nbt");
                class_2487 tag = new class_2487();
                tag.method_10544("min", info.minBounds().method_10063());
                tag.method_10544("max", info.maxBounds().method_10063());
                tag.method_10569("scale", info.bakeScaleFactor());
                if (info.createdAtMs() != null) {
                    tag.method_10544("createdAt", info.createdAtMs().longValue());
                }
                try {
                    OutputStream pngOut = Files.newOutputStream(pngPath, new OpenOption[0]);
                    try {
                        OutputStream nbtOut = Files.newOutputStream(nbtPath, new OpenOption[0]);
                        try {
                            pngOut.write(info.pngData());
                            class_2507.method_10634((class_2487)tag, (OutputStream)nbtOut);
                            ++savedCount;
                        }
                        finally {
                            if (nbtOut == null) continue;
                            nbtOut.close();
                        }
                    }
                    finally {
                        if (pngOut == null) continue;
                        pngOut.close();
                    }
                }
                catch (IOException e) {
                    ViaRomana.LOGGER.error("Failed to write map files for network {}", (Object)id, (Object)e);
                }
            }
            if (savedCount > 0) {
                ViaRomana.LOGGER.debug("Saved {} modified maps to disk.", (Object)savedCount);
            }
            modifiedForSaving.removeAll(networksToSave);
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("Failed to save map cache to disk.", (Throwable)e);
        }
    }

    public static void deleteAllMapsFromDisk() {
        block8: {
            ServerMapCache.clear();
            try {
                Path mapDir = ServerMapCache.getMapDirectory();
                if (!Files.exists(mapDir, new LinkOption[0])) break block8;
                try (Stream<Path> stream = Files.walk(mapDir, new FileVisitOption[0]);){
                    stream.sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                }
                ViaRomana.LOGGER.debug("Deleted all map files from disk.");
            }
            catch (IOException e) {
                ViaRomana.LOGGER.error("Failed to delete map directory from disk.", (Throwable)e);
            }
        }
    }

    private static Path getMapDirectory() {
        return minecraftServer.method_27050(class_5218.field_24188).resolve(MAP_DIR_NAME);
    }

    private static void runSafe(Runnable task, String errorMessage) {
        try {
            task.run();
        }
        catch (Exception e) {
            ViaRomana.LOGGER.error(errorMessage, (Throwable)e);
        }
    }
}

