/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;

public record MapInfo(UUID networkId, class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes, byte[] pngData, int bakeScaleFactor, Long createdAtMs, List<class_1923> allowedChunks) {
    public MapInfo {
        networkNodes = networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList();
        pngData = pngData != null ? (byte[])pngData.clone() : null;
        allowedChunks = allowedChunks != null ? new ArrayList<class_1923>(allowedChunks) : null;
    }

    public static MapInfo request(UUID networkId, class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        return new MapInfo(networkId, minBounds, maxBounds, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList(), null, 1, null, null);
    }

    public static MapInfo response(UUID networkId, class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes, byte[] pngData, int bakeScaleFactor) {
        return new MapInfo(networkId, minBounds, maxBounds, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList(), pngData != null ? (byte[])pngData.clone() : null, bakeScaleFactor, System.currentTimeMillis(), null);
    }

    public static MapInfo fromServerCache(UUID networkId, class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes, byte[] pngData, int bakeScaleFactor, List<class_1923> allowedChunks) {
        return new MapInfo(networkId, minBounds, maxBounds, networkNodes != null ? new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(networkNodes) : new ArrayList(), pngData != null ? (byte[])pngData.clone() : null, bakeScaleFactor, System.currentTimeMillis(), (List<class_1923>)(allowedChunks != null ? new ArrayList<class_1923>(allowedChunks) : null));
    }

    public boolean hasImageData() {
        return this.pngData != null;
    }

    public boolean isRequest() {
        return this.pngData == null;
    }

    public boolean isResponse() {
        return this.pngData != null;
    }

    public int getWorldWidth() {
        return this.maxBounds.method_10263() - this.minBounds.method_10263() + 1;
    }

    public int getWorldHeight() {
        return this.maxBounds.method_10260() - this.minBounds.method_10260() + 1;
    }

    public boolean hasTimestamp() {
        return this.createdAtMs != null;
    }

    public long getAgeMs() {
        return this.createdAtMs != null ? System.currentTimeMillis() - this.createdAtMs : 0L;
    }

    public String getFormattedAge() {
        if (this.createdAtMs == null) {
            return "no timestamp";
        }
        long ageMs = this.getAgeMs();
        if (ageMs < 1000L) {
            return ageMs + "ms ago";
        }
        if (ageMs < 60000L) {
            return ageMs / 1000L + "s ago";
        }
        return ageMs / 60000L + "m ago";
    }

    public void writeToBuffer(class_2540 buffer) {
        buffer.method_10797(this.networkId);
        buffer.method_10807(this.minBounds);
        buffer.method_10807(this.maxBounds);
        buffer.method_53002(this.networkNodes.size());
        for (DestinationResponseS2C.NodeNetworkInfo node : this.networkNodes) {
            buffer.method_10807(node.position);
            buffer.method_52941(node.clearance);
            buffer.method_53002(node.connections.size());
            for (class_2338 connection : node.connections) {
                buffer.method_10807(connection);
            }
        }
        if (this.pngData != null) {
            buffer.method_52964(true);
            buffer.method_53002(this.pngData.length);
            buffer.method_52983(this.pngData);
            buffer.method_53002(this.bakeScaleFactor);
            buffer.method_52974(this.createdAtMs != null ? this.createdAtMs : 0L);
        } else {
            buffer.method_52964(false);
        }
        if (this.allowedChunks != null) {
            buffer.method_52964(true);
            buffer.method_53002(this.allowedChunks.size());
            for (class_1923 cp : this.allowedChunks) {
                buffer.method_53002(cp.field_9181);
                buffer.method_53002(cp.field_9180);
            }
        } else {
            buffer.method_52964(false);
        }
    }

    public static MapInfo readFromBuffer(class_2540 buffer) {
        UUID networkId = buffer.method_10790();
        class_2338 minBounds = buffer.method_10811();
        class_2338 maxBounds = buffer.method_10811();
        int nodeCount = buffer.readInt();
        ArrayList<DestinationResponseS2C.NodeNetworkInfo> networkNodes = new ArrayList<DestinationResponseS2C.NodeNetworkInfo>(nodeCount);
        for (int i = 0; i < nodeCount; ++i) {
            class_2338 nodePos = buffer.method_10811();
            float clearance = buffer.readFloat();
            int connectionCount = buffer.readInt();
            ArrayList<class_2338> connections = new ArrayList<class_2338>(connectionCount);
            for (int j = 0; j < connectionCount; ++j) {
                connections.add(buffer.method_10811());
            }
            networkNodes.add(new DestinationResponseS2C.NodeNetworkInfo(nodePos, clearance, connections));
        }
        boolean hasImageData = buffer.readBoolean();
        byte[] pngData = null;
        int bakeScaleFactor = 1;
        Long createdAtMs = null;
        if (hasImageData) {
            int length = buffer.readInt();
            pngData = new byte[length];
            buffer.method_52979(pngData);
            bakeScaleFactor = buffer.readInt();
            long ts = buffer.readLong();
            createdAtMs = ts == 0L ? null : Long.valueOf(ts);
        }
        ArrayList<class_1923> allowed = null;
        boolean hasChunks = buffer.readBoolean();
        if (hasChunks) {
            int size = buffer.readInt();
            allowed = new ArrayList<class_1923>(size);
            for (int i = 0; i < size; ++i) {
                int x = buffer.readInt();
                int z = buffer.readInt();
                allowed.add(new class_1923(x, z));
            }
        }
        return new MapInfo(networkId, minBounds, maxBounds, networkNodes, pngData, bakeScaleFactor, createdAtMs, allowed);
    }
}

