/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.map;

import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.LayerSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.RegistryPalette;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.imageio.ImageIO;
import net.minecraft.class_1923;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3620;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.map.ServerMapUtils;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.surveyor.SurveyorUtil;

public class MapBakeWorker {
    public MapInfo bake(UUID networkId, class_3218 level, class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        int widthW = maxBounds.method_10263() - minBounds.method_10263();
        int heightW = maxBounds.method_10260() - minBounds.method_10260();
        int padX = Math.max(16, (int)((float)widthW * 0.1f));
        int padZ = Math.max(16, (int)((float)heightW * 0.1f));
        class_2338 paddedMin = minBounds.method_10069(-padX, 0, -padZ);
        class_2338 paddedMax = maxBounds.method_10069(padX, 0, padZ);
        int exactWidth = paddedMax.method_10263() - paddedMin.method_10263() + 1;
        int exactHeight = paddedMax.method_10260() - paddedMin.method_10260() + 1;
        int scaleFactor = this.calculateScaleFactor(exactWidth, exactHeight);
        int finalImgW = exactWidth / scaleFactor;
        int finalImgH = exactHeight / scaleFactor;
        WorldTerrainSummary terrain = SurveyorUtil.getTerrain(level);
        if (terrain == null) {
            throw new IllegalStateException("Surveyor terrain data is null");
        }
        PathGraph graph = PathGraph.getInstance(level);
        if (graph == null) {
            throw new IllegalStateException("PathGraph is null");
        }
        PathGraph.NetworkCache network = graph.getNetworkCache(networkId);
        PathGraph.FoWCache fowCache = graph.getOrComputeFoWCache(network);
        if (fowCache == null) {
            throw new IllegalStateException("Surveyor terrain data is null");
        }
        class_1923 minChunk = fowCache.minChunk();
        class_1923 maxChunk = fowCache.maxChunk();
        int chunkAreaWidth = (maxChunk.field_9181 - minChunk.field_9181 + 1) * 16;
        int chunkAreaHeight = (maxChunk.field_9180 - minChunk.field_9180 + 1) * 16;
        Set<class_1923> allowedChunks = fowCache != null ? fowCache.allowedChunks() : ServerMapUtils.calculateFogOfWarChunks(networkNodes, minChunk, maxChunk);
        BufferedImage chunkAreaImg = new BufferedImage(chunkAreaWidth / scaleFactor, chunkAreaHeight / scaleFactor, 2);
        this.processSurveyorChunks(chunkAreaImg, level, terrain, minChunk, maxChunk, allowedChunks, scaleFactor);
        int cropOffsetX = paddedMin.method_10263() - minChunk.field_9181 * 16;
        int cropOffsetZ = paddedMin.method_10260() - minChunk.field_9180 * 16;
        BufferedImage finalImg = chunkAreaImg;
        if (cropOffsetX != 0 || cropOffsetZ != 0 || exactWidth != chunkAreaWidth || exactHeight != chunkAreaHeight) {
            int scaledCropX = cropOffsetX / scaleFactor;
            int scaledCropZ = cropOffsetZ / scaleFactor;
            if (scaledCropX + finalImgW > chunkAreaImg.getWidth() || scaledCropZ + finalImgH > chunkAreaImg.getHeight()) {
                throw new IllegalStateException("Crop bounds exceed chunk area image dimensions");
            }
            finalImg = chunkAreaImg.getSubimage(scaledCropX, scaledCropZ, finalImgW, finalImgH);
        }
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)finalImg, "PNG", outputStream);
            return MapInfo.fromServerCache(networkId, paddedMin, paddedMax, networkNodes, outputStream.toByteArray(), scaleFactor, new ArrayList<class_1923>(allowedChunks));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert map to PNG", e);
        }
    }

    public MapInfo updateMap(MapInfo previousResult, Set<class_1923> dirtyChunks, class_3218 level, PathGraph.NetworkCache network) {
        ViaRomana.LOGGER.debug("MapBakeWorker.updateMap() called with {} dirty chunks for network {}", (Object)dirtyChunks.size(), (Object)previousResult.networkId());
        StringBuilder dirtyChunksList = new StringBuilder();
        for (class_1923 pos : dirtyChunks) {
            dirtyChunksList.append(pos.toString()).append(" ");
        }
        ViaRomana.LOGGER.debug("Dirty chunks to update: {}", (Object)dirtyChunksList.toString().trim());
        try {
            BufferedImage mapImage = ImageIO.read(new ByteArrayInputStream(previousResult.pngData()));
            Graphics2D graphics = mapImage.createGraphics();
            WorldTerrainSummary terrain = SurveyorUtil.getTerrain(level);
            if (terrain == null) {
                ViaRomana.LOGGER.error("Cannot update map: Surveyor terrain is null.");
                return previousResult;
            }
            class_2338 paddedMin = previousResult.minBounds();
            int scaleFactor = previousResult.bakeScaleFactor();
            class_1923 minChunk = new class_1923(paddedMin);
            ViaRomana.LOGGER.debug("Map update: minBounds(padded)={}, scaleFactor={}, minChunk={}", (Object)paddedMin, (Object)scaleFactor, (Object)minChunk);
            int chunksUpdated = 0;
            int chunksSkippedNoData = 0;
            for (class_1923 dirtyPos : dirtyChunks) {
                ChunkSummary summary = terrain.get(dirtyPos);
                if (summary == null) {
                    ++chunksSkippedNoData;
                    ViaRomana.LOGGER.warn("No Surveyor data for dirty chunk {}", (Object)dirtyPos);
                    continue;
                }
                int relBlockX = dirtyPos.field_9181 * 16 - paddedMin.method_10263();
                int relBlockZ = dirtyPos.field_9180 * 16 - paddedMin.method_10260();
                int chunkImgX = relBlockX / scaleFactor;
                int chunkImgZ = relBlockZ / scaleFactor;
                ViaRomana.LOGGER.debug("Updating chunk {} at image position ({}, {})", (Object)dirtyPos, (Object)chunkImgX, (Object)chunkImgZ);
                int scaledChunkSize = 16 / scaleFactor;
                if (scaledChunkSize <= 0) {
                    scaledChunkSize = 1;
                }
                BufferedImage chunkImage = new BufferedImage(scaledChunkSize, scaledChunkSize, 2);
                this.renderSurveyorChunk(chunkImage, level, terrain, summary, dirtyPos, dirtyPos.field_9181, dirtyPos.field_9180, scaleFactor);
                graphics.drawImage((Image)chunkImage, chunkImgX, chunkImgZ, null);
                ++chunksUpdated;
            }
            graphics.dispose();
            ViaRomana.LOGGER.debug("Map incremental update completed: {} chunks updated, {} chunks skipped (no data)", (Object)chunksUpdated, (Object)chunksSkippedNoData);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)mapImage, "PNG", outputStream);
            return MapInfo.fromServerCache(previousResult.networkId(), previousResult.minBounds(), previousResult.maxBounds(), previousResult.networkNodes(), outputStream.toByteArray(), scaleFactor, previousResult.allowedChunks());
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("Failed to update map incrementally, performing a full re-bake.", (Throwable)e);
            return this.bake(previousResult.networkId(), level, network.getMin(), network.getMax(), network.getNodesAsInfo());
        }
    }

    private int calculateScaleFactor(int width, int height) {
        int MAX_DIM;
        int maxDim = Math.max(width, height);
        if (maxDim <= (MAX_DIM = CommonConfig.maximum_map_dimension)) {
            return 1;
        }
        int requiredScale = (int)Math.ceil((double)maxDim / (double)MAX_DIM);
        return Integer.highestOneBit(requiredScale - 1) << 1;
    }

    private void processSurveyorChunks(BufferedImage img, class_3218 level, WorldTerrainSummary terrain, class_1923 min, class_1923 max, Set<class_1923> allowedChunks, int scaleFactor) {
        ViaRomana.LOGGER.debug("Processing Surveyor chunks: area from {} to {}, {} allowed chunks, scale factor {}", (Object)min, (Object)max, (Object)allowedChunks.size(), (Object)scaleFactor);
        int chunksWithData = this.attemptRender(img, level, terrain, min, max, allowedChunks, scaleFactor);
        ViaRomana.LOGGER.debug("Surveyor chunk processing complete: {} chunks had data out of {} allowed chunks", (Object)chunksWithData, (Object)allowedChunks.size());
        if (chunksWithData == 0 && !allowedChunks.isEmpty()) {
            ViaRomana.LOGGER.warn("Map Bake: No Surveyor chunk data was available for the requested map area. The map may appear blank.");
        }
    }

    private int attemptRender(BufferedImage img, class_3218 level, WorldTerrainSummary terrain, class_1923 min, class_1923 max, Set<class_1923> allowedChunks, int scaleFactor) {
        int surveyorDataChunks = 0;
        int totalChecked = 0;
        for (int cx = min.field_9181; cx <= max.field_9181; ++cx) {
            for (int cz = min.field_9180; cz <= max.field_9180; ++cz) {
                class_1923 chunkPos = new class_1923(cx, cz);
                if (!allowedChunks.contains(chunkPos)) continue;
                ++totalChecked;
                ChunkSummary chunkSummary = terrain.get(chunkPos);
                if (chunkSummary != null) {
                    ++surveyorDataChunks;
                    ViaRomana.LOGGER.debug("Rendering chunk {} with Surveyor data", (Object)chunkPos);
                    this.renderSurveyorChunk(img, level, terrain, chunkSummary, min, cx, cz, scaleFactor);
                    continue;
                }
                ViaRomana.LOGGER.debug("No Surveyor data for chunk {}", (Object)chunkPos);
            }
        }
        ViaRomana.LOGGER.debug("Render attempt complete: {}/{} chunks had Surveyor data", (Object)surveyorDataChunks, (Object)totalChecked);
        return surveyorDataChunks;
    }

    private void renderSurveyorChunk(BufferedImage img, class_3218 level, WorldTerrainSummary terrain, ChunkSummary summary, class_1923 minPos, int cx, int cz, int scaleFactor) {
        LayerSummary.Raw layer = summary.toSingleLayer(null, null, level.method_31600());
        if (layer == null) {
            return;
        }
        RegistryPalette.ValueView blockPalette = terrain.getBlockPalette(new class_1923(cx, cz));
        int worldTop = level.method_31600();
        int[] heights = new int[256];
        for (int i = 0; i < 256; ++i) {
            heights[i] = layer.exists().get(i) ? worldTop - layer.depths()[i] : Integer.MIN_VALUE;
        }
        int baseX = (cx - minPos.field_9181) * 16;
        int baseZ = (cz - minPos.field_9180) * 16;
        for (int lx = 0; lx < 16; lx += scaleFactor) {
            for (int lz = 0; lz < 16; lz += scaleFactor) {
                int color;
                int px = (baseX + lx) / scaleFactor;
                int pz = (baseZ + lz) / scaleFactor;
                if (px >= img.getWidth() || pz >= img.getHeight() || (color = this.getPixelColor(lx * 16 + lz, heights, layer.blocks(), layer.waterDepths(), layer.exists(), blockPalette)) == -1) continue;
                img.setRGB(px, pz, color | 0xFF000000);
            }
        }
    }

    private int getPixelColor(int idx, int[] heights, int[] blocks, int[] waterDepths, BitSet exists, RegistryPalette.ValueView blockPalette) {
        class_3620.class_6594 brightness;
        class_3620 mapColor;
        boolean hasWater;
        boolean bl = hasWater = waterDepths != null && waterDepths[idx] > 0;
        if (!exists.get(idx) && !hasWater) {
            return -1;
        }
        if (hasWater) {
            mapColor = class_3620.field_16019;
            brightness = this.calculateWaterBrightness(idx, waterDepths[idx]);
        } else {
            class_2248 block = (class_2248)blockPalette.method_10200(blocks[idx]);
            if (block == null || block == class_2246.field_10124) {
                return -1;
            }
            mapColor = block.method_26403();
            brightness = this.calculateTerrainBrightness(heights, idx);
        }
        int mcColor = mapColor.method_15820(brightness);
        return (mcColor & 0xFF) << 16 | mcColor & 0xFF00 | mcColor >> 16 & 0xFF;
    }

    private class_3620.class_6594 calculateWaterBrightness(int idx, int waterDepth) {
        double shade = Math.min((double)waterDepth / 8.0, 1.0) + (double)((idx >> 4) + (idx & 0xF) & 1) * 0.15;
        return shade < 0.3 ? class_3620.class_6594.field_34761 : (shade > 0.7 ? class_3620.class_6594.field_34759 : class_3620.class_6594.field_34760);
    }

    private class_3620.class_6594 calculateTerrainBrightness(int[] heights, int idx) {
        int lz;
        int currentHeight = heights[idx];
        int lx = idx >> 4;
        int westHeight = lx > 0 ? heights[idx - 16] : currentHeight;
        double shade = (double)(currentHeight - westHeight) * 4.0 / 2.0 + ((double)((lz = idx & 0xF) + lx & 1) - 0.5) * 0.4;
        if (shade > 0.6) {
            return class_3620.class_6594.field_34761;
        }
        if (shade < -0.6) {
            return class_3620.class_6594.field_34759;
        }
        return class_3620.class_6594.field_34760;
    }
}

