/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.gui.MapRenderer;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.storage.IPathStorage;
import net.rasanovum.viaromana.util.PathSyncUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public class ViaRomanaCommands {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"viaromana").requires(source -> source.method_9259(2))).then(class_2170.method_9247((String)"nodes").then(class_2170.method_9247((String)"clear").executes(ViaRomanaCommands::clearAllNodes)))).then(class_2170.method_9247((String)"cache").then(class_2170.method_9247((String)"clear").executes(ViaRomanaCommands::clearCache)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"maps").then(class_2170.method_9247((String)"clear").executes(ViaRomanaCommands::clearMaps))).then(class_2170.method_9247((String)"regenerate").executes(ViaRomanaCommands::regenerateMaps))).then(class_2170.method_9247((String)"save").executes(ViaRomanaCommands::saveMaps))));
    }

    private static int clearAllNodes(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        for (class_1657 player : source.method_9225().method_18456()) {
            VariableAccess.playerVariables.setChartingPath((class_1297)player, false);
            VariableAccess.playerVariables.syncAndSave((class_1297)player);
        }
        IPathStorage storage = IPathStorage.get((class_1937)source.method_9225());
        PathGraph graph = storage.graph();
        int nodeCount = graph.size();
        graph.removeAllNodes();
        ClientPathData.getInstance().clearData();
        PathSyncUtils.syncPathGraphToAllPlayers(source.method_9225());
        storage.method_80();
        source.method_9226(() -> class_2561.method_43470((String)("Cleared " + nodeCount + " nodes")), true);
        return nodeCount;
    }

    private static int clearCache(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        if (source.method_9225().method_8608()) {
            ClientPathData.getInstance().clearData();
            MapRenderer.clearCache();
        }
        PathSyncUtils.syncPathGraphToPlayer(source.method_9207());
        ServerMapCache.clear();
        source.method_9226(() -> class_2561.method_43470((String)"Cleared all Via Romana caches"), true);
        return 1;
    }

    private static int clearMaps(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerMapCache.clear();
        ServerMapCache.deleteAllMapsFromDisk();
        if (source.method_9225().method_8608()) {
            MapRenderer.clearCache();
        }
        source.method_9226(() -> class_2561.method_43470((String)"Cleared Via Romana map cache"), true);
        return 1;
    }

    private static int regenerateMaps(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerMapCache.processAllDirtyNetworks();
        source.method_9226(() -> class_2561.method_43470((String)"Triggered regeneration for dirty Via Romana maps"), true);
        return 1;
    }

    private static int saveMaps(CommandContext<class_2168> context) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        ServerMapCache.saveAllToDisk(true);
        source.method_9226(() -> class_2561.method_43470((String)"Saved Via Romana maps to disk"), true);
        return 1;
    }
}

