/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3568;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_638;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.client.ColorUtil;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.client.render.NodeConnectionRenderer;
import net.rasanovum.viaromana.client.render.RenderUtil;
import net.rasanovum.viaromana.items.ChartingMap;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.path.PathGraph;
import net.rasanovum.viaromana.variables.VariableAccess;

public class NodeRenderer {
    private static final float BEAM_HEIGHT = 2.0f;
    private static final float BEAM_WIDTH = 0.6f;
    private static final float BEAM_FADE_FRACTION = 0.5f;
    private static final int BEAM_SEGMENTS = 10;
    private static final float RENDER_DISTANCE = 16.0f;
    private static final float FADE_BUFFER_DISTANCE = 4.0f;
    private static final float NEAR_FADE_START_DISTANCE = 1.0f;
    private static final float NEAR_FADE_END_DISTANCE = 0.5f;
    private static final float VIGNETTE_MAX_INTENSITY = 0.3f;
    private static final int MAX_LIGHT_BRIGHTNESS = 8;
    private static final float BEAM_ALPHA = 0.75f;
    private static final float PULSE_FREQUENCY = 1.0f;
    private static final float PULSE_MIN_ALPHA = 0.1f;
    private static final float PULSE_MAX_ALPHA = 1.0f;
    private static final float CROSS_ANGLE_RADIANS = (float)Math.toRadians(80.0);
    private static final float CROSS_COS = (float)Math.cos(CROSS_ANGLE_RADIANS);
    private static final float CROSS_SIN = (float)Math.sin(CROSS_ANGLE_RADIANS);
    private static final int DEFAULT_BEAM_COLOR = ColorUtil.rgbToHex(255.0f, 255.0f, 255.0f);
    private static final int CHARTING_BEAM_COLOR = ColorUtil.rgbToHex(0.0f, 255.0f, 0.0f);
    private static final class_2960 BEAM_TEXTURE = class_2960.method_60654((String)"via_romana:textures/effect/node_beam.png");
    private static final int SOUND_INTERVAL_TICKS = 40;
    private static final float ANIMATION_SPEED_SEC = -1.0f;
    private static final Map<class_2338, Long> nodeSoundTimes = new ConcurrentHashMap<class_2338, Long>();
    private static final Map<class_2338, Integer> dynamicLightSources = new ConcurrentHashMap<class_2338, Integer>();
    private static final float GLOBAL_FADE_SPEED = 0.05f;
    private static final float SELECTION_FADE_SPEED = 0.1f;
    private static float globalRenderAlpha = 0.0f;
    private static final Map<class_2338, Float> animatedNodeAlphas = new ConcurrentHashMap<class_2338, Float>();
    private static float currentVignetteIntensity = 0.0f;
    private static long lastRenderTime = 0L;
    private static float animationTime = 0.0f;

    private static int getPulseDistance() {
        return CommonConfig.node_utility_distance;
    }

    private static class_1921 getRenderType() {
        boolean shadersInUse = false;
        try {
            Class<?> irisApiClass = Class.forName("net.irisshaders.iris.api.v0.IrisApi");
            Object instance = irisApiClass.getMethod("getInstance", new Class[0]).invoke(null, new Object[0]);
            shadersInUse = (Boolean)irisApiClass.getMethod("isShaderPackInUse", new Class[0]).invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            shadersInUse = false;
        }
        return shadersInUse ? class_1921.method_42599((class_2960)BEAM_TEXTURE, (boolean)true) : class_1921.method_23592((class_2960)BEAM_TEXTURE, (boolean)true);
    }

    public static int getLightLevel(class_2338 pos) {
        return dynamicLightSources.getOrDefault(pos, 0);
    }

    public static float getCurrentVignetteIntensity() {
        return currentVignetteIntensity * globalRenderAlpha;
    }

    public static float getBeamHeight() {
        return 2.0f;
    }

    public static float calculateDistanceAlpha(double distance, float baseAlpha) {
        return (float)NodeRenderer.calculateValueWithFade(distance, baseAlpha);
    }

    public static int calculateDistanceLightBrightness(double distance) {
        return (int)Math.round(NodeRenderer.calculateValueWithFade(distance, 8.0));
    }

    public static double calculateDistanceToNodeBeam(class_243 playerPos, class_2338 nodePos, class_638 level) {
        double adjustedY = RenderUtil.findSuitableYPosition(level, nodePos, 0.25f);
        return NodeRenderer.calculateDistanceToNodeBeamInternal(playerPos, nodePos, adjustedY);
    }

    public static void renderNodeBeams(class_4587 poseStack, class_1937 level, class_1657 player, float partialTicks) {
        if (!(level instanceof class_638)) {
            return;
        }
        class_638 clientLevel = (class_638)level;
        NodeRenderer.updateAnimationTimer();
        boolean shouldRender = VariableAccess.playerVariables.isChartingPath((class_1297)player) || player.method_6047().method_7909() instanceof ChartingMap || player.method_6079().method_7909() instanceof ChartingMap;
        NodeRenderer.updateGlobalAlpha(shouldRender);
        if (globalRenderAlpha <= 0.0f) {
            NodeRenderer.clearAllLightSources(clientLevel);
            animatedNodeAlphas.clear();
            currentVignetteIntensity = 0.0f;
            return;
        }
        class_243 cameraPos = class_310.method_1551().field_1773.method_19418().method_19326();
        class_243 playerPos = player.method_19538();
        List<NodeRenderData> nodeDataList = NodeRenderer.gatherRenderData(clientLevel, playerPos);
        class_2338 selectedNodePos = NodeRenderer.findAndSetSelectedNode(player, nodeDataList);
        NodeRenderer.updateAnimatedAlphas(selectedNodePos);
        currentVignetteIntensity = NodeRenderer.calculateMaxVignette(nodeDataList);
        if (nodeDataList.isEmpty()) {
            NodeRenderer.updateLightSources(clientLevel, Collections.emptyList());
            return;
        }
        nodeDataList.sort(Comparator.comparingDouble(NodeRenderData::distance).reversed());
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_4588 beamConsumer = bufferSource.getBuffer(NodeRenderer.getRenderType());
        float vOffset = animationTime * -1.0f;
        for (NodeRenderData data : nodeDataList) {
            NodeRenderer.renderBeam(poseStack, beamConsumer, data, vOffset);
            NodeRenderer.playNodeSoundAtPosition(clientLevel, data.pos, data.adjustedY, level.method_8510());
        }
        bufferSource.method_22994(NodeRenderer.getRenderType());
        PathGraph graph = ClientPathData.getInstance().getGraph();
        if (graph != null && !graph.nodesView().isEmpty()) {
            NodeConnectionRenderer.renderConnections(poseStack, clientLevel, player, graph, animationTime, (class_4597)bufferSource, globalRenderAlpha);
        }
        poseStack.method_22909();
        bufferSource.method_22993();
        NodeRenderer.updateLightSources(clientLevel, nodeDataList);
    }

    private static void updateAnimationTimer() {
        if (lastRenderTime == 0L) {
            lastRenderTime = System.nanoTime();
            return;
        }
        long currentTime = System.nanoTime();
        float deltaTime = (float)(currentTime - lastRenderTime) / 1.0E9f;
        lastRenderTime = currentTime;
        animationTime += deltaTime;
    }

    private static List<NodeRenderData> gatherRenderData(class_638 level, class_243 playerPos) {
        PathGraph graph;
        ArrayList<NodeRenderData> dataList = new ArrayList<NodeRenderData>();
        double searchRadius = 20.0;
        if (VariableAccess.playerVariables.isChartingPath((class_1297)class_310.method_1551().field_1724)) {
            ClientPathData.getInstance().getTemporaryNodes().stream().map(nodeData -> {
                double adjY = RenderUtil.findSuitableYPosition(level, nodeData.pos(), 0.25f);
                double dist = NodeRenderer.calculateDistanceToNodeBeamInternal(playerPos, nodeData.pos(), adjY);
                return new NodeRenderData(nodeData.pos(), dist, adjY, CHARTING_BEAM_COLOR);
            }).filter(data -> data.distance <= searchRadius).forEach(dataList::add);
        }
        if ((graph = ClientPathData.getInstance().getGraph()) != null) {
            ClientPathData.getInstance().getNearbyNodes(class_2338.method_49638((class_2374)playerPos), searchRadius, false).stream().map(node -> {
                class_2338 pos = class_2338.method_10092((long)node.getPos());
                double adjY = RenderUtil.findSuitableYPosition(level, pos, 0.25f);
                double dist = NodeRenderer.calculateDistanceToNodeBeamInternal(playerPos, pos, adjY);
                return new NodeRenderData(pos, dist, adjY, DEFAULT_BEAM_COLOR);
            }).filter(data -> data.distance <= searchRadius).forEach(dataList::add);
        }
        return dataList;
    }

    private static class_2338 findAndSetSelectedNode(class_1657 player, List<NodeRenderData> nodeDataList) {
        ClientPathData clientPathData = ClientPathData.getInstance();
        Node nodeOpt = clientPathData.getNearestNode(player.method_24515(), NodeRenderer.getPulseDistance(), false).orElse(null);
        return nodeOpt != null ? nodeOpt.getBlockPos() : null;
    }

    private static void renderBeam(class_4587 poseStack, class_4588 consumer, NodeRenderData data, float vOffset) {
        float baseAlpha = animatedNodeAlphas.getOrDefault(data.pos(), Float.valueOf(0.75f)).floatValue();
        float distanceAlpha = NodeRenderer.calculateDistanceAlpha(data.distance(), baseAlpha);
        float finalAlpha = distanceAlpha * globalRenderAlpha;
        if (finalAlpha <= 0.01f) {
            return;
        }
        float r = (float)(data.color() >> 16 & 0xFF) / 255.0f;
        float g = (float)(data.color() >> 8 & 0xFF) / 255.0f;
        float b = (float)(data.color() & 0xFF) / 255.0f;
        poseStack.method_22903();
        poseStack.method_22904((double)data.pos().method_10263() + 0.5, data.adjustedY(), (double)data.pos().method_10260() + 0.5);
        NodeRenderer.renderBeamGeometry(poseStack, consumer, r, g, b, finalAlpha, vOffset);
        poseStack.method_22909();
    }

    private static void updateAnimatedAlphas(class_2338 selectedNodePos) {
        HashSet<class_2338> nodesToAnimate = new HashSet<class_2338>(animatedNodeAlphas.keySet());
        if (selectedNodePos != null) {
            nodesToAnimate.add(selectedNodePos);
        }
        for (class_2338 pos : nodesToAnimate) {
            float targetAlpha;
            boolean isSelected = pos.equals((Object)selectedNodePos);
            float currentAlpha = animatedNodeAlphas.getOrDefault(pos, Float.valueOf(0.75f)).floatValue();
            if (isSelected) {
                float pulseValue = (float)(Math.sin((double)(animationTime * 1.0f * 2.0f) * Math.PI) * 0.5 + 0.5);
                targetAlpha = class_3532.method_16439((float)pulseValue, (float)0.1f, (float)1.0f);
            } else {
                targetAlpha = 0.75f;
            }
            float newAlpha = class_3532.method_16439((float)0.1f, (float)currentAlpha, (float)targetAlpha);
            if (!isSelected && Math.abs(newAlpha - 0.75f) < 0.01f) {
                animatedNodeAlphas.remove(pos);
                continue;
            }
            animatedNodeAlphas.put(pos, Float.valueOf(newAlpha));
        }
    }

    private static void updateGlobalAlpha(boolean shouldRender) {
        float targetAlpha = shouldRender ? 1.0f : 0.0f;
        if (Math.abs((globalRenderAlpha = class_3532.method_16439((float)0.05f, (float)globalRenderAlpha, (float)targetAlpha)) - targetAlpha) < 0.005f) {
            globalRenderAlpha = targetAlpha;
        }
    }

    private static float calculateMaxVignette(List<NodeRenderData> nodeDataList) {
        return nodeDataList.stream().filter(data -> data.color() != CHARTING_BEAM_COLOR).map(data -> Float.valueOf(NodeRenderer.calculateVignetteForDistance(data.distance()))).max(Float::compare).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private static void updateLightSources(class_638 level, List<NodeRenderData> visibleNodes) {
        class_3568 lightEngine = level.method_22336();
        HashSet<class_2338> currentLightPositions = new HashSet<class_2338>();
        for (NodeRenderData data : visibleNodes) {
            int lightLevel = (int)((float)NodeRenderer.calculateDistanceLightBrightness(data.distance()) * globalRenderAlpha);
            if (lightLevel <= 0) continue;
            class_2338 lightPos = class_2338.method_49637((double)data.pos().method_10263(), (double)(data.adjustedY() + 1.0), (double)data.pos().method_10260());
            currentLightPositions.add(lightPos);
            if (dynamicLightSources.getOrDefault(lightPos, 0) == lightLevel) continue;
            dynamicLightSources.put(lightPos, lightLevel);
            lightEngine.method_15513(lightPos);
        }
        dynamicLightSources.keySet().removeIf(pos -> {
            if (!currentLightPositions.contains(pos)) {
                lightEngine.method_15513(pos);
                return true;
            }
            return false;
        });
    }

    private static void renderBeamGeometry(class_4587 poseStack, class_4588 consumer, float r, float g, float b, float a, float vOffset) {
        float halfWidth;
        class_4587.class_4665 pose = poseStack.method_23760();
        float x1 = halfWidth = 0.3f;
        float z1 = 0.0f;
        float x2 = halfWidth * CROSS_COS;
        float z2 = halfWidth * CROSS_SIN;
        float vMin = vOffset;
        float vMax = vMin + 1.0f;
        int overlay = 655360;
        int light = 0xF000F0;
        int rgb = (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        for (int i = 0; i < 10; ++i) {
            float t0 = (float)i / 10.0f;
            float t1 = (float)(i + 1) / 10.0f;
            float y0 = t0 * 2.0f;
            float y1 = t1 * 2.0f;
            float a0 = a * NodeRenderer.fadeEnds(t0);
            float a1 = a * NodeRenderer.fadeEnds(t1);
            float vt0 = class_3532.method_16439((float)t0, (float)vMin, (float)vMax);
            float vt1 = class_3532.method_16439((float)t1, (float)vMin, (float)vMax);
            int color0 = (int)(a0 * 255.0f) << 24 | rgb;
            int color1 = (int)(a1 * 255.0f) << 24 | rgb;
            NodeRenderer.renderSegment(pose, consumer, -x1, y0, -z1, x1, y1, z1, color0, color1, vt0, vt1, overlay, light);
            NodeRenderer.renderSegment(pose, consumer, -x2, y0, -z2, x2, y1, z2, color0, color1, vt0, vt1, overlay, light);
        }
    }

    private static void renderSegment(class_4587.class_4665 pose, class_4588 consumer, float x1, float y0, float z1, float x2, float y1, float z2, int color0, int color1, float v0, float v1, int overlay, int light) {
        consumer.method_56824(pose, x1, y0, z1).method_39415(color0).method_22913(0.0f, v0).method_22922(overlay).method_60803(light).method_22914(1.0f, 0.0f, 0.0f);
        consumer.method_56824(pose, x2, y0, z2).method_39415(color0).method_22913(1.0f, v0).method_22922(overlay).method_60803(light).method_22914(1.0f, 0.0f, 0.0f);
        consumer.method_56824(pose, x2, y1, z2).method_39415(color1).method_22913(1.0f, v1).method_22922(overlay).method_60803(light).method_22914(1.0f, 0.0f, 0.0f);
        consumer.method_56824(pose, x1, y1, z1).method_39415(color1).method_22913(0.0f, v1).method_22922(overlay).method_60803(light).method_22914(1.0f, 0.0f, 0.0f);
        consumer.method_56824(pose, x2, y0, z2).method_39415(color0).method_22913(0.0f, v0).method_22922(overlay).method_60803(light).method_22914(-1.0f, 0.0f, 0.0f);
        consumer.method_56824(pose, x1, y0, z1).method_39415(color0).method_22913(1.0f, v0).method_22922(overlay).method_60803(light).method_22914(-1.0f, 0.0f, 0.0f);
        consumer.method_56824(pose, x1, y1, z1).method_39415(color1).method_22913(1.0f, v1).method_22922(overlay).method_60803(light).method_22914(-1.0f, 0.0f, 0.0f);
        consumer.method_56824(pose, x2, y1, z2).method_39415(color1).method_22913(0.0f, v1).method_22922(overlay).method_60803(light).method_22914(-1.0f, 0.0f, 0.0f);
    }

    private static double calculateValueWithFade(double distance, double maxValue) {
        if (distance < 0.5) {
            return 0.0;
        }
        if (distance < 1.0) {
            return maxValue * ((distance - 0.5) / 0.5);
        }
        if (distance > 16.0) {
            return maxValue * (1.0 - class_3532.method_15350((double)((distance - 16.0) / 4.0), (double)0.0, (double)1.0));
        }
        return maxValue;
    }

    private static float calculateVignetteForDistance(double distance) {
        if (distance >= 1.0) {
            return 0.0f;
        }
        if (distance <= 0.5) {
            return 0.3f;
        }
        return 0.3f * (1.0f - (float)((distance - 0.5) / 0.5));
    }

    private static double calculateDistanceToNodeBeamInternal(class_243 playerPos, class_2338 nodePos, double adjustedY) {
        double clampedY = class_3532.method_15350((double)playerPos.field_1351, (double)adjustedY, (double)(adjustedY + 2.0));
        return playerPos.method_1022(new class_243((double)nodePos.method_10263() + 0.5, clampedY, (double)nodePos.method_10260() + 0.5));
    }

    private static float fadeEnds(float t) {
        return class_3532.method_15363((float)(Math.min(t, 1.0f - t) / 0.5f), (float)0.0f, (float)1.0f);
    }

    private static void playNodeSoundAtPosition(class_638 level, class_2338 pos, double adjustedY, long currentTime) {
        if (nodeSoundTimes.getOrDefault(pos, 0L) > currentTime - 40L) {
            return;
        }
        nodeSoundTimes.put(pos, currentTime);
        level.method_8486((double)pos.method_10263() + 0.5, adjustedY + 1.0, (double)pos.method_10260() + 0.5, class_3417.field_15045, class_3419.field_15256, 0.3f * globalRenderAlpha, 1.0f, false);
    }

    private static void clearAllLightSources(class_638 level) {
        if (!dynamicLightSources.isEmpty()) {
            class_3568 lightEngine = level.method_22336();
            dynamicLightSources.keySet().forEach(arg_0 -> ((class_3568)lightEngine).method_15513(arg_0));
            dynamicLightSources.clear();
        }
    }

    private record NodeRenderData(class_2338 pos, double distance, double adjustedY, int color) {
    }
}

