/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4264;
import net.minecraft.class_6382;
import net.minecraft.class_7919;

public class MapCycleButton<T>
extends class_4264 {
    private final List<T> values;
    private final Consumer<T> onValueChange;
    private final Function<T, class_2561> displayFunction;
    private final class_327 font;
    private final class_2561 tooltip;
    private int selectedIndex = 0;
    private boolean isSelected = false;
    private Runnable customOnPress = null;

    public MapCycleButton(class_327 font, int x, int y, int width, int height, List<T> values, T initialValue, Function<T, class_2561> displayFunction, Consumer<T> onValueChange) {
        this(font, x, y, width, height, values, initialValue, displayFunction, onValueChange, null);
    }

    public MapCycleButton(class_327 font, int x, int y, int width, int height, List<T> values, T initialValue, Function<T, class_2561> displayFunction, Consumer<T> onValueChange, class_2561 tooltip) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.font = font;
        this.values = values;
        this.displayFunction = displayFunction;
        this.onValueChange = onValueChange;
        this.tooltip = tooltip;
        if (this.tooltip != null && !this.tooltip.getString().isEmpty()) {
            this.method_47400(class_7919.method_47407((class_2561)tooltip));
        }
        for (int i = 0; i < values.size(); ++i) {
            if (!values.get(i).equals(initialValue)) continue;
            this.selectedIndex = i;
            break;
        }
    }

    public void method_25306() {
        if (this.customOnPress != null) {
            this.customOnPress.run();
        } else {
            this.selectedIndex = (this.selectedIndex + 1) % this.values.size();
            T newValue = this.values.get(this.selectedIndex);
            if (this.onValueChange != null) {
                this.onValueChange.accept(newValue);
            }
        }
    }

    public void setOnPress(Runnable onPress) {
        this.customOnPress = onPress;
    }

    public T getValue() {
        return this.values.get(this.selectedIndex);
    }

    public void setValue(T value) {
        for (int i = 0; i < this.values.size(); ++i) {
            if (!this.values.get(i).equals(value)) continue;
            this.selectedIndex = i;
            break;
        }
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (!this.field_22764) {
            return;
        }
        int currentTextColor = 4139547;
        int checkboxSize = 8;
        int checkboxX = this.method_46426() + 6;
        int checkboxY = this.method_46427() - 1 + (this.field_22759 - checkboxSize) / 2;
        guiGraphics.method_25294(checkboxX, checkboxY, checkboxX + checkboxSize, checkboxY + 1, -12637669);
        guiGraphics.method_25294(checkboxX, checkboxY + checkboxSize - 1, checkboxX + checkboxSize, checkboxY + checkboxSize, -12637669);
        guiGraphics.method_25294(checkboxX, checkboxY, checkboxX + 1, checkboxY + checkboxSize, -12637669);
        guiGraphics.method_25294(checkboxX + checkboxSize - 1, checkboxY, checkboxX + checkboxSize, checkboxY + checkboxSize, -12637669);
        if (this.isSelected || this.method_49606()) {
            int iconSize = 16;
            int iconX = checkboxX - 3;
            int iconY = checkboxY - 6;
            if (this.isSelected) {
                guiGraphics.method_25290(class_2960.method_60654((String)"via_romana:textures/screens/element_check.png"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
            } else {
                guiGraphics.method_51448().method_22903();
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.3f);
                guiGraphics.method_25290(class_2960.method_60654((String)"via_romana:textures/screens/element_check.png"), iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
                guiGraphics.method_51448().method_22909();
            }
        }
        class_2561 displayText = this.displayFunction.apply(this.getValue());
        String text = displayText.getString();
        int textX = checkboxX + checkboxSize + 6;
        int n = this.method_46427();
        Objects.requireNonNull(this.font);
        int textY = n + (this.field_22759 - 9) / 2;
        guiGraphics.method_51433(this.font, text, textX, textY, currentTextColor, false);
    }

    protected void method_47399(class_6382 narrationElementOutput) {
        this.method_37021(narrationElementOutput);
    }
}

