/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.gui;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_332;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.MapClient;
import net.rasanovum.viaromana.client.gui.MapCoordinateSystem;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;

public class MapRenderer
implements AutoCloseable {
    private static final int SCREEN_MARGIN = 40;
    private static final int BACKGROUND_TILE_SIZE = 32;
    private static final float MIN_VISIBLE_TILE_FRACTION = 0.4f;
    private static final int EDGE_GRADIENT_DISTANCE_SCREEN = 14;
    private static final float GRADIENT_RANDOMNESS = 0.3f;
    private static final float MAP_OPACITY = 0.75f;
    private static final class_2960[] CORNER_TILES = MapRenderer.createTileLocations("corner-", 4);
    private static final class_2960[] EDGE_TILES = MapRenderer.createTileLocations("edge-", 24);
    private static final class_2960[] CENTER_TILES = MapRenderer.createTileLocations("center-", 4);
    private static final Map<class_2960, class_1011> tileImageCache = new ConcurrentHashMap<class_2960, class_1011>();
    private final class_2338 requestedMinBounds;
    private final class_2338 requestedMaxBounds;
    private final long tileSeed;
    private MapClient.MapTexture mapTexture;
    private class_1043 bakedDynamicTexture;
    private class_2960 bakedTextureLocation;
    private MapCoordinateSystem coordinateSystem;
    private float lastRenderScale = -1.0f;
    private int bakedTextureWidth;
    private int bakedTextureHeight;

    public MapRenderer(class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        this.requestedMinBounds = minBounds;
        this.requestedMaxBounds = maxBounds;
        this.tileSeed = (long)this.requestedMinBounds.hashCode() * 31L + (long)this.requestedMaxBounds.hashCode();
    }

    private static class_2960[] createTileLocations(String prefix, int count) {
        class_2960[] locations = new class_2960[count];
        for (int i = 0; i < count; ++i) {
            locations[i] = class_2960.method_60654((String)("via_romana:textures/screens/background_tile/" + prefix + (i + 1) + ".png"));
        }
        return locations;
    }

    public void setMapTexture(MapClient.MapTexture mapTexture) {
        this.mapTexture = mapTexture;
    }

    public void render(class_332 guiGraphics, int screenWidth, int screenHeight, class_1657 player) {
        if (this.mapTexture == null) {
            return;
        }
        int availableWidth = screenWidth - 40;
        int availableHeight = screenHeight - 40;
        float scale = Math.min((float)availableWidth / (float)this.mapTexture.nativeImage.method_4307(), (float)availableHeight / (float)this.mapTexture.nativeImage.method_4323());
        if (this.bakedDynamicTexture == null || Math.abs(scale - this.lastRenderScale) > 0.1f) {
            this.rebuildBakedTexture(scale);
        }
        if (this.bakedDynamicTexture == null || this.coordinateSystem == null) {
            return;
        }
        MapCoordinateSystem.MapRenderInfo renderInfo = this.coordinateSystem.updateAndGetRenderInfo(availableWidth + 40, availableHeight + 40);
        guiGraphics.method_25293(this.bakedTextureLocation, renderInfo.x, renderInfo.y, renderInfo.width, renderInfo.height, 0.0f, 0.0f, this.bakedTextureWidth, this.bakedTextureHeight, this.bakedTextureWidth, this.bakedTextureHeight);
    }

    private void rebuildBakedTexture(float scale) {
        this.lastRenderScale = scale;
        if (this.bakedDynamicTexture != null) {
            this.bakedDynamicTexture.close();
        }
        try (class_1011 newBakedImage = this.bakeBackgroundAndMap(this.mapTexture.nativeImage, scale);){
            this.bakedTextureWidth = newBakedImage.method_4307();
            this.bakedTextureHeight = newBakedImage.method_4323();
            this.bakedDynamicTexture = new class_1043(newBakedImage);
            this.bakedTextureLocation = class_310.method_1551().method_1531().method_4617("baked_map", this.bakedDynamicTexture);
        }
        class_2338 imageMin = this.mapTexture.mapInfo.minBounds();
        class_2338 imageMax = this.mapTexture.mapInfo.maxBounds();
        this.coordinateSystem = new MapCoordinateSystem(imageMin, imageMax, this.mapTexture.nativeImage.method_4307(), this.mapTexture.nativeImage.method_4323(), this.bakedTextureWidth, this.bakedTextureHeight, this.mapTexture.mapInfo.bakeScaleFactor());
    }

    private class_1011 bakeBackgroundAndMap(class_1011 mapImage, float renderScale) {
        ViaRomana.LOGGER.debug("Baking new texture with render scale: {}", (Object)Float.valueOf(renderScale));
        int mapWidthPx = mapImage.method_4307();
        int mapHeightPx = mapImage.method_4323();
        int tileSize = 32;
        int requiredWidth = mapWidthPx + (int)Math.ceil(0.8f * (float)tileSize);
        int requiredHeight = mapHeightPx + (int)Math.ceil(0.8f * (float)tileSize);
        int tilesWide = Math.max(3, (requiredWidth + tileSize - 1) / tileSize);
        int tilesHigh = Math.max(3, (requiredHeight + tileSize - 1) / tileSize);
        class_1011 combined = this.createTiledBackground(tilesWide, tilesHigh, tileSize);
        try (class_1011 gradientMap = this.applyEdgeGradient(mapImage, renderScale);){
            int mapX = (combined.method_4307() - mapWidthPx) / 2;
            int mapY = (combined.method_4323() - mapHeightPx) / 2;
            this.blendImage(combined, gradientMap, mapX, mapY);
        }
        return combined;
    }

    private class_1011 createTiledBackground(int tilesWide, int tilesHigh, int tileSize) {
        int bakedWidth = tilesWide * tileSize;
        int bakedHeight = tilesHigh * tileSize;
        class_1011 background = new class_1011(class_1011.class_1012.field_4997, bakedWidth, bakedHeight, true);
        for (int tileY = 0; tileY < tilesHigh; ++tileY) {
            for (int tileX = 0; tileX < tilesWide; ++tileX) {
                TileInfo tileInfo = this.getTileInfo(tileX, tileY, tilesWide, tilesHigh);
                class_1011 source = this.getCachedTileImage(tileInfo.texture());
                if (source == null) continue;
                class_1011 rotated = this.rotateImage(source, tileInfo.rotation());
                this.blitScaled(background, rotated, tileX * tileSize, tileY * tileSize, tileSize, tileSize);
                if (rotated == source) continue;
                rotated.close();
            }
        }
        return background;
    }

    private void blendImage(class_1011 background, class_1011 foreground, int startX, int startY) {
        for (int px = 0; px < foreground.method_4307(); ++px) {
            for (int py = 0; py < foreground.method_4323(); ++py) {
                int targetX = startX + px;
                int targetY = startY + py;
                if (targetX < 0 || targetX >= background.method_4307() || targetY < 0 || targetY >= background.method_4323()) continue;
                int bgPixel = background.method_4315(targetX, targetY);
                int fgPixelRaw = foreground.method_4315(px, py);
                int fgAlpha = (int)((float)(fgPixelRaw >>> 24 & 0xFF) * 0.75f);
                int fgPixel = fgAlpha << 24 | fgPixelRaw & 0xFFFFFF;
                background.method_4305(targetX, targetY, this.blendOver(bgPixel, fgPixel));
            }
        }
    }

    private class_1011 applyEdgeGradient(class_1011 mapImage, float renderScale) {
        int x;
        int y;
        int width = mapImage.method_4307();
        int height = mapImage.method_4323();
        int gradientDist = Math.max(1, (int)Math.ceil(14.0f / renderScale));
        float[][] distanceMap = new float[width][height];
        float maxDist = (float)width + (float)height;
        for (y = 0; y < height; ++y) {
            for (x = 0; x < width; ++x) {
                boolean isTransparent = (mapImage.method_4315(x, y) >>> 24 & 0xFF) < 10;
                boolean isBorderPixel = x == 0 || y == 0 || x == width - 1 || y == height - 1;
                distanceMap[x][y] = isTransparent || isBorderPixel ? 0.0f : maxDist;
            }
        }
        for (y = 1; y < height; ++y) {
            for (x = 1; x < width; ++x) {
                float minNeighbor = Math.min(distanceMap[x - 1][y], distanceMap[x][y - 1]);
                distanceMap[x][y] = Math.min(distanceMap[x][y], minNeighbor + 1.0f);
            }
        }
        for (y = height - 2; y >= 0; --y) {
            for (x = width - 2; x >= 0; --x) {
                float minNeighbor = Math.min(distanceMap[x + 1][y], distanceMap[x][y + 1]);
                distanceMap[x][y] = Math.min(distanceMap[x][y], minNeighbor + 1.0f);
            }
        }
        class_1011 result = new class_1011(mapImage.method_4318(), width, height, false);
        result.method_4317(mapImage);
        Random gradientRandom = new Random(this.tileSeed);
        for (int y2 = 0; y2 < height; ++y2) {
            for (int x2 = 0; x2 < width; ++x2) {
                float distance = distanceMap[x2][y2];
                if (!(distance < (float)gradientDist)) continue;
                float randomFactor = 1.0f + (gradientRandom.nextFloat() - 0.5f) * 0.3f;
                float gradient = Math.min(1.0f, distance * randomFactor / (float)gradientDist);
                gradient = gradient * gradient * (3.0f - 2.0f * gradient);
                int pixel = result.method_4315(x2, y2);
                int newAlpha = (int)((float)(pixel >>> 24 & 0xFF) * gradient);
                result.method_4305(x2, y2, newAlpha << 24 | pixel & 0xFFFFFF);
            }
        }
        return result;
    }

    private TileInfo getTileInfo(int tileX, int tileY, int tilesWide, int tilesHigh) {
        boolean isRight;
        Random tileRandom = new Random(this.tileSeed + (long)tileY * (long)tilesWide + (long)tileX);
        boolean isTop = tileY == 0;
        boolean isBottom = tileY == tilesHigh - 1;
        boolean isLeft = tileX == 0;
        boolean bl = isRight = tileX == tilesWide - 1;
        if (isTop && isLeft) {
            return new TileInfo(CORNER_TILES[0], 0);
        }
        if (isTop && isRight) {
            return new TileInfo(CORNER_TILES[1], 0);
        }
        if (isBottom && isLeft) {
            return new TileInfo(CORNER_TILES[2], 0);
        }
        if (isBottom && isRight) {
            return new TileInfo(CORNER_TILES[3], 0);
        }
        class_2960 edgeTexture = EDGE_TILES[tileRandom.nextInt(EDGE_TILES.length)];
        if (isTop) {
            return new TileInfo(edgeTexture, 0);
        }
        if (isRight) {
            return new TileInfo(edgeTexture, 90);
        }
        if (isBottom) {
            return new TileInfo(edgeTexture, 180);
        }
        if (isLeft) {
            return new TileInfo(edgeTexture, 270);
        }
        return new TileInfo(CENTER_TILES[tileRandom.nextInt(CENTER_TILES.length)], 0);
    }

    private class_1011 getCachedTileImage(class_2960 location) {
        return tileImageCache.computeIfAbsent(location, loc -> {
            block8: {
                class_1011 class_10112;
                block9: {
                    Optional resourceOpt = class_310.method_1551().method_1478().method_14486(loc);
                    if (!resourceOpt.isPresent()) break block8;
                    InputStream inputStream = ((class_3298)resourceOpt.get()).method_14482();
                    try {
                        class_10112 = class_1011.method_4309((InputStream)inputStream);
                        if (inputStream == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            ViaRomana.LOGGER.error("Failed to load background tile texture: {}", loc, (Object)e);
                        }
                    }
                    inputStream.close();
                }
                return class_10112;
            }
            return null;
        });
    }

    private class_1011 rotateImage(class_1011 src, int degrees) {
        if (degrees == 0) {
            return src;
        }
        int sw = src.method_4307();
        int sh = src.method_4323();
        int dw = degrees == 90 || degrees == 270 ? sh : sw;
        int dh = degrees == 90 || degrees == 270 ? sw : sh;
        class_1011 dest = new class_1011(src.method_4318(), dw, dh, false);
        for (int sx = 0; sx < sw; ++sx) {
            block6: for (int sy = 0; sy < sh; ++sy) {
                int dy;
                int dx;
                switch (degrees) {
                    case 90: {
                        dx = sh - 1 - sy;
                        dy = sx;
                        break;
                    }
                    case 180: {
                        dx = sw - 1 - sx;
                        dy = sh - 1 - sy;
                        break;
                    }
                    case 270: {
                        dx = sy;
                        dy = sw - 1 - sx;
                        break;
                    }
                    default: {
                        continue block6;
                    }
                }
                dest.method_4305(dx, dy, src.method_4315(sx, sy));
            }
        }
        return dest;
    }

    private void blitScaled(class_1011 target, class_1011 src, int tx, int ty, int tw, int th) {
        for (int dy = 0; dy < th; ++dy) {
            for (int dx = 0; dx < tw; ++dx) {
                int sx = (int)((float)dx * (float)src.method_4307() / (float)tw);
                int sy = (int)((float)dy * (float)src.method_4323() / (float)th);
                if (dx + tx >= target.method_4307() || dy + ty >= target.method_4323()) continue;
                target.method_4305(dx + tx, dy + ty, src.method_4315(sx, sy));
            }
        }
    }

    private int blendOver(int bg, int fg) {
        int fgA = fg >> 24 & 0xFF;
        if (fgA == 0) {
            return bg;
        }
        int bgA = bg >> 24 & 0xFF;
        int invA = 255 - fgA;
        int outR = ((fg >> 16 & 0xFF) * fgA + (bg >> 16 & 0xFF) * invA) / 255;
        int outG = ((fg >> 8 & 0xFF) * fgA + (bg >> 8 & 0xFF) * invA) / 255;
        int outB = ((fg & 0xFF) * fgA + (bg & 0xFF) * invA) / 255;
        int outA = fgA + bgA * invA / 255;
        return outA << 24 | outR << 16 | outG << 8 | outB;
    }

    @Override
    public void close() {
        if (this.bakedDynamicTexture != null) {
            this.bakedDynamicTexture.close();
            this.bakedDynamicTexture = null;
            this.bakedTextureLocation = null;
        }
    }

    public static void clearCache() {
        ViaRomana.LOGGER.info("Clearing MapRenderer tile image cache ({} entries)", (Object)tileImageCache.size());
        tileImageCache.values().forEach(class_1011::close);
        tileImageCache.clear();
    }

    public Point worldToScreen(class_2338 worldPos, int screenWidth, int screenHeight) {
        if (this.coordinateSystem == null) {
            return null;
        }
        int availableWidth = screenWidth - 40;
        int availableHeight = screenHeight - 40;
        this.coordinateSystem.updateAndGetRenderInfo(availableWidth + 40, availableHeight + 40);
        return this.coordinateSystem.worldToScreen(worldPos);
    }

    private record TileInfo(class_2960 texture, int rotation) {
    }

    public static class Holder {
        private MapRenderer current;
        private MapKey lastKey;

        public MapRenderer getOrCreate(class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
            MapKey currentKey = new MapKey(minBounds, maxBounds);
            if (this.current == null || !currentKey.equals(this.lastKey)) {
                if (this.current != null) {
                    this.current.close();
                }
                this.current = new MapRenderer(minBounds, maxBounds, networkNodes);
                this.lastKey = currentKey;
            }
            return this.current;
        }

        public void close() {
            if (this.current != null) {
                this.current.close();
                this.current = null;
            }
        }
    }

    private record MapKey(class_2338 min, class_2338 max) {
    }
}

