/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client.core;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.client.HudMessageManager;
import net.rasanovum.viaromana.client.data.ClientPathData;
import net.rasanovum.viaromana.core.LinkHandler;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;
import net.rasanovum.viaromana.network.packets.ChartedPathC2S;
import net.rasanovum.viaromana.network.packets.LinkSignRequestC2S;
import net.rasanovum.viaromana.path.Node;
import net.rasanovum.viaromana.util.PathUtils;
import net.rasanovum.viaromana.variables.VariableAccess;

public final class ChartingHandler {
    public static void chartPath(class_1936 level, class_1297 entity) {
        if (!VariableAccess.playerVariables.isChartingPath(entity)) {
            return;
        }
        float nodeDistance = PathUtils.calculateNodeDistance(entity);
        float infrastructureQuality = PathUtils.calculateInfrastructureQuality(level, entity);
        float clearance = PathUtils.calculateClearance(level, entity);
        if (nodeDistance > (float)CommonConfig.node_distance_maximum) {
            HudMessageManager.queueMessage("message.via_romana.too_far_from_node_message");
            return;
        }
        if (infrastructureQuality < CommonConfig.path_quality_threshold) {
            float threshold = CommonConfig.path_quality_threshold;
            int requiredBlocks = (int)Math.ceil((double)threshold * 9.0);
            int currentBlocks = Math.round(infrastructureQuality * 9.0f);
            HudMessageManager.queueMessage((class_2561)class_2561.method_43469((String)"gui.viaromana.infrastructure_insufficient", (Object[])new Object[]{currentBlocks, requiredBlocks}));
            return;
        }
        if (nodeDistance < (float)CommonConfig.node_distance_minimum) {
            HudMessageManager.queueMessage("message.via_romana.path_charting");
            return;
        }
        ChartingHandler.addChartingNode(level, entity, entity.method_24515(), Float.valueOf(infrastructureQuality), Float.valueOf(clearance));
    }

    private static void playCartographySound(class_1936 level, class_1297 entity) {
        if (!(level instanceof class_1937)) {
            return;
        }
        class_1937 lvl = (class_1937)level;
        class_2338 pos = class_2338.method_49637((double)entity.method_23317(), (double)entity.method_23318(), (double)entity.method_23321());
        class_3414 snd = (class_3414)class_7923.field_41172.method_10223(class_2960.method_60654((String)"minecraft:ui.cartography_table.take_result"));
        if (lvl.method_8608()) {
            lvl.method_8486(entity.method_23317(), entity.method_23318(), entity.method_23321(), snd, class_3419.field_15248, 1.0f, 1.0f, false);
        } else {
            lvl.method_8396(null, pos, snd, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public static void addChartingNode(class_1936 level, class_1297 entity, class_2338 pos, Float quality, Float clearance) {
        Optional<Node> nearbyNode;
        if (entity == null) {
            return;
        }
        if (Math.random() > 0.9) {
            ChartingHandler.playCartographySound(level, entity);
        }
        if ((nearbyNode = ClientPathData.getInstance().getNearestNode(pos, CommonConfig.node_utility_distance, 1.0, true)).isPresent()) {
            class_2338 nearbyPos;
            pos = nearbyPos = nearbyNode.get().getBlockPos();
            clearance = Float.valueOf(nearbyNode.get().getClearance());
        }
        VariableAccess.playerVariables.setLastNodePos(entity, pos);
        ClientPathData.getInstance().addTemporaryNode(pos, quality.floatValue(), clearance.floatValue());
    }

    public static void finishPath(class_746 player) {
        ClientPathData clientPathData = ClientPathData.getInstance();
        List<Node.NodeData> chartingNodes = clientPathData.getTemporaryNodes();
        List<LinkHandler.LinkData> chartingLinks = clientPathData.getTemporaryLinks();
        if (player == null || chartingNodes == null || chartingNodes.isEmpty()) {
            return;
        }
        ChartedPathC2S packet = new ChartedPathC2S(chartingNodes);
        if (ViaRomanaModVariables.networkHandler != null) {
            ViaRomanaModVariables.networkHandler.sendToServer(packet);
        } else {
            ViaRomana.LOGGER.error("Failed to send charted path - NetworkHandler not available");
        }
        if (chartingLinks != null && !chartingLinks.isEmpty()) {
            for (LinkHandler.LinkData link : chartingLinks) {
                LinkSignRequestC2S linkPacket = new LinkSignRequestC2S(link, false);
                if (ViaRomanaModVariables.networkHandler != null) {
                    ViaRomanaModVariables.networkHandler.sendToServer(linkPacket);
                    continue;
                }
                ViaRomana.LOGGER.error("Failed to send link packet - NetworkHandler not available");
            }
        }
        HudMessageManager.queueMessage("message.via_romana.finish_charting");
    }

    public static void initializeChartingNodes(class_746 player) {
        if (player != null) {
            ClientPathData.getInstance().clearTemporaryNodes();
        }
    }
}

