/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.rasanovum.viaromana.ViaRomana;
import net.rasanovum.viaromana.map.MapInfo;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;
import net.rasanovum.viaromana.network.packets.DestinationResponseS2C;
import net.rasanovum.viaromana.network.packets.MapRequestC2S;
import net.rasanovum.viaromana.network.packets.MapResponseS2C;

public class MapClient {
    private static CompletableFuture<MapInfo> pendingRequest = null;

    public static CompletableFuture<MapInfo> requestMap(UUID networkId, class_2338 minBounds, class_2338 maxBounds, List<DestinationResponseS2C.NodeNetworkInfo> networkNodes) {
        CompletableFuture<MapInfo> future = new CompletableFuture<MapInfo>();
        pendingRequest = future;
        if (ViaRomanaModVariables.networkHandler != null) {
            MapRequestC2S packet = MapRequestC2S.create(networkId, minBounds, maxBounds, networkNodes);
            ViaRomanaModVariables.networkHandler.sendToServer(packet);
        } else {
            future.complete(null);
        }
        return future;
    }

    public static void handleMapResponse(MapResponseS2C packet) {
        MapClient.handleMapInfo(packet.getMapInfo());
    }

    public static void handleMapInfo(MapInfo mapInfo) {
        if (pendingRequest != null) {
            pendingRequest.complete(mapInfo);
            pendingRequest = null;
        }
    }

    public static MapTexture createTexture(MapInfo mapInfo) {
        if (mapInfo == null || !mapInfo.hasImageData()) {
            return null;
        }
        try {
            class_1011 image = class_1011.method_4309((InputStream)new ByteArrayInputStream(mapInfo.pngData()));
            class_1043 texture = new class_1043(image);
            class_2960 location = class_310.method_1551().method_1531().method_4617("map_network_" + String.valueOf(mapInfo.networkId()), texture);
            ViaRomana.LOGGER.debug("Created GPU texture for network {} map", (Object)mapInfo.networkId());
            return new MapTexture(mapInfo, location, texture, image);
        }
        catch (IOException e) {
            ViaRomana.LOGGER.error("MapClient: Failed to create texture for network {}: {}", (Object)mapInfo.networkId(), (Object)e.getMessage());
            return null;
        }
    }

    public static class MapTexture
    implements AutoCloseable {
        public final MapInfo mapInfo;
        public final class_2960 textureLocation;
        public final class_1043 dynamicTexture;
        public final class_1011 nativeImage;

        public MapTexture(MapInfo mapInfo, class_2960 textureLocation, class_1043 dynamicTexture, class_1011 nativeImage) {
            this.mapInfo = mapInfo;
            this.textureLocation = textureLocation;
            this.dynamicTexture = dynamicTexture;
            this.nativeImage = nativeImage;
        }

        @Override
        public void close() {
            if (this.dynamicTexture != null) {
                this.dynamicTexture.close();
            }
        }
    }
}

