/*
 * Decompiled with CFR 0.152.
 */
package net.rasanovum.viaromana;

import com.mojang.brigadier.CommandDispatcher;
import eu.midnightdust.lib.config.MidnightConfig;
import folk.sisby.surveyor.WorldSummary;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2960;
import net.rasanovum.viaromana.CommonConfig;
import net.rasanovum.viaromana.command.ViaRomanaCommands;
import net.rasanovum.viaromana.core.DimensionHandler;
import net.rasanovum.viaromana.core.ResetVariables;
import net.rasanovum.viaromana.init.BlockInit;
import net.rasanovum.viaromana.init.EffectInit;
import net.rasanovum.viaromana.init.ItemInit;
import net.rasanovum.viaromana.init.TriggerInit;
import net.rasanovum.viaromana.map.ServerMapCache;
import net.rasanovum.viaromana.network.PacketTypeRegistry;
import net.rasanovum.viaromana.network.ViaRomanaModPacketHandler;
import net.rasanovum.viaromana.network.ViaRomanaModVariables;
import net.rasanovum.viaromana.surveyor.ViaRomanaLandmarkManager;
import net.rasanovum.viaromana.tags.TagGenerator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pers.solid.brrp.v1.api.RuntimeResourcePack;
import pers.solid.brrp.v1.fabric.api.RRPCallback;

public class ViaRomana
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "via_romana";
    public static final RuntimeResourcePack RUNTIME_PACK = RuntimeResourcePack.create(class_2960.method_60654((String)"via_romana:runtime_pack"));

    public void onInitialize() {
        LOGGER.info("Initializing ViaRomanaMod");
        MidnightConfig.init((String)MODID, CommonConfig.class);
        WorldSummary.enableTerrain();
        PacketTypeRegistry.register();
        BlockInit.load();
        EffectInit.load();
        ItemInit.load();
        TriggerInit.load();
        ViaRomanaModPacketHandler.initialize();
        ViaRomanaLandmarkManager.initialize();
        RRPCallback.BEFORE_VANILLA.register(resources -> {
            TagGenerator.generateAllTags(RUNTIME_PACK);
            resources.add(RUNTIME_PACK);
        });
        this.registerServerLifecycleEvents();
    }

    private void registerServerLifecycleEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            ViaRomanaModVariables.playerLoggedIn(handler.field_14140);
            ResetVariables.execute((class_1936)handler.field_14140.method_37908(), (class_1297)handler.field_14140);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> ViaRomanaModVariables.playerLoggedOut(handler.field_14140));
        ServerLifecycleEvents.SERVER_STARTING.register(ServerMapCache::init);
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            ServerMapCache.processAllDirtyNetworks();
            ServerMapCache.saveAllToDisk(true);
            ServerMapCache.clear();
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            boolean keepInventory = oldPlayer.method_37908().method_8450().method_8355(class_1928.field_19389);
            ViaRomanaModVariables.playerRespawned(oldPlayer, newPlayer, keepInventory || !alive);
        });
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            if (success) {
                try {
                    MidnightConfig.init((String)MODID, CommonConfig.class);
                    LOGGER.info("Via Romana config reloaded and synced to players.");
                }
                catch (Exception e) {
                    LOGGER.error("Failed to reload MidnightConfig", (Throwable)e);
                }
                ServerMapCache.shutdown();
                ServerMapCache.clear();
                ServerMapCache.init(server);
            }
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> DimensionHandler.preventHopping((class_1936)destination, (class_1297)player));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> ViaRomanaCommands.register((CommandDispatcher<class_2168>)dispatcher));
    }
}

