/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.world.item;

import fuzs.puzzleslib.api.core.v1.Proxy;
import fuzs.statuemenus.api.v1.helper.ArmorStandInteractHelper;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandPose;
import fuzs.strawstatues.init.ModRegistry;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class StrawStatueItem
extends Item {
    public StrawStatueItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext context) {
        Direction direction = context.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        BlockPlaceContext blockPlaceContext = new BlockPlaceContext(context);
        BlockPos blockPos = blockPlaceContext.getClickedPos();
        ItemStack itemStack = context.getItemInHand();
        Vec3 vec3 = Vec3.atBottomCenterOf((Vec3i)blockPos);
        AABB aABB = ((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value()).getDimensions().makeBoundingBox(vec3.x(), vec3.y(), vec3.z());
        if (level.noCollision(null, aABB) && level.getEntities(null, aABB).isEmpty()) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                Player player = context.getPlayer();
                Consumer consumer = EntityType.appendDefaultStackConfig(strawStatue -> {
                    strawStatue.setProfile((ResolvableProfile)itemStack.get(DataComponents.PROFILE));
                    if (itemStack.has(DataComponents.CUSTOM_NAME)) {
                        strawStatue.setCustomNameVisible(true);
                    }
                }, (ServerLevel)serverLevel, (ItemStack)itemStack, (Player)player);
                ArmorStand armorStand = (ArmorStand)((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value()).create(serverLevel, consumer, blockPos, MobSpawnType.SPAWN_EGG, true, true);
                if (armorStand == null) {
                    return InteractionResult.FAIL;
                }
                float yRot = (float)Mth.floor((float)((Mth.wrapDegrees((float)(context.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
                armorStand.moveTo(armorStand.getX(), armorStand.getY(), armorStand.getZ(), yRot, 0.0f);
                this.randomizePose(armorStand, level.random);
                serverLevel.addFreshEntityWithPassengers((Entity)armorStand);
                level.playSound(null, armorStand.getX(), armorStand.getY(), armorStand.getZ(), SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 0.75f, 0.8f);
                armorStand.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)player);
                if (player != null && !player.isShiftKeyDown()) {
                    ArmorStandPose.randomValue().applyToEntity(armorStand);
                }
            }
            itemStack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.FAIL;
    }

    private void randomizePose(ArmorStand armorStand, RandomSource random) {
        Rotations rotations = armorStand.getHeadPose();
        float f = random.nextFloat() * 5.0f;
        float g = random.nextFloat() * 20.0f - 10.0f;
        Rotations rotations2 = new Rotations(rotations.getX() + f, rotations.getY() + g, rotations.getZ());
        armorStand.setHeadPose(rotations2);
        rotations = armorStand.getBodyPose();
        f = random.nextFloat() * 10.0f - 5.0f;
        rotations2 = new Rotations(rotations.getX(), rotations.getY() + f, rotations.getZ());
        armorStand.setBodyPose(rotations2);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        tooltipComponents.addAll(Proxy.INSTANCE.splitTooltipLines(ArmorStandInteractHelper.getArmorStandHoverText()));
    }

    public Component getName(ItemStack stack) {
        ResolvableProfile resolvableProfile = (ResolvableProfile)stack.get(DataComponents.PROFILE);
        return resolvableProfile != null && resolvableProfile.name().isPresent() ? Component.translatable((String)(this.getDescriptionId() + ".named"), (Object[])new Object[]{resolvableProfile.name().get()}) : super.getName(stack);
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        ResolvableProfile resolvableProfile = (ResolvableProfile)itemStack.get(DataComponents.PROFILE);
        if (resolvableProfile != null && !resolvableProfile.isResolved()) {
            resolvableProfile.resolve().thenAcceptAsync(newResolvableProfile -> itemStack.set(DataComponents.PROFILE, newResolvableProfile), SkullBlockEntity.CHECKED_MAIN_THREAD_EXECUTOR);
        }
    }
}

