/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client.renderer.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fuzs.strawstatues.StrawStatues;
import fuzs.strawstatues.client.init.ModClientRegistry;
import fuzs.strawstatues.client.model.StrawStatueArmorModel;
import fuzs.strawstatues.client.model.StrawStatueModel;
import fuzs.strawstatues.client.renderer.entity.layers.StrawStatueCapeLayer;
import fuzs.strawstatues.client.renderer.entity.layers.StrawStatueDeadmau5EarsLayer;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.CustomHeadLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StrawStatueRenderer
extends LivingEntityRenderer<StrawStatue, StrawStatueModel> {
    public static final ResourceLocation STRAW_STATUE_LOCATION = StrawStatues.id("textures/entity/straw_statue.png");

    public StrawStatueRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new StrawStatueModel(context.bakeLayer(ModClientRegistry.STRAW_STATUE), false), 0.0f);
        this.addLayer((RenderLayer)new HumanoidArmorLayer((RenderLayerParent)this, new StrawStatueArmorModel(context.bakeLayer(ModClientRegistry.STRAW_STATUE_INNER_ARMOR)), new StrawStatueArmorModel(context.bakeLayer(ModClientRegistry.STRAW_STATUE_OUTER_ARMOR)), context.getModelManager()));
        this.addLayer((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.getItemInHandRenderer()));
        this.addLayer((RenderLayer)new ElytraLayer((RenderLayerParent)this, context.getModelSet()));
        this.addLayer(new StrawStatueDeadmau5EarsLayer((RenderLayerParent<StrawStatue, StrawStatueModel>)this));
        this.addLayer(new StrawStatueCapeLayer((RenderLayerParent<StrawStatue, StrawStatueModel>)this));
        this.addLayer((RenderLayer)new CustomHeadLayer((RenderLayerParent)this, context.getModelSet(), context.getItemInHandRenderer()));
    }

    public static Optional<PlayerSkin> getPlayerProfileTexture(StrawStatue strawStatue) {
        return strawStatue.getProfile().map(ResolvableProfile::gameProfile).map(gameProfile -> {
            Minecraft minecraft = Minecraft.getInstance();
            return minecraft.getSkinManager().getInsecureSkin(gameProfile);
        });
    }

    public void render(StrawStatue entity, float entityYaw, float partialTicks, PoseStack matrixStack, MultiBufferSource buffer, int packedLight) {
        this.setModelProperties(entity);
        super.render((LivingEntity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public Vec3 getRenderOffset(StrawStatue entity, float partialTicks) {
        return entity.isCrouching() ? new Vec3(0.0, -0.125, 0.0) : super.getRenderOffset((Entity)entity, partialTicks);
    }

    private void setModelProperties(StrawStatue entity) {
        StrawStatueModel model = (StrawStatueModel)this.getModel();
        model.setAllVisible(true);
        model.hat.visible = entity.isModelPartShown(PlayerModelPart.HAT);
        model.jacket.visible = entity.isModelPartShown(PlayerModelPart.JACKET);
        model.leftPants.visible = entity.isModelPartShown(PlayerModelPart.LEFT_PANTS_LEG);
        model.rightPants.visible = entity.isModelPartShown(PlayerModelPart.RIGHT_PANTS_LEG);
        model.leftSleeve.visible = model.slimLeftSleeve.visible = entity.isModelPartShown(PlayerModelPart.LEFT_SLEEVE);
        model.rightSleeve.visible = model.slimRightSleeve.visible = entity.isModelPartShown(PlayerModelPart.RIGHT_SLEEVE);
        model.crouching = entity.isCrouching();
    }

    public ResourceLocation getTextureLocation(StrawStatue entity) {
        return StrawStatueRenderer.getPlayerProfileTexture(entity).map(PlayerSkin::texture).orElse(STRAW_STATUE_LOCATION);
    }

    protected void scale(StrawStatue livingEntity, PoseStack matrixStack, float partialTickTime) {
        float modelScale = Mth.lerp((float)partialTickTime, (float)livingEntity.entityScaleO, (float)livingEntity.getEntityScale());
        modelScale /= 3.0f;
        matrixStack.scale(modelScale *= 0.9375f, modelScale, modelScale);
    }

    protected void setupRotations(StrawStatue entityLiving, PoseStack matrixStack, float ageInTicks, float rotationYaw, float partialTicks, float scale) {
        float entityZRotation = Mth.lerp((float)partialTicks, (float)entityLiving.entityRotationsO.getZ(), (float)entityLiving.getEntityZRotation());
        float entityXRotation = Mth.lerp((float)partialTicks, (float)entityLiving.entityRotationsO.getX(), (float)entityLiving.getEntityXRotation());
        matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f - entityZRotation));
        matrixStack.mulPose(Axis.YP.rotationDegrees(180.0f - rotationYaw));
        matrixStack.mulPose(Axis.XP.rotationDegrees(180.0f - entityXRotation));
        float hurtAmount = (float)(entityLiving.level().getGameTime() - entityLiving.lastHit) + partialTicks;
        if (hurtAmount < 5.0f) {
            matrixStack.mulPose(Axis.YP.rotationDegrees(Mth.sin((float)(hurtAmount / 1.5f * (float)Math.PI)) * 3.0f));
        }
        if (StrawStatueRenderer.isEntityUpsideDown((LivingEntity)entityLiving)) {
            matrixStack.translate(0.0, (double)(entityLiving.getBbHeight() - 0.0625f), 0.0);
            matrixStack.mulPose(Axis.ZP.rotationDegrees(180.0f));
        }
    }

    protected boolean shouldShowName(StrawStatue entity) {
        double d = this.entityRenderDispatcher.distanceToSqr((Entity)entity);
        float f = entity.isCrouching() ? 32.0f : 64.0f;
        return !(d >= (double)(f * f)) && entity.isCustomNameVisible();
    }

    @Nullable
    protected RenderType getRenderType(StrawStatue livingEntity, boolean bodyVisible, boolean translucent, boolean glowing) {
        if (!livingEntity.isMarker()) {
            return super.getRenderType((LivingEntity)livingEntity, bodyVisible, translucent, glowing);
        }
        ResourceLocation resourceLocation = this.getTextureLocation(livingEntity);
        if (translucent) {
            return RenderType.entityTranslucent((ResourceLocation)resourceLocation, (boolean)false);
        }
        return bodyVisible ? RenderType.entityCutoutNoCull((ResourceLocation)resourceLocation, (boolean)false) : null;
    }
}

