/*
 * Decompiled with CFR 0.152.
 */
package fuzs.strawstatues.client;

import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.EntityRenderersContext;
import fuzs.puzzleslib.api.client.core.v1.context.LayerDefinitionsContext;
import fuzs.puzzleslib.api.client.core.v1.context.MenuScreensContext;
import fuzs.statuemenus.api.v1.client.gui.screens.ArmorStandInInventoryRenderer;
import fuzs.statuemenus.api.v1.client.gui.screens.ArmorStandRotationsScreen;
import fuzs.statuemenus.api.v1.client.gui.screens.ArmorStandScreenFactory;
import fuzs.statuemenus.api.v1.world.inventory.ArmorStandMenu;
import fuzs.statuemenus.api.v1.world.inventory.data.ArmorStandScreenType;
import fuzs.statuemenus.api.v1.world.inventory.data.PosePartMutator;
import fuzs.strawstatues.client.gui.screens.StrawStatueModelPartsScreen;
import fuzs.strawstatues.client.gui.screens.StrawStatuePositionScreen;
import fuzs.strawstatues.client.gui.screens.StrawStatueScaleScreen;
import fuzs.strawstatues.client.init.ModClientRegistry;
import fuzs.strawstatues.client.model.StrawStatueModel;
import fuzs.strawstatues.client.renderer.entity.StrawStatueRenderer;
import fuzs.strawstatues.init.ModRegistry;
import fuzs.strawstatues.world.entity.decoration.StrawStatue;
import net.minecraft.client.model.ArmorStandArmorModel;
import net.minecraft.client.model.geom.LayerDefinitions;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.core.Rotations;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.inventory.MenuType;

public class StrawStatuesClient
implements ClientModConstructor {
    public void onClientSetup() {
        ArmorStandScreenFactory.register((ArmorStandScreenType)ModRegistry.MODEL_PARTS_SCREEN_TYPE, StrawStatueModelPartsScreen::new);
        ArmorStandScreenFactory.register((ArmorStandScreenType)ModRegistry.STRAW_STATUE_POSITION_SCREEN_TYPE, StrawStatuePositionScreen::new);
        ArmorStandScreenFactory.register((ArmorStandScreenType)ModRegistry.STRAW_STATUE_SCALE_SCREEN_TYPE, StrawStatueScaleScreen::new);
        ArmorStandRotationsScreen.registerPosePartMutatorFilter((PosePartMutator)ModRegistry.CAPE_POSE_PART_MUTATOR, armorStand -> {
            StrawStatue strawStatue = (StrawStatue)((Object)armorStand);
            if (strawStatue.isModelPartShown(PlayerModelPart.CAPE)) {
                return StrawStatueRenderer.getPlayerProfileTexture(strawStatue).map(PlayerSkin::capeTexture).isPresent();
            }
            return false;
        });
        ArmorStandInInventoryRenderer.setArmorStandRenderer((guiGraphics, posX, posY, scale, mouseX, mouseY, livingEntity) -> {
            StrawStatue strawStatue;
            float modelScale = 0.0f;
            Rotations entityRotations = null;
            if (livingEntity instanceof StrawStatue) {
                strawStatue = (StrawStatue)livingEntity;
                modelScale = strawStatue.getEntityScale();
                entityRotations = strawStatue.getEntityRotations();
                strawStatue.setEntityScale(3.0f);
                strawStatue.setEntityRotations(StrawStatue.DEFAULT_ENTITY_ROTATIONS.getX(), StrawStatue.DEFAULT_ENTITY_ROTATIONS.getZ());
            }
            ArmorStandInInventoryRenderer.SIMPLE.renderEntityInInventory(guiGraphics, posX, posY, scale, mouseX, mouseY, livingEntity);
            if (livingEntity instanceof StrawStatue) {
                strawStatue = (StrawStatue)livingEntity;
                strawStatue.setEntityScale(modelScale);
                strawStatue.setEntityRotations(entityRotations.getX(), entityRotations.getZ());
            }
        });
    }

    public void onRegisterMenuScreens(MenuScreensContext context) {
        context.registerMenuScreen((MenuType)ModRegistry.STRAW_STATUE_MENU_TYPE.value(), (menu, inventory, component) -> ArmorStandScreenFactory.createLastScreenType((ArmorStandMenu)menu, (Inventory)inventory, (Component)component));
    }

    public void onRegisterEntityRenderers(EntityRenderersContext context) {
        context.registerEntityRenderer((EntityType)ModRegistry.STRAW_STATUE_ENTITY_TYPE.value(), StrawStatueRenderer::new);
    }

    public void onRegisterLayerDefinitions(LayerDefinitionsContext context) {
        context.registerLayerDefinition(ModClientRegistry.STRAW_STATUE, StrawStatueModel::createBodyLayer);
        context.registerLayerDefinition(ModClientRegistry.STRAW_STATUE_INNER_ARMOR, () -> ArmorStandArmorModel.createBodyLayer((CubeDeformation)LayerDefinitions.INNER_ARMOR_DEFORMATION));
        context.registerLayerDefinition(ModClientRegistry.STRAW_STATUE_OUTER_ARMOR, () -> ArmorStandArmorModel.createBodyLayer((CubeDeformation)LayerDefinitions.OUTER_ARMOR_DEFORMATION));
    }
}

