/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.mixins.common.entity;

import java.util.Objects;
import mod.azure.azurelib.common.api.client.helper.ClientUtils;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.impl.classic.FacehuggerEntity;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    @Unique
    private long lastUpdateTime = 0L;

    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"wantsToStopRiding"}, at={@At(value="RETURN")}, cancellable=true)
    protected void gigeresque$shouldDismount(CallbackInfoReturnable<Boolean> callbackInfo) {
        if (this.getVehicle() instanceof AlienEntity) {
            callbackInfo.setReturnValue((Object)false);
        }
    }

    @Inject(method={"interactOn"}, at={@At(value="HEAD")}, cancellable=true)
    protected void gigeresque$stopPlayerUsing(Entity entity, InteractionHand hand, CallbackInfoReturnable<InteractionResult> callbackInfo) {
        if (this.getPassengers().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
            callbackInfo.setReturnValue((Object)InteractionResult.FAIL);
        }
    }

    @Inject(method={"attack"}, at={@At(value="HEAD")}, cancellable=true)
    protected void gigeresque$noAttacking(Entity target, CallbackInfo callbackInfo) {
        if (this.getPassengers().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
            this.stopUsingItem();
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="HEAD")}, cancellable=true)
    public void gigeresque$tickMovement(CallbackInfo callbackInfo) {
        if (this.getPassengers().stream().anyMatch(FacehuggerEntity.class::isInstance)) {
            callbackInfo.cancel();
        }
    }

    @Unique
    private String gigeresque$generateTimerMessage() {
        float ticksAttached = ((FacehuggerEntity)Objects.requireNonNull(this.getFirstPassenger())).ticksAttachedToHost;
        float tickTimer = CommonMod.config.getFacehuggerAttachTickTimer();
        float secondsAttached = CommonMod.config.facehuggerConfigs.enableFacehuggerTimerTicks ? ticksAttached : (float)Math.round(ticksAttached / 20.0f);
        float secondsTimer = CommonMod.config.facehuggerConfigs.enableFacehuggerTimerTicks ? tickTimer : (float)Math.round(tickTimer / 20.0f);
        return "Attachment Timer: " + secondsAttached + " seconds / " + secondsTimer + " seconds";
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void gigeresque$tellPlayer(CallbackInfo ci) {
        if (this.level().isClientSide()) {
            long currentTime;
            Player player;
            if (this.getPassengers().stream().anyMatch(FacehuggerEntity.class::isInstance) && CommonMod.config.facehuggerConfigs.enableFacehuggerAttachmentTimer && (player = ClientUtils.getClientPlayer()) != null && (currentTime = System.currentTimeMillis()) - this.lastUpdateTime >= 1000L) {
                this.lastUpdateTime = currentTime;
                String timerMessage = this.gigeresque$generateTimerMessage();
                player.displayClientMessage((Component)Component.literal((String)timerMessage), true);
            }
        }
    }
}

