/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.worlddata;

import java.util.List;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.worlddata.PandoraData;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import org.jetbrains.annotations.NotNull;

public class PandoraEffect
implements CustomSpawner {
    private int nextTick = 0;

    public int tick(@NotNull ServerLevel level, boolean spawnEnemies, boolean spawnFriendlies) {
        if (!(PandoraData.isTriggered() && spawnEnemies && level.getGameRules().getBoolean(GameRules.RULE_DO_PATROL_SPAWNING) && CommonMod.config.enablePandoraEffects)) {
            return 0;
        }
        if (!PandoraData.isTriggered()) {
            return 0;
        }
        if (--this.nextTick > 0) {
            return 0;
        }
        this.nextTick = 6000 + level.random.nextInt(200);
        RandomSource randomSource = level.random;
        Player player = this.getRandomPlayer(level);
        if (player == null) {
            return 0;
        }
        BlockPos playerPos = player.blockPosition();
        if (player.level().getBlockState(playerPos).is(GigTags.DUNGEON_BLOCKS)) {
            return 0;
        }
        if (level.getMaxLocalRawBrightness(player.blockPosition()) >= 8) {
            if (CommonMod.config.enableLogging) {
                CommonMod.LOGGER.warn("Failed to spawn entity: Light level at {} is too high ({}).", (Object)player.blockPosition(), (Object)player.level().getBrightness(LightLayer.SKY, player.blockPosition()));
            }
            return 0;
        }
        BlockPos mutableBlockPos = this.getRandomNearbyPosition(player, randomSource);
        if (!this.isValidSpawnLocation(mutableBlockPos, level)) {
            return 0;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(Constants.modResource("firstspawnfromeffect"));
            if (advancement != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                for (String s : serverPlayer.getAdvancements().getOrStartProgress(advancement).getRemainingCriteria()) {
                    serverPlayer.getAdvancements().award(advancement, s);
                }
            }
        }
        return this.spawnEggs(level, mutableBlockPos);
    }

    private boolean isValidSpawnTime(ServerLevel level) {
        return level.random.nextInt(5) == 0;
    }

    private Player getRandomPlayer(ServerLevel level) {
        List players = level.players();
        if (players.isEmpty()) {
            return null;
        }
        ServerPlayer player = (ServerPlayer)players.get(level.random.nextInt(players.size()));
        if (player.isSpectator()) {
            CommonMod.LOGGER.warn("Excluded player {} because they are in Spectator mode.", (Object)player.getName().getString());
            return null;
        }
        return player;
    }

    private BlockPos getRandomNearbyPosition(Player player, RandomSource randomSource) {
        int xOffset = (24 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
        int zOffset = (24 + randomSource.nextInt(24)) * (randomSource.nextBoolean() ? -1 : 1);
        return player.blockPosition().mutable().move(xOffset, 0, zOffset);
    }

    private boolean isValidSpawnLocation(BlockPos pos, ServerLevel level) {
        if (!level.hasChunksAt(pos.getX() - 10, pos.getZ() - 10, pos.getX() + 10, pos.getZ() + 10)) {
            return false;
        }
        if (level.getMaxLocalRawBrightness(pos) >= 8) {
            return false;
        }
        Holder biomeHolder = level.getBiome(pos);
        return biomeHolder.is(BiomeTags.IS_OVERWORLD);
    }

    private int spawnEggs(ServerLevel level, BlockPos startPos) {
        RandomSource randomSource = level.random;
        startPos.setY(level.getHeightmapPos(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, startPos).getY());
        this.spawnEgg(level, startPos);
        startPos.setX(startPos.getX() + randomSource.nextInt(5) - randomSource.nextInt(5));
        startPos.setZ(startPos.getZ() + randomSource.nextInt(5) - randomSource.nextInt(5));
        return 1;
    }

    private void spawnEgg(ServerLevel level, BlockPos pos) {
        BlockState belowState = level.getBlockState(pos.below());
        if (!belowState.is(Blocks.GRASS_BLOCK)) {
            return;
        }
        boolean isWaterBiome = level.getBiome(pos).is(GigTags.AQUASPAWN_BIOMES);
        Entity eggEntity = isWaterBiome ? GigEntities.AQUA_EGG.get().create((Level)level) : GigEntities.EGG.get().create((Level)level);
        eggEntity.setPos((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        if (CommonMod.config.enableLogging) {
            eggEntity.setGlowingTag(true);
            CommonMod.LOGGER.info("Spawned Pandora {} at {}, {}, {}", (Object)eggEntity.getDisplayName().getString(), (Object)pos.getX(), (Object)pos.getY(), (Object)pos.getZ());
        }
        level.addFreshEntityWithPassengers(eggEntity);
    }
}

