/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.util.nest;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.block.NestResinBlock;
import mods.cybercat.gigeresque.common.block.NestResinWebBlock;
import mods.cybercat.gigeresque.common.block.NestResinWebVariant;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.nest.NestBlockData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public record NestBuildingHelper() {
    public static void tryBuildNestAround(Level level, BlockPos pos, AlienEntity alienEntity) {
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                for (int y = -1; y <= 3; ++y) {
                    BlockPos blockPos = pos.offset(x, y, z);
                    NestBlockData nestBlockData = NestBuildingHelper.getNestBlockData(level, blockPos);
                    if (nestBlockData == null || level.getLightEmission(pos) >= 6) continue;
                    BlockState resinBlock = (BlockState)GigBlocks.NEST_RESIN.get().defaultBlockState().setValue((Property)NestResinBlock.LAYERS, (Comparable)Integer.valueOf(Math.min(8, level.getRandom().nextInt(1, 7) + 1)));
                    BlockState webBlock = GigBlocks.NEST_RESIN_WEB_CROSS.get().defaultBlockState();
                    BlockState nestResinWebState = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)GigBlocks.NEST_RESIN_WEB.get().defaultBlockState().setValue((Property)NestResinWebBlock.UP, (Comparable)Boolean.valueOf(nestBlockData.hasUpCoverage()))).setValue((Property)NestResinWebBlock.NORTH, (Comparable)Boolean.valueOf(nestBlockData.hasNorthCoverage()))).setValue((Property)NestResinWebBlock.SOUTH, (Comparable)Boolean.valueOf(nestBlockData.hasSouthCoverage()))).setValue((Property)NestResinWebBlock.EAST, (Comparable)Boolean.valueOf(nestBlockData.hasEastCoverage()))).setValue((Property)NestResinWebBlock.WEST, (Comparable)Boolean.valueOf(nestBlockData.hasWestCoverage()))).setValue(NestResinWebBlock.VARIANTS, (Comparable)((Object)NestResinWebVariant.values()[level.getRandom().nextInt(NestResinWebVariant.values().length)]));
                    if (nestBlockData.isFloor() && !level.getBlockState(blockPos).is(GigTags.DUNGEON_BLOCKS)) {
                        level.setBlockAndUpdate(blockPos, level.getRandom().nextInt(0, 50) > 30 ? webBlock : resinBlock);
                        if (!alienEntity.hasHomeBlock()) {
                            alienEntity.setHomeBlock(blockPos);
                        }
                        alienEntity.savedNestWebCross = blockPos;
                    }
                    if (nestBlockData.isCorner() && !level.getBlockState(blockPos).is(GigTags.DUNGEON_BLOCKS)) {
                        level.setBlockAndUpdate(blockPos, webBlock);
                        alienEntity.savedNestWebCross = blockPos;
                    }
                    if (!nestBlockData.isWall() && !nestBlockData.isCeiling() || level.getBlockState(blockPos).is(GigTags.DUNGEON_BLOCKS)) continue;
                    level.setBlockAndUpdate(blockPos, nestResinWebState);
                    alienEntity.savedNestWebCross = blockPos;
                }
            }
        }
    }

    public static boolean isResinBlock(Block block) {
        return block.defaultBlockState().is(GigTags.NEST_BLOCKS);
    }

    private static NestBlockData getNestBlockData(Level world, BlockPos blockPos) {
        BlockState actualState = world.getBlockState(blockPos);
        Block actualBlock = actualState.getBlock();
        if (NestBuildingHelper.isResinBlock(actualBlock)) {
            return null;
        }
        BlockPos upPos = blockPos.above();
        BlockState upState = world.getBlockState(upPos);
        BlockPos downPos = blockPos.below();
        BlockState downState = world.getBlockState(downPos);
        BlockPos northPos = blockPos.north();
        BlockState northState = world.getBlockState(northPos);
        BlockPos southPos = blockPos.south();
        BlockState southState = world.getBlockState(southPos);
        BlockPos eastPos = blockPos.east();
        BlockState eastState = world.getBlockState(eastPos);
        BlockPos westPos = blockPos.west();
        BlockState westState = world.getBlockState(westPos);
        List<Pair> blockStates = List.of(Pair.of((Object)upPos, (Object)upState), Pair.of((Object)downPos, (Object)downState), Pair.of((Object)northPos, (Object)northState), Pair.of((Object)southPos, (Object)southState), Pair.of((Object)eastPos, (Object)eastState), Pair.of((Object)westPos, (Object)westState));
        AtomicInteger fullCoverage = new AtomicInteger();
        AtomicInteger horizontalCoverage = new AtomicInteger();
        AtomicInteger cornerCoverage = new AtomicInteger();
        blockStates.forEach(it -> {
            boolean isOpaqueCube = ((BlockState)it.getSecond()).isSolidRender((BlockGetter)world, (BlockPos)it.getFirst());
            if (isOpaqueCube) {
                if (!NestBuildingHelper.isResinBlock(((BlockState)it.getSecond()).getBlock())) {
                    if (it.getFirst() != upPos && it.getFirst() != downPos) {
                        horizontalCoverage.getAndIncrement();
                    }
                    fullCoverage.getAndIncrement();
                } else {
                    cornerCoverage.getAndIncrement();
                }
            }
        });
        boolean isFloor = actualState.isAir() && upState.isAir() && !NestBuildingHelper.isResinBlock(downState.getBlock()) && downState.isSolidRender((BlockGetter)world, downPos) && world.getLightEmission(blockPos) < 10;
        boolean isWall = !isFloor && actualState.isAir() && (upState.isAir() || NestBuildingHelper.isResinBlock(upState.getBlock())) && 1 <= horizontalCoverage.get() && horizontalCoverage.get() <= 2 && world.getLightEmission(blockPos) < 10;
        boolean isCorner = actualState.isAir() && 3 <= fullCoverage.get() && fullCoverage.get() <= 5 && world.getLightEmission(blockPos) < 10;
        boolean isCeiling = actualState.isAir() && (downState.isAir() || NestBuildingHelper.isResinBlock(downState.getBlock())) && upState.isSolidRender((BlockGetter)world, downPos) && !isCorner && world.getLightEmission(blockPos) < 10;
        return new NestBlockData(fullCoverage.get(), isCorner, isFloor, isCeiling, isWall, upState.isSolidRender((BlockGetter)world, upPos), downState.isSolidRender((BlockGetter)world, downPos), northState.isSolidRender((BlockGetter)world, northPos), southState.isSolidRender((BlockGetter)world, southPos), eastState.isSolidRender((BlockGetter)world, eastPos), westState.isSolidRender((BlockGetter)world, westPos));
    }
}

