/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.util;

import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.item.GigItems;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class DispenserBehaviors {
    public static void initialize() {
        DefaultDispenseItemBehavior defaultDispenseItemBehavior = new DefaultDispenseItemBehavior(){

            @NotNull
            public ItemStack execute(BlockSource blockSource, ItemStack itemStack) {
                Direction direction = (Direction)blockSource.state().getValue((Property)DispenserBlock.FACING);
                EntityType entitytype = ((SpawnEggItem)itemStack.getItem()).getType(itemStack);
                try {
                    entitytype.spawn(blockSource.level(), itemStack, null, blockSource.pos().relative(direction), MobSpawnType.DISPENSER, direction != Direction.UP, false);
                }
                catch (Exception exception) {
                    CommonMod.LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)blockSource.pos(), (Object)exception);
                    return ItemStack.EMPTY;
                }
                itemStack.shrink(1);
                blockSource.level().gameEvent(null, (Holder)GameEvent.ENTITY_PLACE, blockSource.pos());
                return itemStack;
            }
        };
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.AQUATIC_ALIEN_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.AQUATIC_CHESTBURSTER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.EGG_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.FACEHUGGER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.CHESTBURSTER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.ALIEN_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.BAPHOMORPH_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.HELL_BURSTER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.HELLMORPH_RUNNER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.SPITTER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.MUTANT_HAMMERPEDE_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.MUTANT_POPPER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.MUTANT_STALKER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.NEOBURSTER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.NEOMORPH_ADOLESCENT_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.NEOMORPH_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.RUNNER_ALIEN_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.RUNNERBURSTER_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.DRACONICTEMPLEBEAST_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.MOONLIGHTHORRORTEMPLEBEAST_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
        DispenserBlock.registerBehavior((ItemLike)((ItemLike)GigItems.RAVENOUSTEMPLEBEAST_SPAWN_EGG.get()), (DispenseItemBehavior)defaultDispenseItemBehavior);
    }
}

