/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.status.effect.impl;

import mod.azure.azurelib.core.object.Color;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.DamageSourceUtils;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class DNAStatusEffect
extends MobEffect {
    private static BlockPos lightBlockPos = null;

    public DNAStatusEffect() {
        super(MobEffectCategory.HARMFUL, Color.DARK_GRAY.getColor());
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    public boolean applyEffectTick(@NotNull LivingEntity entity, int amplifier) {
        super.applyEffectTick(entity, amplifier);
        if (!entity.getType().is(GigTags.DNAIMMUNE) && this == GigStatusEffects.DNA) {
            entity.heal(0.0f);
        }
        return super.applyEffectTick(entity, amplifier);
    }

    public static void effectRemoval(LivingEntity entity, MobEffectInstance mobEffectInstance) {
        Mob mob;
        int randomPhase = entity.getRandom().nextInt(0, 50);
        if (Constants.isCreeper.test((Entity)entity)) {
            return;
        }
        if (Constants.isCreativeSpecPlayer.test((Entity)entity)) {
            return;
        }
        if (GigEntityUtils.isTargetDNAImmune((Entity)entity)) {
            return;
        }
        if (entity.level().isClientSide || !(mobEffectInstance.getEffect().value() instanceof DNAStatusEffect)) {
            return;
        }
        if (entity instanceof Mob && (mob = (Mob)entity).isNoAi()) {
            return;
        }
        if (entity.hasEffect(MobEffects.ABSORPTION) && entity.hasEffect(MobEffects.WITHER) && entity.hasEffect(MobEffects.REGENERATION)) {
            return;
        }
        if (!entity.getType().is(GigTags.DNAIMMUNE)) {
            if (randomPhase > 25) {
                if (Constants.notPlayer.test((Entity)entity) && !GigEntityUtils.isTargetDNAImmune((Entity)entity) || Constants.isNotCreativeSpecPlayer.test((Entity)entity)) {
                    GigEntityUtils.spawnMutant(entity);
                    entity.hurt(GigDamageSources.of(entity.level(), GigDamageSources.DNA), 2.1474836E9f);
                    if (Constants.isNotCreativeSpecPlayer.test((Entity)entity)) {
                        DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.FEET), entity.getRandom(), 10, 50);
                        DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.LEGS), entity.getRandom(), 10, 50);
                        DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.CHEST), entity.getRandom(), 10, 50);
                        DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.HEAD), entity.getRandom(), 10, 50);
                    }
                }
            } else if (Constants.notPlayer.test((Entity)entity) && !GigEntityUtils.isTargetDNAImmune((Entity)entity) || Constants.isNotCreativeSpecPlayer.test((Entity)entity)) {
                DNAStatusEffect.placeGoo(entity);
                entity.hurt(GigDamageSources.of(entity.level(), GigDamageSources.DNA), 2.1474836E9f);
                if (Constants.isNotCreativeSpecPlayer.test((Entity)entity)) {
                    DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.FEET), entity.getRandom(), 10, 50);
                    DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.LEGS), entity.getRandom(), 10, 50);
                    DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.CHEST), entity.getRandom(), 10, 50);
                    DamageSourceUtils.damageArmor(entity.getItemBySlot(EquipmentSlot.HEAD), entity.getRandom(), 10, 50);
                }
            }
        }
    }

    private static void placeGoo(LivingEntity entity) {
        DNAStatusEffect.spawnGoo(entity);
    }

    private static void spawnGoo(LivingEntity entity) {
        if (lightBlockPos == null) {
            lightBlockPos = DNAStatusEffect.findFreeSpace(entity.level(), entity.blockPosition());
            if (lightBlockPos == null) {
                return;
            }
            AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud(entity.level(), entity.getX(), entity.getY(), entity.getZ());
            areaEffectCloudEntity.setRadius(2.0f);
            areaEffectCloudEntity.setDuration(300);
            areaEffectCloudEntity.setRadiusPerTick(0.0f);
            areaEffectCloudEntity.addEffect(new MobEffectInstance(GigStatusEffects.DNA, 600, 0));
            entity.level().addFreshEntity((Entity)areaEffectCloudEntity);
        } else {
            lightBlockPos = null;
        }
    }

    private static BlockPos findFreeSpace(Level world, BlockPos blockPos) {
        if (blockPos == null) {
            return null;
        }
        int[] offsets = new int[3];
        for (int i = 2; i <= 2; i += 2) {
            offsets[i - 1] = i / 2;
            offsets[i] = -i / 2;
        }
        for (int x : offsets) {
            for (int y : offsets) {
                for (int z : offsets) {
                    BlockPos offsetPos = blockPos.offset(x, y, z);
                    BlockState state = world.getBlockState(offsetPos);
                    if (!state.isAir() && !state.getBlock().equals(GigBlocks.NEST_RESIN_WEB_CROSS)) continue;
                    return offsetPos;
                }
            }
        }
        return null;
    }
}

