/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.item;

import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.impl.misc.HologramEntity;
import mods.cybercat.gigeresque.common.item.animator.TrackerAnimationDispatcher;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class TrackerItem
extends Item {
    private TrackerAnimationDispatcher animationDispatcher = new TrackerAnimationDispatcher();

    public TrackerItem() {
        super(new Item.Properties());
    }

    public void onUseTick(Level level, LivingEntity livingEntity, ItemStack itemstack, int remainingUseDuration) {
        super.onUseTick(level, livingEntity, itemstack, remainingUseDuration);
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                BlockPos blockpos = serverlevel.findNearestMapStructure(GigTags.GIG_EXPLORER_MAPS, player.blockPosition(), 100, false);
                if (blockpos != null && !player.getCooldowns().isOnCooldown((Item)this)) {
                    this.animationDispatcher.sendOpeningAnimation((Entity)player, itemstack);
                    Vec3 viewVector = player.getViewVector(1.0f);
                    double spawnX = player.getX() + viewVector.x * 5.0;
                    double spawnZ = player.getZ() + viewVector.z * 5.0;
                    double dx = (double)blockpos.getX() + 0.5 - spawnX;
                    double dz = (double)blockpos.getZ() + 0.5 - spawnZ;
                    float rotation = (float)(Math.toDegrees(Math.atan2(dz, dx)) - 90.0);
                    double horizontalDistance = Math.sqrt(dx * dx + dz * dz);
                    int distanceCategory = horizontalDistance <= 50.0 ? 3 : (horizontalDistance <= 500.0 ? 2 : 1);
                    HologramEntity hologramEntity = (HologramEntity)GigEntities.ENGINEER_HOLOGRAM.get().create(level);
                    if (hologramEntity != null) {
                        if (CommonMod.config.enableLogging) {
                            CommonMod.LOGGER.info("Distance Category: {}", (Object)distanceCategory);
                        }
                        hologramEntity.setPos(spawnX, player.getY(), spawnZ);
                        hologramEntity.setDistanceState(distanceCategory);
                        hologramEntity.setDistanceFromStructure((int)horizontalDistance);
                        hologramEntity.setYRot(rotation);
                        hologramEntity.setOnGround(true);
                        level.addFreshEntity((Entity)hologramEntity);
                    }
                } else {
                    level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.CRAFTER_FAIL, SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
                player.getCooldowns().addCooldown((Item)this, 120);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player user, @NotNull InteractionHand hand) {
        ItemStack itemStack = user.getItemInHand(hand);
        user.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemStack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        Player player;
        if (entity instanceof Player && !(player = (Player)entity).getCooldowns().isOnCooldown((Item)this)) {
            this.animationDispatcher.sendClosingAnimation(entity, stack);
        }
        super.inventoryTick(stack, level, entity, slotId, isSelected);
    }
}

