/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.runner;

import java.util.Objects;
import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.BreakBlocksGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedAttackGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.EatFoodItemGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.LungeAtFoodTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeExplodingCreeperGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFightGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFireGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.StrollAroundInWaterGoal;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.AzureVibrationUser;
import mods.cybercat.gigeresque.common.entity.helper.GigMeleeAttackSelector;
import mods.cybercat.gigeresque.common.entity.helper.Growable;
import mods.cybercat.gigeresque.common.entity.impl.classic.ChestbursterEntity;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunnerbursterEntity
extends ChestbursterEntity
implements Growable {
    public RunnerbursterEntity(EntityType<? extends RunnerbursterEntity> type, Level level) {
        super((EntityType<? extends ChestbursterEntity>)type, level);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
        this.animationSelector = GigMeleeAttackSelector.RBUSTER_ANIM_SELECTOR;
        this.vibrationUser = new AzureVibrationUser(this, 1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, CommonMod.config.runnerbusterConfigs.runnerbusterHealth).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 8.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.3300000041723251).add(Attributes.ATTACK_DAMAGE, CommonMod.config.runnerbusterConfigs.runnerbusterAttackDamage).add(Attributes.ATTACK_KNOCKBACK, 0.3);
    }

    @Override
    public float getGrowthMultiplier() {
        return CommonMod.config.bursterConfigs.runnerbursterGrowthMultiplier;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.getGrowth() < 2.0f) {
            this.animationDispatcher.sendBirth();
            this.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 80, 10), (Entity)this);
        }
    }

    @Override
    public LivingEntity growInto() {
        LivingEntity alien = Objects.equals(this.hostId, "runner") ? (LivingEntity)GigEntities.RUNNER_ALIEN.get().create(this.level()) : (LivingEntity)GigEntities.ALIEN.get().create(this.level());
        return alien;
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FleeExplodingCreeperGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new FleeFightGoal(this));
        this.goalSelector.addGoal(1, (Goal)new DelayedAttackGoal(this, 1.1f, 5));
        this.goalSelector.addGoal(2, (Goal)new LungeAtFoodTargetGoal((Mob)this, 1.0f, 80, 5.0).setOnLungeCallback(() -> this.runLungeAnimation()));
        this.goalSelector.addGoal(3, (Goal)new EatFoodItemGoal(this, 0.9f, 5));
        this.goalSelector.addGoal(4, (Goal)new BreakBlocksGoal(this, GigTags.BURSTER_BLOCKS, 1.5f));
        this.goalSelector.addGoal(5, (Goal)new FleeFireGoal(this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AlienEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> this.getHealth() > this.getMaxHealth() / 2.0f && GigEntityUtils.removeTarget(target) && (double)target.getBbHeight() < 0.8));
    }

    @Nullable
    public SpawnGroupData finalizeSpawn(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        if (spawnType == MobSpawnType.SPAWN_EGG) {
            this.setHostId("runner");
            this.setGrowth(5.0f);
            this.setBirthStatus(false);
        }
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }
}

