/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.neo;

import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.GigEntities;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.BreakBlocksGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedAttackGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.EatFoodItemGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.LungeAtFoodTargetGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeExplodingCreeperGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFightGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.FleeFireGoal;
import mods.cybercat.gigeresque.common.entity.ai.goals.movement.StrollAroundInWaterGoal;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.AzureVibrationUser;
import mods.cybercat.gigeresque.common.entity.helper.GigMeleeAttackSelector;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.core.component.DataComponents;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class NeomorphAdolescentEntity
extends AlienEntity {
    public NeomorphAdolescentEntity(EntityType<? extends AlienEntity> entityType, Level world) {
        super(entityType, world);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
        this.vibrationUser = new AzureVibrationUser(this, 2.65f);
        this.animationSelector = GigMeleeAttackSelector.NORMAL_ANIM_SELECTOR;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, CommonMod.config.neomorphAdolescentConfigs.neomorph_adolescentXenoHealth).add(Attributes.ARMOR, 0.0).add(Attributes.ARMOR_TOUGHNESS, 6.0).add(Attributes.KNOCKBACK_RESISTANCE, 7.0).add(Attributes.FOLLOW_RANGE, 32.0).add(Attributes.MOVEMENT_SPEED, 0.3300000041723251).add(Attributes.ATTACK_DAMAGE, CommonMod.config.neomorphAdolescentConfigs.neomorph_adolescentAttackDamage + 5.0).add(Attributes.ATTACK_KNOCKBACK, 1.0);
    }

    public boolean doHurtTarget(@NotNull Entity target) {
        if (target instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)target;
            if (!this.level().isClientSide && this.getRandom().nextInt(0, 10) > 7) {
                livingEntity.hurt(this.damageSources().mobAttack((LivingEntity)this), this.getRandom().nextInt(4) > 2 ? CommonMod.config.neomorphAdolescentConfigs.neomorph_adolescentXenoTailAttackDamage : 0.0f);
                this.heal(1.0833f);
                return super.doHurtTarget(target);
            }
        }
        this.heal(1.0833f);
        return super.doHurtTarget(target);
    }

    @Override
    public float getGrowthMultiplier() {
        return CommonMod.config.bursterConfigs.chestbursterGrowthMultiplier;
    }

    @Override
    public LivingEntity growInto() {
        return (LivingEntity)GigEntities.NEOMORPH.get().create(this.level());
    }

    protected void registerGoals() {
        this.goalSelector.addGoal(0, (Goal)new FleeExplodingCreeperGoal(this));
        this.goalSelector.addGoal(1, (Goal)new StrollAroundInWaterGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.6));
        this.goalSelector.addGoal(1, (Goal)new FleeFightGoal(this));
        this.goalSelector.addGoal(1, (Goal)new DelayedAttackGoal(this, 1.15f, 10));
        this.goalSelector.addGoal(2, (Goal)new LungeAtFoodTargetGoal((Mob)this, 0.75f, 80, 5.0).setOnLungeCallback(() -> this.runLungeAnimation()));
        this.goalSelector.addGoal(3, (Goal)new EatFoodItemGoal(this, 0.9f, 5));
        this.goalSelector.addGoal(4, (Goal)new BreakBlocksGoal(this, GigTags.BURSTER_BLOCKS, 1.5f));
        this.goalSelector.addGoal(5, (Goal)new FleeFireGoal(this));
        this.goalSelector.addGoal(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 15.0f, 1.0f));
        this.goalSelector.addGoal(10, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 15.0f));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[]{AlienEntity.class}).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, false, target -> this.getHealth() > this.getMaxHealth() / 2.0f && GigEntityUtils.removeTarget(target)));
    }

    @Override
    public void tick() {
        super.tick();
        this.moveAnalysis.update();
        if (!this.level().isClientSide) {
            AABB radius = this.getBoundingBox().inflate(1.25);
            this.level().getEntitiesOfClass(ItemEntity.class, radius).stream().filter(itemEntity -> itemEntity.getItem().is(GigTags.BURSTER_FOODS)).findFirst().ifPresent(this::checkAndPerformEating);
        }
    }

    @Override
    protected void checkAndPerformEating(ItemEntity target) {
        if (target == null) {
            return;
        }
        if (this.isBirthed()) {
            return;
        }
        if (this.getGrowth() < 10.0f) {
            return;
        }
        if (this.isWithinEatingRange(target)) {
            this.lookAt((Entity)target, 10.0f, 10.0f);
            if (this.delayBeforeEating > 0) {
                --this.delayBeforeEating;
                if (this.delayBeforeEating == 5 && !this.triggeredAttackAnimation) {
                    this.animationDispatcher.sendChomp();
                    this.triggeredAttackAnimation = true;
                }
            } else {
                float growthValue;
                if (target.getItem().is(GigTags.POTIONS)) {
                    this.playSound(SoundEvents.GLASS_BREAK, 1.0f, 1.0f);
                } else {
                    this.playSound(SoundEvents.GENERIC_EAT, 1.0f, 1.0f);
                }
                this.swing(InteractionHand.MAIN_HAND);
                if (target.getItem().has(DataComponents.FOOD)) {
                    FoodProperties foodComponent = (FoodProperties)target.getItem().get(DataComponents.FOOD);
                    growthValue = (float)foodComponent.nutrition() * 20.0f;
                    target.getItem().finishUsingItem(this.level(), (LivingEntity)this);
                } else {
                    growthValue = 20.0f;
                    if (target.getItem().is(GigTags.POTIONS)) {
                        target.getItem().finishUsingItem(this.level(), (LivingEntity)this);
                        target.getItem().consume(1, (LivingEntity)this);
                    } else {
                        target.getItem().consume(1, (LivingEntity)this);
                    }
                }
                this.setGrowth(this.getGrowth() + growthValue);
                this.triggeredAttackAnimation = false;
                this.delayBeforeEating = 20;
            }
        } else {
            --this.delayBeforeEating;
            this.triggeredAttackAnimation = false;
        }
    }
}

