/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.classic;

import mod.azure.azurelib.rewrite.util.MoveAnalysis;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.helper.AnimationDispatcher;
import mods.cybercat.gigeresque.common.entity.helper.GigCommonMethods;
import mods.cybercat.gigeresque.common.entity.helper.states.EggStates;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class AlienEggEntity
extends AlienEntity {
    private static final EntityDataAccessor<Boolean> HAS_FACEHUGGER = SynchedEntityData.defineId(AlienEggEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> NEST_TICKS = SynchedEntityData.defineId(AlienEggEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Integer> EGG_STATE = SynchedEntityData.defineId(AlienEggEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final long MAX_HATCH_PROGRESS = 50L;
    public float ticksUntilNest = -1.0f;
    public long hatchProgress = 0L;
    public long ticksOpen = 0L;
    public int hatchCheckTimer = 0;
    public int hatchedOpenTimer = 0;

    public AlienEggEntity(EntityType<? extends AlienEggEntity> type, Level world) {
        super(type, world);
        this.animationDispatcher = new AnimationDispatcher((Entity)this);
        this.moveAnalysis = new MoveAnalysis((Entity)this);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return LivingEntity.createLivingAttributes().add(Attributes.MAX_HEALTH, CommonMod.config.eggConfigs.alieneggHealth).add(Attributes.ARMOR, 1.0).add(Attributes.ARMOR_TOUGHNESS, 0.0).add(Attributes.KNOCKBACK_RESISTANCE, 0.0).add(Attributes.FOLLOW_RANGE, 0.0).add(Attributes.MOVEMENT_SPEED, 0.0);
    }

    @Override
    public int getAcidDiameter() {
        return 1;
    }

    public void setEggState(int value) {
        this.entityData.set(EGG_STATE, (Object)value);
    }

    public int getEggState() {
        return (Integer)this.entityData.get(EGG_STATE);
    }

    public boolean hasFacehugger() {
        return (Boolean)this.entityData.get(HAS_FACEHUGGER);
    }

    public void setHasFacehugger(boolean value) {
        this.entityData.set(HAS_FACEHUGGER, (Object)value);
    }

    public float getTicksUntilNest() {
        return ((Float)this.entityData.get(NEST_TICKS)).floatValue();
    }

    public void setTicksUntilNest(float ticksUntilEggmorphed) {
        this.entityData.set(NEST_TICKS, (Object)Float.valueOf(ticksUntilEggmorphed));
    }

    @Override
    public void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(HAS_FACEHUGGER, (Object)true);
        builder.define(NEST_TICKS, (Object)Float.valueOf(-1.0f));
        builder.define(EGG_STATE, (Object)0);
    }

    @Override
    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putBoolean("hasFacehugger", this.hasFacehugger());
        nbt.putLong("hatchProgress", this.hatchProgress);
        nbt.putLong("ticksOpen", this.ticksOpen);
        nbt.putFloat("ticksUntilEggmorphed", this.getTicksUntilNest());
        nbt.putInt("eggState", this.getEggState());
    }

    @Override
    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        this.setHasFacehugger(nbt.getBoolean("hasFacehugger"));
        this.hatchProgress = nbt.getLong("hatchProgress");
        this.ticksOpen = nbt.getLong("ticksOpen");
        this.setTicksUntilNest(nbt.getInt("ticksUntilEggmorphed"));
        this.setEggState(nbt.getInt("eggState"));
    }

    @NotNull
    public EntityDimensions getDefaultDimensions(@NotNull Pose pose) {
        if (this.getEggState() == EggStates.HATCHED.ordinal() && !this.isDeadOrDying()) {
            return EntityDimensions.scalable((float)0.7f, (float)1.0f);
        }
        if (this.isDeadOrDying()) {
            return EntityDimensions.scalable((float)0.7f, (float)0.6f);
        }
        return super.getDefaultDimensions(pose);
    }

    @Override
    @NotNull
    public SoundEvent getHurtSound(@NotNull DamageSource source) {
        return GigSounds.EGG_NOTICE.get();
    }

    @Override
    @NotNull
    public SoundEvent getDeathSound() {
        return SoundEvents.EMPTY;
    }

    @Override
    @NotNull
    protected SoundEvent getSwimSplashSound() {
        return SoundEvents.EMPTY;
    }

    @Override
    @NotNull
    protected SoundEvent getSwimSound() {
        return SoundEvents.EMPTY;
    }

    @Override
    public void travel(@NotNull Vec3 vec3) {
        if (this.tickCount % 10 == 0) {
            this.refreshDimensions();
        }
        super.travel(vec3);
    }

    @Override
    public void tick() {
        super.tick();
        if (this.isNoAi()) {
            return;
        }
        if (!this.level().isClientSide) {
            this.setGrowth(0.0f);
            if (this.getEggState() == EggStates.IDLE.ordinal() && this.getLastDamageSource() != null) {
                this.setEggState(EggStates.HATCHING.ordinal());
            }
            GigCommonMethods.handleNestProgress(this);
            GigCommonMethods.handleHatchingProgress(this);
            GigCommonMethods.handleFacehuggerSpawn(this);
            if (this.getEggState() == EggStates.IDLE.ordinal()) {
                ++this.hatchCheckTimer;
            }
            if (this.tickCount % 20 == 0) {
                GigCommonMethods.handleAoEEntityHatchCheck(this);
                GigCommonMethods.handleAoEBlockHatchCheck(this);
            }
            if (this.getEggState() == EggStates.HATCHED.ordinal() && !this.hasFacehugger()) {
                ++this.hatchedOpenTimer;
                if (this.hatchedOpenTimer >= 1200) {
                    this.level().setBlockAndUpdate(this.blockPosition(), GigBlocks.NEST_RESIN_WEB_CROSS.get().defaultBlockState());
                    this.kill();
                }
            }
        }
    }

    public void doPush(@NotNull Entity entity) {
        LivingEntity living;
        if (!this.level().isClientSide && entity instanceof LivingEntity && GigEntityUtils.faceHuggerTest(living = (LivingEntity)entity)) {
            this.setEggState(EggStates.HATCHING.ordinal());
        }
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean shouldPassengersInheritMalus() {
        return false;
    }

    public void knockback(double strength, double x, double z) {
    }

    @Override
    public boolean requiresCustomPersistence() {
        return this.getEggState() != EggStates.HATCHED.ordinal() || this.hasFacehugger();
    }

    @Override
    public void checkDespawn() {
        if (this.getEggState() == EggStates.HATCHED.ordinal() && !this.hasFacehugger()) {
            super.checkDespawn();
        }
    }
}

