/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.impl.blood;

import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.particle.GigParticles;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class GooEntity
extends Entity {
    public GooEntity(EntityType<? extends Entity> entityType, Level level) {
        super(entityType, level);
        this.setDeltaMovement(Vec3.ZERO);
    }

    protected double getDefaultGravity() {
        return 0.04;
    }

    public void tick() {
        super.tick();
        if (this.tickCount == 1) {
            this.moveTo(this.blockPosition().offset(0, 0, 0), this.getYRot(), this.getXRot());
        }
        this.applyCustomGravity();
        if (this.level().isClientSide()) {
            this.applyParticle();
        }
        if (!this.level().isClientSide()) {
            if (this.tickCount >= this.random.nextIntBetweenInclusive(400, 800)) {
                this.kill();
            }
            if (this.tickCount == 1) {
                this.doParticleSounds(this.random);
            }
            if (this.tickCount % 40 == 0) {
                this.doParticleSounds(this.random);
            }
            this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox().inflate(1.0)).forEach(livingEntity -> this.damageLivingEntities((LivingEntity)livingEntity, this.random));
            if (this.level().getBlockState(this.blockPosition()).is(Blocks.LAVA) && CommonMod.config.enableAcidLavaRemoval) {
                this.remove(Entity.RemovalReason.KILLED);
            }
            this.level().getEntities((Entity)this, this.getBoundingBox().inflate(1.0)).forEach(e -> {
                if (e instanceof GooEntity && e.tickCount < this.tickCount) {
                    e.remove(Entity.RemovalReason.KILLED);
                }
            });
        }
    }

    private void applyParticle() {
        for (int i = 0; i < this.random.nextIntBetweenInclusive(0, 4); ++i) {
            this.level().addAlwaysVisibleParticle((ParticleOptions)GigParticles.GOO.get(), (double)this.blockPosition().getX() + this.random.nextDouble(), (double)this.blockPosition().getY() + 0.01, (double)this.blockPosition().getZ() + this.random.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    private void applyCustomGravity() {
        this.applyGravity();
        this.move(MoverType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.38));
    }

    private void doParticleSounds(RandomSource randomSource) {
        this.level().playSound(null, (double)this.blockPosition().getX(), (double)this.blockPosition().getY(), (double)this.blockPosition().getZ(), SoundEvents.SCULK_BLOCK_SPREAD, SoundSource.BLOCKS, 0.2f + randomSource.nextFloat() * 0.2f, 0.9f + randomSource.nextFloat() * 0.15f);
    }

    private void damageLivingEntities(LivingEntity livingEntity, RandomSource randomSource) {
        if (livingEntity.hasEffect(GigStatusEffects.DNA) || livingEntity.getType().is(GigTags.DNAIMMUNE)) {
            return;
        }
        if (Constants.notPlayer.test((Entity)livingEntity) || Constants.isNotCreativeSpecPlayer.test((Entity)livingEntity)) {
            livingEntity.addEffect(new MobEffectInstance(GigStatusEffects.DNA, CommonMod.config.gooEffectTickTimer / 2, 0));
        }
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    protected void addAdditionalSaveData(@NotNull CompoundTag compound) {
    }

    public boolean dampensVibrations() {
        return true;
    }

    @NotNull
    public InteractionResult interact(Player player, @NotNull InteractionHand hand) {
        if (player.getItemInHand(hand).is(Items.GLASS_BOTTLE) && !player.level().isClientSide()) {
            player.getItemInHand(hand).hurtAndBreak(1, (LivingEntity)player, Player.getSlotForHand((InteractionHand)hand));
            player.addEffect(new MobEffectInstance(GigStatusEffects.DNA, 1000, 0));
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.hurt(GigDamageSources.of(player.level(), GigDamageSources.ACID), CommonMod.config.acidDamage);
                AdvancementHolder advancement = serverPlayer.server.getAdvancements().get(Constants.modResource("dontgoobottle"));
                if (advancement != null && !serverPlayer.getAdvancements().getOrStartProgress(advancement).isDone()) {
                    for (String s : serverPlayer.getAdvancements().getOrStartProgress(advancement).getRemainingCriteria()) {
                        serverPlayer.getAdvancements().award(advancement, s);
                    }
                }
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.interact(player, hand);
    }
}

