/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper.managers;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.entity.ai.nav.GigNavigation;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.ai.navigation.PathNavigation;

public class StasisManager {
    private static final String STASIS_TAG_KEY = "isStasis";
    private static final String STASIS_TICK_KEY = "statisTicks";
    private final AlienEntity entity;
    private int stasisTicks = 0;
    private final EntityDataAccessor<Boolean> isStasisEDA;
    private final EntityDataAccessor<Integer> statisTickCounterEDA;

    public StasisManager(AlienEntity entity, EntityDataAccessor<Boolean> isStasisEDA, EntityDataAccessor<Integer> statisTickCounterEDA) {
        this.entity = entity;
        this.isStasisEDA = isStasisEDA;
        this.statisTickCounterEDA = statisTickCounterEDA;
    }

    public void tick() {
        PathNavigation pathNavigation;
        if (this.entity.level().isClientSide) {
            return;
        }
        if (this.entity.isAggressive() || this.entity.isExecuting()) {
            this.stasisTicks = 0;
            this.setStasis(false);
        }
        if (this.entity.stasisManager.isStasis() && (pathNavigation = this.entity.getNavigation()) instanceof GigNavigation) {
            GigNavigation gigNav = (GigNavigation)pathNavigation;
            gigNav.stop();
        }
        if (this.isStasis() && this.entity.isAggressive()) {
            this.entity.animationDispatcher.sendStatisLeave();
            this.stasisTicks = 0;
            this.setStasis(false);
        }
        if (!(this.isStasis() || this.entity.isAggressive() || this.entity.isExecuting() || this.entity.isVehicle())) {
            this.setStasisTickCounter(this.stasisTicks++);
        }
        if (!(this.isStasis() || this.entity.isAggressive() || this.entity.isExecuting() || this.entity.isVehicle() || this.stasisTicks <= 6000)) {
            this.setStasis(true);
            this.stasisTicks = 0;
        }
    }

    public void setStasis(boolean searching) {
        this.entity.getEntityData().set(this.isStasisEDA, (Object)searching);
    }

    public boolean isStasis() {
        return (Boolean)this.entity.getEntityData().get(this.isStasisEDA);
    }

    public int getStasisTickCounter() {
        return (Integer)this.entity.getEntityData().get(this.statisTickCounterEDA);
    }

    public void setStasisTickCounter(int counter) {
        this.entity.getEntityData().set(this.statisTickCounterEDA, (Object)counter);
    }

    public void load(CompoundTag compoundTag) {
        this.entity.getEntityData().set(this.isStasisEDA, (Object)compoundTag.getBoolean(STASIS_TAG_KEY));
        this.entity.getEntityData().set(this.statisTickCounterEDA, (Object)compoundTag.getInt(STASIS_TICK_KEY));
    }

    public void save(CompoundTag compoundTag) {
        compoundTag.putBoolean(STASIS_TAG_KEY, ((Boolean)this.entity.getEntityData().get(this.isStasisEDA)).booleanValue());
        compoundTag.putInt(STASIS_TICK_KEY, ((Integer)this.entity.getEntityData().get(this.statisTickCounterEDA)).intValue());
    }
}

