/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.helper.managers;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;

public class SearchingManager {
    private static final String SEARCHING_TAG_KEY = "searching";
    private final AlienEntity entity;
    private final EntityDataAccessor<Boolean> isSearchingEDA;

    public SearchingManager(AlienEntity entity, EntityDataAccessor<Boolean> isSearchingEDA) {
        this.entity = entity;
        this.isSearchingEDA = isSearchingEDA;
    }

    public void tick() {
        if (this.entity.level().isClientSide) {
            return;
        }
        if (this.isSearching() && !this.entity.moveAnalysis.isMoving() && this.entity.wakeupCounter >= 3) {
            this.setSearching(false);
        }
        if (this.entity.isAggressive()) {
            this.setSearching(false);
        }
    }

    public void setSearching(boolean searching) {
        this.entity.getEntityData().set(this.isSearchingEDA, (Object)searching);
    }

    public boolean isSearching() {
        return (Boolean)this.entity.getEntityData().get(this.isSearchingEDA);
    }

    public void load(CompoundTag compoundTag) {
        this.entity.getEntityData().set(this.isSearchingEDA, (Object)compoundTag.getBoolean(SEARCHING_TAG_KEY));
    }

    public void save(CompoundTag compoundTag) {
        compoundTag.putBoolean(SEARCHING_TAG_KEY, ((Boolean)this.entity.getEntityData().get(this.isSearchingEDA)).booleanValue());
    }
}

