/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.nest;

import java.util.EnumSet;
import mod.azure.azurelib.sblforked.util.RandomUtil;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class EggmorphGoal
extends Goal {
    protected final AlienEntity mob;

    public EggmorphGoal(AlienEntity mob) {
        this.mob = mob;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        return this.mob.hasHomeBlock() && this.mob.isVehicle();
    }

    public boolean canContinueToUse() {
        return this.mob.hasHomeBlock() && !this.mob.isFleeing() && this.mob.isVehicle() && !this.mob.stasisManager.isStasis();
    }

    public void start() {
    }

    public void stop() {
    }

    public void tick() {
        if (this.mob.hasHomeBlock() && this.isPathfindable(this.mob.getHomeBlock())) {
            BlockPos blockPos = this.mob.getHomeBlock();
            Vec3 centerPos = Vec3.atCenterOf((Vec3i)blockPos);
            Vec3 blockCenter = Vec3.atCenterOf((Vec3i)blockPos);
            Vec3 entityPos = this.mob.position();
            Entity passenger = this.mob.getFirstPassenger();
            BlockPos test = RandomUtil.getRandomPositionWithinRange((BlockPos)this.mob.blockPosition(), (int)3, (int)1, (int)3, (boolean)false, (Level)this.mob.level());
            this.mob.getNavigation().moveTo(centerPos.x, centerPos.y, centerPos.z, (double)0.8f);
        }
    }

    private boolean isPathfindable(BlockPos blockPos) {
        return this.mob.getNavigation().createPath(blockPos, 0) != null;
    }
}

