/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.movement;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;

public class PanicGoal
extends Goal {
    protected final AlienEntity mob;

    public PanicGoal(AlienEntity mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        return this.mob.getLastHurtByMob() != null && this.mob.isAlive();
    }

    public void start() {
        this.mob.setAggressive(false);
        this.mob.setFleeingStatus(true);
    }

    public void stop() {
        this.mob.setFleeingStatus(false);
    }

    public void tick() {
        if (this.mob.getNavigation().isDone() && this.mob.getLastHurtByMob() != null) {
            LivingEntity lastAttacker = this.mob.getLastHurtByMob();
            Vec3 attackerPos = lastAttacker.position();
            Vec3 randomDirection = this.getRandomDirectionAwayFrom(attackerPos).normalize().scale(30.0);
            Vec3 mobPosition = this.mob.position();
            Vec3 targetPos = mobPosition.add(randomDirection);
            this.mob.getNavigation().moveTo(targetPos.x, targetPos.y, targetPos.z, 1.0);
        }
    }

    private Vec3 getRandomDirectionAwayFrom(Vec3 attackerPos) {
        Vec3 mobPosition = this.mob.position();
        Vec3 directionAwayFromAttacker = mobPosition.subtract(attackerPos);
        double randomOffsetX = this.mob.getRandom().nextDouble() - 0.5;
        double randomOffsetZ = this.mob.getRandom().nextDouble() - 0.5;
        return directionAwayFromAttacker.add(randomOffsetX, 0.0, randomOffsetZ);
    }
}

