/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.source.GigDamageSources;
import net.minecraft.world.entity.ai.goal.Goal;

public class HeadBiteGoal
extends Goal {
    protected final AlienEntity mob;
    private int executionTimer;

    public HeadBiteGoal(AlienEntity mob) {
        this.mob = mob;
    }

    public boolean canUse() {
        return this.mob.isVehicle();
    }

    public boolean canContinueToUse() {
        return this.mob.isVehicle();
    }

    public void start() {
        this.executionTimer = 0;
    }

    public void stop() {
        this.mob.setIsBiting(false);
        this.mob.setIsExecuting(false);
        this.executionTimer = 0;
    }

    public void tick() {
        if (!this.mob.level().isClientSide) {
            ++this.executionTimer;
        }
        if (this.executionTimer >= 540) {
            this.mob.getNavigation().stop();
            this.mob.setSpeed(0.0f);
        }
        if (this.executionTimer == 560) {
            this.mob.animationDispatcher.sendExecution();
            this.mob.setIsExecuting(true);
        }
        if (this.executionTimer == 600) {
            this.mob.heal(50.0f);
            if (this.mob.getFirstPassenger() != null) {
                this.mob.getFirstPassenger().hurt(GigDamageSources.of(this.mob.level(), GigDamageSources.EXECUTION), 2.1474836E9f);
            }
            this.mob.setIsBiting(false);
            this.mob.setIsExecuting(false);
            this.executionTimer = 0;
        }
    }
}

