/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.SplittableRandom;
import mods.cybercat.gigeresque.common.entity.ai.goals.attack.DelayedAttackGoal;
import mods.cybercat.gigeresque.common.entity.impl.mutant.PopperEntity;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;

public class ExplodeGoal
extends DelayedAttackGoal {
    public ExplodeGoal(PopperEntity mob, double speedModifier, int delayTicksBeforeAttack) {
        super(mob, speedModifier, delayTicksBeforeAttack);
    }

    @Override
    public void checkAndPerformAttack(LivingEntity target) {
        PathfinderMob pathfinderMob;
        if (this.canPerformAttack(target) && (pathfinderMob = this.mob) instanceof PopperEntity) {
            PopperEntity popperEntity = (PopperEntity)pathfinderMob;
            if (this.delayBeforeAttack > 0) {
                --this.delayBeforeAttack;
                if (this.delayBeforeAttack == this.delayTicksBeforeAttack && !this.triggeredAttackAnimation) {
                    popperEntity.animationSelector.select(popperEntity);
                    this.triggeredAttackAnimation = true;
                }
            } else {
                SplittableRandom random = new SplittableRandom();
                int randomPhase = random.nextInt(0, 100);
                if (randomPhase >= 90) {
                    popperEntity.explode();
                    this.mob.remove(Entity.RemovalReason.KILLED);
                } else {
                    this.mob.doHurtTarget((Entity)target);
                    this.mob.swing(InteractionHand.MAIN_HAND);
                }
                this.resetAttackCooldown();
                this.triggeredAttackAnimation = false;
            }
        } else {
            this.delayBeforeAttack = this.adjustedTickDelay(10);
            this.triggeredAttackAnimation = false;
        }
    }
}

