/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.EnumSet;
import java.util.Optional;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class EatFoodItemGoal
extends Goal {
    protected final AlienEntity mob;
    private final double speedModifier;
    private double pathedTargetX;
    private double pathedTargetY;
    private double pathedTargetZ;
    private int ticksUntilNextPathRecalculation;
    private int ticksUntilNextAttack;
    int delayBeforeAttack;
    boolean triggeredAttackAnimation;
    protected final int delayTicksBeforeAttack;
    private long lastCanUseCheck;
    private static final long COOLDOWN_BETWEEN_CAN_USE_CHECKS = 20L;

    public EatFoodItemGoal(AlienEntity mob, double speedModifier, int delayTicksBeforeAttack) {
        this.mob = mob;
        this.speedModifier = speedModifier;
        this.delayTicksBeforeAttack = delayTicksBeforeAttack;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        if (this.mob.isBirthed() || this.mob.getGrowth() < 10.0f) {
            return false;
        }
        long gameTime = this.mob.level().getGameTime();
        if (gameTime - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = gameTime;
        return this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(15.0)).stream().anyMatch(entity -> {
            ItemStack itemStack = entity.getItem();
            return itemStack.is(GigTags.BURSTER_FOODS) && entity.isAlive() && !entity.hasPickUpDelay();
        });
    }

    public boolean canContinueToUse() {
        if (this.mob.isBirthed() || this.mob.getGrowth() < 10.0f) {
            return false;
        }
        return this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(15.0)).stream().anyMatch(entity -> {
            ItemStack itemStack = entity.getItem();
            return itemStack.is(GigTags.BURSTER_FOODS) && entity.isAlive() && !entity.hasPickUpDelay();
        });
    }

    public void start() {
        this.ticksUntilNextPathRecalculation = 0;
        this.ticksUntilNextAttack = 0;
        this.delayBeforeAttack = 0;
        this.triggeredAttackAnimation = false;
    }

    public boolean requiresUpdateEveryTick() {
        return true;
    }

    public void tick() {
        Optional target = this.mob.level().getEntitiesOfClass(ItemEntity.class, this.mob.getBoundingBox().inflate(15.0)).stream().findFirst();
        if (target.isPresent()) {
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.ticksUntilNextPathRecalculation == 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || ((ItemEntity)target.get()).distanceToSqr(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.getRandom().nextFloat() < 0.05f)) {
                this.pathedTargetX = ((ItemEntity)target.get()).getX();
                this.pathedTargetY = ((ItemEntity)target.get()).getY();
                this.pathedTargetZ = ((ItemEntity)target.get()).getZ();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.getRandom().nextInt(7);
                double d0 = this.mob.distanceToSqr((Entity)target.get());
                if (d0 > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (d0 > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.getNavigation().moveTo((Entity)target.get(), this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.adjustedTickDelay(this.ticksUntilNextPathRecalculation);
            }
            this.ticksUntilNextAttack = Math.max(this.ticksUntilNextAttack - 1, 0);
            this.mob.getNavigation().moveTo((Entity)target.get(), this.speedModifier);
        }
    }
}

