/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.entity.ai.goals.attack;

import java.util.function.Predicate;
import java.util.stream.Stream;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.entity.AlienEntity;
import mods.cybercat.gigeresque.common.tags.GigTags;
import mods.cybercat.gigeresque.common.util.GigEntityUtils;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.level.block.state.BlockState;

public class DelayedClassicAttackGoal
extends MeleeAttackGoal {
    private int delayBeforeAttack;
    private boolean triggeredAttackAnimation;
    private final int delayTicksBeforeAttack;
    public static final Predicate<BlockState> NEST = state -> state.is(GigBlocks.NEST_RESIN_WEB_CROSS.get());

    public DelayedClassicAttackGoal(AlienEntity mob, double speedModifier, int delayTicksBeforeAttack) {
        super((PathfinderMob)mob, speedModifier, true);
        this.delayTicksBeforeAttack = delayTicksBeforeAttack;
    }

    public boolean canUse() {
        if (this.mob.isVehicle()) {
            return false;
        }
        if (this.mob.getTarget() != null && this.mob.getTarget().getInBlockState().is(GigBlocks.NEST_RESIN_WEB_CROSS.get())) {
            return false;
        }
        return super.canUse();
    }

    public boolean canContinueToUse() {
        if (this.mob.isVehicle()) {
            return false;
        }
        if (this.mob.getTarget() != null && this.mob.getTarget().getInBlockState().is(GigBlocks.NEST_RESIN_WEB_CROSS.get())) {
            return false;
        }
        return super.canContinueToUse();
    }

    public void start() {
        super.start();
        this.delayBeforeAttack = 0;
        this.triggeredAttackAnimation = false;
    }

    public void stop() {
        LivingEntity livingentity = this.mob.getTarget();
        if (!EntitySelector.NO_CREATIVE_OR_SPECTATOR.test(livingentity)) {
            this.mob.setTarget(null);
        }
        this.mob.setAggressive(false);
    }

    protected void checkAndPerformAttack(LivingEntity target) {
        PathfinderMob pathfinderMob;
        Stream nearbyBlocks = this.mob.level().getBlockStatesIfLoaded(this.mob.getBoundingBox().inflate(18.0));
        int randomPhase = this.mob.getRandom().nextInt(0, 100);
        if (this.canPerformAttack(target) && (pathfinderMob = this.mob) instanceof AlienEntity) {
            AlienEntity mob = (AlienEntity)pathfinderMob;
            if (this.mob.isVehicle()) {
                return;
            }
            if (this.delayBeforeAttack > 0) {
                --this.delayBeforeAttack;
                if (this.delayBeforeAttack == this.delayTicksBeforeAttack && !this.triggeredAttackAnimation) {
                    mob.animationSelector.select(mob);
                    this.triggeredAttackAnimation = true;
                }
            } else {
                if (this.isTargetValidForExecution(target)) {
                    if (GigEntityUtils.isTargetHostable((Entity)target) && !mob.isInWater()) {
                        if (this.shouldNestBehavior(nearbyBlocks, randomPhase) || this.shouldBiteBehavior(target, randomPhase)) {
                            mob.grabTarget((Entity)target);
                        }
                    } else if (!mob.isVehicle()) {
                        mob.swing(InteractionHand.MAIN_HAND);
                        mob.doHurtTarget((Entity)target);
                    }
                } else {
                    mob.swing(InteractionHand.MAIN_HAND);
                    mob.doHurtTarget((Entity)target);
                }
                this.resetAttackCooldown();
                this.triggeredAttackAnimation = false;
            }
        } else {
            this.delayBeforeAttack = this.adjustedTickDelay(10);
            this.triggeredAttackAnimation = false;
        }
    }

    private boolean isTargetValidForExecution(LivingEntity target) {
        return !target.getType().is(GigTags.XENO_EXECUTE_BLACKLIST);
    }

    private boolean shouldNestBehavior(Stream<BlockState> nearbyBlocks, int randomPhase) {
        return nearbyBlocks.anyMatch(NEST) && randomPhase >= 50;
    }

    private boolean shouldBiteBehavior(LivingEntity target, int randomPhase) {
        return (double)target.getHealth() <= (double)target.getMaxHealth() * 0.5 && randomPhase >= 80;
    }
}

