/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import mods.cybercat.gigeresque.common.block.AbstractNestBlock;
import mods.cybercat.gigeresque.common.block.NestResinWebVariant;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NestResinWebBlock
extends AbstractNestBlock {
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    protected static final Map<Direction, BooleanProperty> FACING_PROPERTIES = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(entry -> entry.getKey() != Direction.DOWN).collect(Util.toMap());
    public static final EnumProperty<NestResinWebVariant> VARIANTS = EnumProperty.create((String)"nest_resin_web_variant", NestResinWebVariant.class);
    private static final VoxelShape UP_SHAPE = NestResinWebBlock.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_SHAPE = NestResinWebBlock.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_SHAPE = NestResinWebBlock.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SOUTH_SHAPE = NestResinWebBlock.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape NORTH_SHAPE = NestResinWebBlock.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesByState;
    private final Random random = new Random();

    public NestResinWebBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue(VARIANTS, (Comparable)((Object)NestResinWebVariant.ONE)));
        this.shapesByState = this.getStateDefinition().getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), NestResinWebBlock::getShapeForState));
    }

    private static VoxelShape getShapeForState(BlockState state) {
        VoxelShape voxelShape = Shapes.empty();
        if (Boolean.TRUE.equals(state.getValue((Property)UP))) {
            voxelShape = UP_SHAPE;
        }
        if (Boolean.TRUE.equals(state.getValue((Property)NORTH))) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)SOUTH_SHAPE);
        }
        if (Boolean.TRUE.equals(state.getValue((Property)SOUTH))) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)NORTH_SHAPE);
        }
        if (Boolean.TRUE.equals(state.getValue((Property)EAST))) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)WEST_SHAPE);
        }
        if (Boolean.TRUE.equals(state.getValue((Property)WEST))) {
            voxelShape = Shapes.or((VoxelShape)voxelShape, (VoxelShape)EAST_SHAPE);
        }
        return voxelShape.isEmpty() ? Shapes.block() : voxelShape;
    }

    public static boolean shouldConnectTo(LevelReader world, BlockPos pos, Direction direction) {
        BlockState blockState = world.getBlockState(pos);
        return NestResinWebBlock.isFaceFull((VoxelShape)blockState.getCollisionShape((BlockGetter)world, pos), (Direction)direction.getOpposite());
    }

    public static BooleanProperty getFacingProperty(Direction direction) {
        return FACING_PROPERTIES.get(direction);
    }

    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.shapesByState.get(state);
    }

    public boolean propagatesSkylightDown(@NotNull BlockState state, @NotNull BlockGetter world, @NotNull BlockPos pos) {
        return true;
    }

    public boolean canSurvive(@NotNull BlockState state, @NotNull LevelReader world, @NotNull BlockPos pos) {
        return this.hasAdjacentBlocks(this.getPlacementShape(state, world, pos));
    }

    private boolean hasAdjacentBlocks(BlockState state) {
        return this.getAdjacentBlockCount(state) > 0;
    }

    private int getAdjacentBlockCount(BlockState state) {
        int[] i = new int[]{0};
        FACING_PROPERTIES.values().forEach(it -> {
            if (Boolean.TRUE.equals(state.getValue((Property)it))) {
                i[0] = i[0] + 1;
            }
        });
        return i[0];
    }

    private boolean shouldHaveSide(LevelReader world, BlockPos pos, Direction side) {
        if (side == Direction.DOWN) {
            return false;
        }
        BlockPos blockPos = pos.relative(side);
        if (NestResinWebBlock.shouldConnectTo(world, blockPos, side)) {
            return true;
        }
        if (side.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BlockState blockState = world.getBlockState(pos.above());
        return blockState.is((Block)this) && (Boolean)blockState.getValue((Property)FACING_PROPERTIES.get(side)) != false;
    }

    private BlockState getPlacementShape(BlockState state, LevelReader world, BlockPos pos) {
        BlockPos blockPos = pos.above();
        if (Boolean.TRUE.equals(state.getValue((Property)UP))) {
            state = (BlockState)state.setValue((Property)UP, (Comparable)Boolean.valueOf(NestResinWebBlock.shouldConnectTo(world, blockPos, Direction.DOWN)));
        }
        BlockState blockState = null;
        Iterator iterator = Direction.Plane.HORIZONTAL.iterator();
        while (iterator.hasNext()) {
            Direction direction = (Direction)iterator.next();
            BooleanProperty booleanProperty = NestResinWebBlock.getFacingProperty(direction);
            if (!Boolean.TRUE.equals(state.getValue((Property)booleanProperty))) continue;
            boolean bl = this.shouldHaveSide(world, pos, direction);
            if (!bl) {
                if (blockState == null) {
                    blockState = world.getBlockState(blockPos);
                }
                bl = blockState.is((Block)this) && (Boolean)blockState.getValue((Property)booleanProperty) != false;
            }
            state = (BlockState)state.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(bl));
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (direction == Direction.DOWN) {
            return super.updateShape(state, direction, neighborState, world, pos, neighborPos);
        }
        BlockState blockState = this.getPlacementShape(state, (LevelReader)world, pos);
        return !this.hasAdjacentBlocks(blockState) ? Blocks.AIR.defaultBlockState() : blockState;
    }

    public boolean canBeReplaced(@NotNull BlockState state, BlockPlaceContext context) {
        BlockState blockState = context.getLevel().getBlockState(context.getClickedPos());
        return blockState.is((Block)this) ? this.getAdjacentBlockCount(blockState) < FACING_PROPERTIES.size() : super.canBeReplaced(state, context);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext ctx) {
        Direction[] placementDirections;
        BlockState blockState = ctx.getLevel().getBlockState(ctx.getClickedPos());
        boolean bl = blockState.is((Block)this);
        BlockState blockState2 = bl ? blockState : this.defaultBlockState();
        for (Direction direction : placementDirections = ctx.getNearestLookingDirections()) {
            boolean bl2;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanProperty = NestResinWebBlock.getFacingProperty(direction);
            boolean bl3 = bl2 = bl && (Boolean)blockState.getValue((Property)booleanProperty) != false;
            if (bl2 || !this.shouldHaveSide((LevelReader)ctx.getLevel(), ctx.getClickedPos(), direction)) continue;
            return (BlockState)((BlockState)blockState2.setValue((Property)booleanProperty, (Comparable)Boolean.valueOf(true))).setValue(VARIANTS, (Comparable)((Object)Arrays.stream(NestResinWebVariant.values()).toList().get(this.random.nextInt(NestResinWebVariant.values().length))));
        }
        return bl ? blockState2 : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{UP, NORTH, EAST, SOUTH, WEST, VARIANTS});
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.CLOCKWISE_180 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            case Rotation.COUNTERCLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Rotation.CLOCKWISE_90 -> (BlockState)((BlockState)((BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)SOUTH)));
            default -> state;
        };
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirror) {
        return switch (mirror) {
            case Mirror.LEFT_RIGHT -> (BlockState)((BlockState)state.setValue((Property)NORTH, (Comparable)((Boolean)state.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)state.getValue((Property)NORTH)));
            case Mirror.FRONT_BACK -> (BlockState)((BlockState)state.setValue((Property)EAST, (Comparable)((Boolean)state.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)state.getValue((Property)EAST)));
            default -> super.mirror(state, mirror);
        };
    }
}

