/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import mods.cybercat.gigeresque.common.block.GigBlock;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MuralBlock
extends GigBlock {
    public MuralBlock() {
        super(BlockBehaviour.Properties.of().strength(3.0f, 6.0f).sound(SoundType.NETHERRACK).explosionResistance(10.0f));
    }

    public void playerDestroy(@NotNull Level level, @NotNull Player player, @NotNull BlockPos pos, @NotNull BlockState state, BlockEntity blockEntity, @NotNull ItemStack stack) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.setBlock(pos, GigBlocks.ROUGH_ALIEN_BLOCK.get().defaultBlockState(), 3);
            AreaEffectCloud areaEffectCloudEntity = new AreaEffectCloud((Level)serverLevel, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
            areaEffectCloudEntity.setRadius(1.0f);
            areaEffectCloudEntity.setDuration(60);
            areaEffectCloudEntity.setRadiusPerTick(-areaEffectCloudEntity.getRadius() / (float)areaEffectCloudEntity.getDuration());
            areaEffectCloudEntity.addEffect(new MobEffectInstance(GigStatusEffects.DNA, 600, 0));
            serverLevel.addFreshEntity((Entity)areaEffectCloudEntity);
        }
        super.playerDestroy(level, player, pos, state, blockEntity, stack);
    }
}

