/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.particle.GigParticles;
import mods.cybercat.gigeresque.common.block.GigBlocks;
import mods.cybercat.gigeresque.common.sound.GigSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class GigBlock
extends Block {
    public GigBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public void animateTick(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        super.animateTick(state, level, pos, random);
        double offsetX = random.nextDouble() - 0.5;
        double offsetY = 1.1 + random.nextDouble() * 1.3;
        double offsetZ = random.nextDouble() - 0.5;
        if ((level.getBlockState(pos.above()).isAir() || level.getBlockState(pos.above()).is(GigBlocks.ALIEN_STORAGE_BLOCK_2.get())) && pos.getY() <= -50 && Constants.particleCount < 1500) {
            level.addParticle((ParticleOptions)GigParticles.MIST.get(), (double)pos.getX() + 0.5 + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + 0.5 + offsetZ, 0.0, 0.002, 0.0);
        }
        if (!level.getBlockState(pos.above()).isAir() && random.nextInt(1000) == 0) {
            level.playLocalSound(pos, GigSounds.DUNGEON_IDLE.get(), SoundSource.BLOCKS, 0.2f, 0.5f, true);
        }
    }
}

