/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.common.block;

import java.util.List;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.common.tags.GigTags;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;

public class BeaconBlock
extends Block {
    public BeaconBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.DRIPSTONE_BLOCK).strength(Float.MAX_VALUE, Float.MAX_VALUE).noOcclusion().noLootTable().randomTicks().noTerrainParticles().lightLevel(blockState -> 2));
    }

    protected void randomTick(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (!level.isClientSide()) {
            List nearbyPlayers = level.getEntitiesOfClass(Player.class, new AABB(pos).inflate(30.0));
            for (Player player : nearbyPlayers) {
                if (player.getBlockStateOn().is(GigTags.DUNGEON_BLOCKS) || player.hasEffect(MobEffects.DARKNESS) || !Constants.isNotCreativeSpecPlayer.test((Entity)player)) continue;
                player.addEffect(new MobEffectInstance(MobEffects.DARKNESS, 200, 10));
                level.playSound(null, pos, SoundEvents.SCULK_SHRIEKER_SHRIEK, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    protected boolean isRandomlyTicking(@NotNull BlockState state) {
        return true;
    }
}

