/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.particle;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import mods.cybercat.gigeresque.Constants;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class MistParticle
extends TextureSheetParticle {
    private float xdxd;
    private float zdzd;
    protected BlockPos.MutableBlockPos pos;
    private static final float FADE_DURATION = 40.0f;
    private float targetAlpha = 0.6f;
    boolean shouldFadeOut = false;

    public MistParticle(ClientLevel level, double x, double y, double z, SpriteSet provider) {
        super(level, x, y, z);
        this.setSize(1.0E-4f, 1.0E-4f);
        this.lifetime = 30000;
        this.alpha = 0.0f;
        this.pos = new BlockPos.MutableBlockPos(x, y, z);
        ++Constants.particleCount;
        this.hasPhysics = true;
        this.setSprite(provider.get(level.getRandom()));
        this.lifetime = 30000;
        this.quadSize = 1.5f;
        this.setColor(0.678f, 0.847f, 0.902f);
        this.oRoll = this.roll = level.random.nextFloat() * (float)Math.PI;
        this.xdxd = (this.random.nextFloat() - 0.5f) / 100.0f;
        this.zdzd = (this.random.nextFloat() - 0.5f) / 100.0f;
    }

    public void tick() {
        super.tick();
        this.pos.set(this.x, this.y - 0.2, this.z);
        this.removeIfOOB();
        if (this.shouldFadeOut) {
            this.fadeOut();
        } else {
            this.fadeIn();
        }
        if (this.onGround) {
            this.remove();
        }
        this.xd = this.xdxd;
        this.zd = this.zdzd;
        this.gravity = 2.0E-4f;
    }

    public void fadeIn() {
        if ((float)this.age < 40.0f) {
            float progress = (float)this.age / 40.0f;
            this.alpha = Mth.lerp((float)progress, (float)0.0f, (float)this.targetAlpha);
            this.quadSize = Mth.lerp((float)progress, (float)0.0f, (float)1.5f);
        }
    }

    public void fadeOut() {
        float progress = Math.min(((float)this.age - ((float)this.lifetime - 40.0f)) / 40.0f, 1.0f);
        if (progress > 0.0f) {
            this.alpha = Mth.lerp((float)progress, (float)this.targetAlpha, (float)0.0f);
            this.quadSize = Mth.lerp((float)progress, (float)1.5f, (float)0.0f);
            if (progress >= 1.0f) {
                this.remove();
            }
        }
    }

    public void remove() {
        if (this.isAlive()) {
            --Constants.particleCount;
        }
        super.remove();
    }

    void removeIfOOB() {
        Entity cameraEntity = Minecraft.getInstance().getCameraEntity();
        if (cameraEntity == null || cameraEntity.distanceToSqr(this.x, this.y, this.z) > (double)Mth.square((int)25)) {
            this.shouldFadeOut = true;
        }
    }

    public void render(VertexConsumer vertexConsumer, Camera camera, float f) {
        Vec3 camPos = camera.getPosition();
        float x = (float)(Mth.lerp((double)f, (double)this.xo, (double)this.x) - camPos.x());
        float y = (float)(Mth.lerp((double)f, (double)this.yo, (double)this.y) - camPos.y());
        float z = (float)(Mth.lerp((double)f, (double)this.zo, (double)this.z) - camPos.z());
        Vector3f localPos = new Vector3f(x, y, z);
        Quaternionf quaternion = Axis.YP.rotation((float)Math.atan2(x, z) + (float)Math.PI);
        float yAngle = (float)Math.asin(y / localPos.length());
        quaternion.rotateX(yAngle);
        quaternion.rotateZ((float)Math.atan2(x, z));
        if (yAngle < -1.0f) {
            this.shouldFadeOut = true;
        }
        quaternion.rotateZ(Mth.lerp((float)f, (float)this.oRoll, (float)this.roll));
        this.renderRotatedQuad(vertexConsumer, quaternion, x, y, z, f);
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT;
    }
}

