/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.rom;

import com.mojang.blaze3d.vertex.PoseStack;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRenderer;
import mod.azure.azurelib.rewrite.render.entity.AzEntityRendererConfig;
import mods.cybercat.gigeresque.Constants;
import mods.cybercat.gigeresque.client.entity.model.EntityModels;
import mods.cybercat.gigeresque.client.entity.texture.EntityTextures;
import mods.cybercat.gigeresque.common.entity.animators.rom.RomAlienAnimator;
import mods.cybercat.gigeresque.common.entity.helper.managers.animations.rom.RomAlienAnimManager;
import mods.cybercat.gigeresque.common.entity.impl.rom.RomAlienEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;

public class RomAlienRenderer
extends AzEntityRenderer<RomAlienEntity> {
    private static final ResourceLocation MODEL = Constants.modResource("geo/entity/rom_alien/rom_alien.geo.json");

    protected RomAlienRenderer(EntityRendererProvider.Context context) {
        super(AzEntityRendererConfig.builder($ -> EntityModels.ROM_ALIEN, xeno -> {
            float progress = Math.max(0.0f, Math.min(1.0f - xeno.getGrowth() / xeno.getMaxGrowth(), 1.0f));
            if (xeno.stasisManager.isStasis()) {
                return EntityTextures.ROM_ALIEN_STATIS;
            }
            if (progress > 0.0f) {
                return EntityTextures.ROM_ALIEN_YOUNG;
            }
            return EntityTextures.ROM_ALIEN;
        }).setAnimatorProvider(RomAlienAnimator::new).setDeathMaxRotation(0.0f).build(), context);
    }

    public void render(RomAlienEntity entity, float entityYaw, float partialTick, PoseStack stack, @NotNull MultiBufferSource bufferSource, int packedLightIn) {
        float scaleFactor = 0.8f + entity.getGrowth() / entity.getMaxGrowth() / 5.0f;
        stack.scale(scaleFactor, scaleFactor, scaleFactor);
        RomAlienAnimManager.handleAnimations(entity);
        super.render((Entity)entity, entityYaw, partialTick, stack, bufferSource, packedLightIn);
    }
}

