/*
 * Decompiled with CFR 0.152.
 */
package mods.cybercat.gigeresque.client.entity.render.feature;

import com.mojang.blaze3d.vertex.VertexConsumer;
import mod.azure.azurelib.core.object.Color;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import mods.cybercat.gigeresque.CommonMod;
import mods.cybercat.gigeresque.client.entity.render.feature.EggmorphFeatureRenderer;
import mods.cybercat.gigeresque.common.status.effect.GigStatusEffects;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EggmorphGeoFeatureRenderer<T extends Entity>
implements AzRenderLayer<T> {
    private int fovEggticker = 0;

    public void preRender(AzRendererPipelineContext<T> context) {
    }

    public void render(AzRendererPipelineContext<T> context) {
        LivingEntity livingEntity;
        Entity animatable = (Entity)context.animatable();
        AzRendererPipeline renderPipeline = context.rendererPipeline();
        MultiBufferSource bufferSource = context.multiBufferSource();
        ResourceLocation textureLocation = renderPipeline.config().textureLocation((Object)animatable);
        RenderType renderLayer = EggmorphFeatureRenderer.getEggmorphLayerTexture((ResourceLocation)textureLocation).renderLayer;
        if (animatable instanceof LivingEntity && (livingEntity = (LivingEntity)animatable).hasEffect(GigStatusEffects.EGGMORPHING)) {
            ++this.fovEggticker;
            float progress = Math.max(0.0f, Math.min((float)this.fovEggticker / CommonMod.config.getEggmorphTickTimer(), 1.0f));
            VertexConsumer vertexConsumer = bufferSource.getBuffer(renderLayer);
            vertexConsumer.setColor(1.0f, 1.0f, 1.0f, progress);
            context.setRenderColor(Color.ofRGBA((float)1.0f, (float)1.0f, (float)1.0f, (float)progress).getColor());
            renderPipeline.reRender(context);
        }
    }

    public void renderForBone(AzRendererPipelineContext<T> context, AzBone bone) {
    }
}

